/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2AuthModule;
import com.mindbright.ssh2.SSH2Interactor;
import com.mindbright.ssh2.SSH2TransportPDU;
import com.mindbright.ssh2.SSH2UserAuth;
import com.mindbright.ssh2.SSH2UserCancelException;

public class SSH2AuthPassword
implements SSH2AuthModule {
    public static final String STANDARD_NAME = "password";
    private String password;
    private String newPassword;
    private SSH2Interactor interactor;
    private String prompt;

    public SSH2AuthPassword(String string) {
        this(null, null, string);
    }

    public SSH2AuthPassword(SSH2Interactor sSH2Interactor, String string) {
        this(sSH2Interactor, string, null);
    }

    public SSH2AuthPassword(SSH2Interactor sSH2Interactor, String string, String string2) {
        this.interactor = sSH2Interactor;
        this.prompt = string;
        this.setPassword(string2);
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setNewPassword(String string) {
        this.newPassword = string;
    }

    protected String getPassword() throws SSH2UserCancelException {
        if (this.password != null) {
            String string = new String(this.password);
            this.password = null;
            return string;
        }
        if (this.interactor != null) {
            while (this.password == null) {
                this.password = this.interactor.promptLine(this.prompt, false);
            }
        } else {
            this.password = "";
        }
        return this.password;
    }

    protected String getNewPassword(String string, String string2) throws SSH2UserCancelException {
        if (this.newPassword != null) {
            return this.newPassword;
        }
        if (this.interactor != null) {
            while (this.newPassword == null) {
                this.newPassword = this.interactor.promptLine(string, false);
            }
        } else {
            this.newPassword = "";
        }
        return this.newPassword;
    }

    public String getStandardName() {
        return STANDARD_NAME;
    }

    public SSH2TransportPDU processMethodMessage(SSH2UserAuth sSH2UserAuth, SSH2TransportPDU sSH2TransportPDU) throws SSH2UserCancelException {
        switch (sSH2TransportPDU.getType()) {
            case 60: {
                String string = sSH2TransportPDU.readJavaString();
                String string2 = sSH2TransportPDU.readJavaString();
                sSH2TransportPDU = this.createChangeRequest(sSH2UserAuth, string, string2);
                break;
            }
            default: {
                sSH2UserAuth.getTransport().getLog().warning("SSH2AuthPassword", "received unexpected packet of type: " + sSH2TransportPDU.getType());
                sSH2TransportPDU = null;
            }
        }
        return sSH2TransportPDU;
    }

    public SSH2TransportPDU startAuthentication(SSH2UserAuth sSH2UserAuth) throws SSH2UserCancelException {
        SSH2TransportPDU sSH2TransportPDU = sSH2UserAuth.createUserAuthRequest(STANDARD_NAME);
        sSH2TransportPDU.writeBoolean(false);
        sSH2TransportPDU.writeUTF8String(this.getPassword());
        return sSH2TransportPDU;
    }

    private SSH2TransportPDU createChangeRequest(SSH2UserAuth sSH2UserAuth, String string, String string2) throws SSH2UserCancelException {
        SSH2TransportPDU sSH2TransportPDU = sSH2UserAuth.createUserAuthRequest(STANDARD_NAME);
        sSH2TransportPDU.writeBoolean(true);
        if (this.password != null && this.newPassword != null) {
            sSH2TransportPDU.writeUTF8String(this.getPassword());
            sSH2TransportPDU.writeUTF8String(this.getNewPassword(string, string2));
        } else {
            String[] stringArray;
            String[] stringArray2 = new String[3];
            boolean[] blArray = new boolean[]{false, false, false};
            String string3 = "";
            stringArray2[0] = "Old password: ";
            stringArray2[1] = "New password: ";
            stringArray2[2] = "Retype new password: ";
            do {
                stringArray = this.interactor.promptMultiFull("Change password", string3 + (string != null ? string : ""), stringArray2, blArray);
                string3 = "New passwords differs. ";
            } while (!stringArray[1].equals(stringArray[2]));
            sSH2TransportPDU.writeUTF8String(stringArray[0]);
            sSH2TransportPDU.writeUTF8String(stringArray[1]);
        }
        return sSH2TransportPDU;
    }

    public void clearSensitiveData() {
        this.password = null;
        this.newPassword = null;
    }

    public boolean retryPointless() {
        return this.password == null && this.interactor == null;
    }
}

