/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.ssh.SSHChannelController;
import com.mindbright.ssh.SSHCipher;
import com.mindbright.ssh.SSHConsole;
import com.mindbright.ssh.SSHInteractiveClient;
import com.mindbright.terminal.TerminalInputListener;
import com.mindbright.terminal.TerminalWin;
import com.mindbright.terminal.TerminalWindow;
import java.awt.Container;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public final class SSHStdIO
implements TerminalInputListener,
SSHConsole {
    Container ownerContainer;
    SSHChannelController controller = null;
    SSHInteractiveClient client;
    TerminalWin term;
    SSHCipher sndCipher = null;
    String ownerName;
    Boolean readLineLock = new Boolean(false);
    boolean isReadingLine;
    boolean terminalChange;
    boolean echoStar;
    String readLineStr;
    protected boolean isConnected = false;
    SSHExternalMessage extMsg = null;

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setTerminal(TerminalWin terminalWin) {
        this.term = terminalWin;
        if (terminalWin != null) {
            terminalWin.addInputListener(this);
        }
    }

    public void setClient(SSHInteractiveClient sSHInteractiveClient) {
        this.client = sSHInteractiveClient;
    }

    public void setOwnerContainer(Container container) {
        this.ownerContainer = container;
    }

    public void setOwnerName(String string) {
        this.ownerName = string;
    }

    public void breakPromptLine() {
        this.breakPromptLine("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakPromptLine(String string) {
        if (this.isReadingLine) {
            Boolean bl = this.readLineLock;
            synchronized (bl) {
                this.extMsg = new SSHExternalMessage(string);
                this.readLineLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine(String string) {
        Boolean bl = this.readLineLock;
        synchronized (bl) {
            if (string != null) {
                this.readLineStr = string;
                this.term.write(string);
            } else {
                this.readLineStr = "";
            }
            this.term.setDumbMode(true);
            this.isReadingLine = true;
            this.terminalChange = false;
            try {
                this.readLineLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.isReadingLine = false;
            this.term.setDumbMode(false);
            if (this.terminalChange) {
                return null;
            }
        }
        return this.readLineStr;
    }

    public String promptLine(String string, String string2, boolean bl) throws IOException {
        Object object;
        String string3 = null;
        if (this.term != null) {
            this.term.setAttributeBold(true);
            this.term.write(string);
            this.term.setAttributeBold(false);
            this.echoStar = bl;
            string3 = this.readLine(string2);
            this.echoStar = false;
        } else {
            object = new BufferedReader(new InputStreamReader(System.in));
            System.out.print(string);
            string3 = ((BufferedReader)object).readLine();
        }
        if (this.extMsg != null) {
            object = this.extMsg;
            this.extMsg = null;
            throw object;
        }
        return string3;
    }

    public void updateTitle() {
        int n = 0;
        int n2 = 0;
        if (this.term == null || this.ownerContainer == null) {
            return;
        }
        String string = null;
        string = this.term.getTitle();
        if (string == null) {
            if (this.client.isOpened()) {
                string = this.client.propsHandler.getProperty("usrname");
                string = string + "@" + this.client.propsHandler.getProperty("server");
                string = string + " <" + this.client.getServerVersion() + ">";
            } else {
                string = this.ownerName;
            }
            if (!this.client.activateTunnels) {
                string = string + " (CLONE)";
            }
        }
        n = this.term.rows();
        n2 = this.term.cols();
        string = string + " [" + n2 + "x" + n + "]";
        if (this.ownerContainer instanceof Frame) {
            ((Frame)this.ownerContainer).setTitle(string);
        }
    }

    public TerminalWindow getTerminal() {
        return this.term;
    }

    public void stdoutWriteString(byte[] byArray) {
        if (this.isConnected) {
            this.print(new String(byArray));
        }
    }

    public void stderrWriteString(byte[] byArray) {
        if (this.isConnected) {
            this.print(new String(byArray));
        }
    }

    public void print(String string) {
        if (this.term != null) {
            this.term.write(string);
        } else {
            System.out.print(string);
        }
    }

    public void println(String string) {
        if (this.term != null) {
            this.term.write(string + "\n\r");
        } else {
            System.out.println(string);
        }
    }

    public void serverConnect(SSHChannelController sSHChannelController, SSHCipher sSHCipher) {
        this.controller = sSHChannelController;
        this.sndCipher = sSHCipher;
        this.isConnected = true;
    }

    public void serverDisconnect(String string) {
        this.controller = null;
        this.sndCipher = null;
        this.isConnected = false;
        this.println(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void typedChar(char c) {
        block21: {
            try {
                if (this.isConnected) {
                    this.client.stdinWriteChar(c);
                    break block21;
                }
                Boolean bl = this.readLineLock;
                synchronized (bl) {
                    if (this.isReadingLine) {
                        if (c == '\u0003' || c == '\u0004') {
                            this.extMsg = new SSHExternalMessage("");
                            this.extMsg.ctrlC = c == '\u0003';
                            this.readLineLock.notify();
                        } else if (c == '\u007f' || c == '\b') {
                            if (this.readLineStr.length() > 0) {
                                boolean bl2 = false;
                                if (this.readLineStr.charAt(this.readLineStr.length() - 1) < ' ') {
                                    bl2 = true;
                                }
                                this.readLineStr = this.readLineStr.substring(0, this.readLineStr.length() - 1);
                                this.term.write('\b');
                                if (bl2) {
                                    this.term.write('\b');
                                }
                                this.term.write(' ');
                                if (bl2) {
                                    this.term.write(' ');
                                }
                                this.term.write('\b');
                                if (bl2) {
                                    this.term.write('\b');
                                }
                            } else {
                                this.term.ringBell();
                            }
                        } else if (c == '\r') {
                            this.readLineLock.notify();
                            this.term.write("\n\r");
                        } else {
                            this.readLineStr = this.readLineStr + c;
                            if (this.echoStar) {
                                this.term.write('*');
                            } else {
                                this.term.write(c);
                            }
                        }
                    }
                }
            }
            catch (IOException iOException) {
                System.out.println("**** Error in SSHStdIO.typedChar: " + iOException);
            }
        }
    }

    public void typedChar(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.typedChar((char)byArray[i]);
        }
    }

    public void sendBytes(byte[] byArray) {
        try {
            if (this.isConnected) {
                this.client.stdinWriteString(byArray);
            } else {
                for (int i = 0; i < byArray.length; ++i) {
                    this.typedChar((char)byArray[i]);
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("**** Error in SSHStdIO.sendBytes: " + iOException);
        }
    }

    public void sendBytesDirect(byte[] byArray) {
        try {
            if (this.isConnected) {
                this.client.stdinWriteString(byArray);
            }
        }
        catch (IOException iOException) {
            System.out.println("**** Error in SSHStdIO.sendBytesDirect: " + iOException);
        }
    }

    public void signalWindowChanged(int n, int n2, int n3, int n4) {
        if (this.isConnected) {
            this.client.signalWindowChanged(n, n2, n3, n4);
        }
        this.updateTitle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalTermTypeChanged(String string) {
        Boolean bl = this.readLineLock;
        synchronized (bl) {
            this.terminalChange = true;
            this.readLineLock.notify();
        }
    }

    public void sendBreak() {
    }

    public static class SSHExternalMessage
    extends IOException {
        public boolean ctrlC = false;
        public boolean isError;

        public SSHExternalMessage(String string) {
            super(string);
        }
    }
}

