/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.x509;

import com.mindbright.asn1.ASN1AnyDefinedBy;
import com.mindbright.asn1.ASN1BitString;
import com.mindbright.asn1.ASN1CharString;
import com.mindbright.asn1.ASN1OID;
import com.mindbright.asn1.ASN1OIDRegistry;
import com.mindbright.asn1.ASN1Object;
import com.mindbright.asn1.ASN1PrintableString;
import com.mindbright.asn1.ASN1Sequence;
import com.mindbright.security.x509.DirectoryString;

public final class AttributeTypeAndValue
extends ASN1Sequence {
    public ASN1OID type = new ASN1OID();
    public ASN1AnyDefinedBy value = new ASN1AnyDefinedBy(this.type, true);

    public AttributeTypeAndValue() {
        this.addComponent(this.type);
        this.addComponent(this.value);
    }

    public String getRFC2253Value() {
        String string = this.type.getString();
        String string2 = ASN1OIDRegistry.lookupShortName(string);
        if (string2 == null) {
            string2 = ASN1OIDRegistry.lookupName(string);
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2 + "=" + this.valueAsString();
    }

    private String valueAsString() {
        ASN1Object aSN1Object = this.value.getValue();
        String string = "<unknown>";
        if (aSN1Object instanceof DirectoryString) {
            string = ((DirectoryString)aSN1Object).getString();
        } else if (aSN1Object instanceof ASN1CharString) {
            string = ((ASN1CharString)aSN1Object).getValue();
        } else if (aSN1Object instanceof ASN1PrintableString) {
            string = ((ASN1PrintableString)aSN1Object).getValue();
        } else if (aSN1Object instanceof ASN1BitString) {
            string = ((ASN1BitString)aSN1Object).toPrintableString();
        }
        return string;
    }
}

