/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.net.ftp;

import com.mindbright.net.ftp.FTPException;
import com.mindbright.net.ftp.FTPServerEventHandler;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class FTPServer
implements Runnable {
    private Thread myThread;
    private String identity;
    private String user;
    private String password;
    private boolean keepRunning;
    private String type;
    protected InetAddress localHost;
    protected Socket dataSocket;
    protected ServerSocket dataPasvAccept;
    protected int[] dataPortAddr;
    protected boolean dataConnected;
    protected InputStream dataIn;
    protected OutputStream dataOut;
    private FTPServerEventHandler eventHandler;
    private BufferedReader cmdInput;
    private OutputStream cmdOutput;
    private boolean needPassword;
    private static final boolean DEBUG = false;
    public static final int CMD_UNKN = -1;
    public static final int CMD_USER = 0;
    public static final int CMD_PASS = 1;
    public static final int CMD_ACCT = 2;
    public static final int CMD_CWD = 3;
    public static final int CMD_CDUP = 4;
    public static final int CMD_SMNT = 5;
    public static final int CMD_QUIT = 6;
    public static final int CMD_REIN = 7;
    public static final int CMD_PORT = 8;
    public static final int CMD_PASV = 9;
    public static final int CMD_TYPE = 10;
    public static final int CMD_STRU = 11;
    public static final int CMD_MODE = 12;
    public static final int CMD_RETR = 13;
    public static final int CMD_STOR = 14;
    public static final int CMD_STOU = 15;
    public static final int CMD_APPE = 16;
    public static final int CMD_ALLO = 17;
    public static final int CMD_REST = 18;
    public static final int CMD_RNFR = 19;
    public static final int CMD_RNTO = 20;
    public static final int CMD_ABOR = 21;
    public static final int CMD_DELE = 22;
    public static final int CMD_RMD = 23;
    public static final int CMD_MKD = 24;
    public static final int CMD_PWD = 25;
    public static final int CMD_LIST = 26;
    public static final int CMD_NLST = 27;
    public static final int CMD_SITE = 28;
    public static final int CMD_SYST = 29;
    public static final int CMD_STAT = 30;
    public static final int CMD_HELP = 31;
    public static final int CMD_NOOP = 32;
    public static final int CMD_FEAT = 33;
    public static final int CMD_MDTM = 34;
    public static final int CMD_SIZE = 35;
    public static Hashtable commands = new Hashtable();

    public FTPServer(String string, FTPServerEventHandler fTPServerEventHandler, InputStream inputStream, OutputStream outputStream, boolean bl) {
        this(string, fTPServerEventHandler, null, inputStream, outputStream, bl);
    }

    public FTPServer(String string, FTPServerEventHandler fTPServerEventHandler, InetAddress inetAddress, InputStream inputStream, OutputStream outputStream, boolean bl) {
        this.identity = string;
        this.eventHandler = fTPServerEventHandler;
        this.localHost = inetAddress;
        this.cmdInput = new BufferedReader(new InputStreamReader(inputStream));
        this.cmdOutput = outputStream;
        this.needPassword = bl;
        this.dataConnected = false;
        if (this.localHost == null) {
            try {
                this.localHost = InetAddress.getByName("0.0.0.0");
            }
            catch (UnknownHostException unknownHostException) {
                throw new Error("Error in FTPServer: " + unknownHostException);
            }
        }
        this.type = "A";
        this.keepRunning = true;
        this.myThread = new Thread((Runnable)this, "FTPServer_" + string);
        this.myThread.start();
    }

    private static String[] splitLsArgs(String string) {
        String[] stringArray = new String[]{null, null};
        if (string == null) {
            return stringArray;
        }
        stringArray[1] = string = string.trim();
        try {
            if (string.startsWith("-")) {
                int n = string.indexOf(32);
                if (n == -1) {
                    stringArray[0] = string;
                    stringArray[1] = null;
                } else {
                    stringArray[0] = string.substring(0, n);
                    stringArray[1] = string.substring(n).trim();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            String[] stringArray = new String[2];
            this.reply(220, this.identity);
            boolean bl = true;
            do {
                if (!bl) {
                    this.reply(530, "Login incorrect.");
                }
                this.readLogin();
                bl = false;
            } while (!this.eventHandler.login(this.user, this.password));
            this.reply(230, "User " + this.user + " logged in.");
            while (this.keepRunning) {
                int n = this.readCommand(stringArray);
                try {
                    switch (n) {
                        case 4: {
                            stringArray[1] = "..";
                        }
                        case 3: {
                            this.eventHandler.changeDirectory(stringArray[1]);
                            this.reply(250, "CWD command successful.");
                            break;
                        }
                        case 6: {
                            this.eventHandler.quit();
                            this.reply(221, "Goodbye.");
                            this.keepRunning = false;
                            break;
                        }
                        case 8: {
                            this.dataPortAddr = this.dataPort(stringArray[1]);
                            this.reply(200, "PORT command successful.");
                            break;
                        }
                        case 9: {
                            String string = this.dataPassive();
                            this.reply(227, "Entering passive mode (" + string + ")");
                            break;
                        }
                        case 10: {
                            if ("A".equals(stringArray[1]) || "I".equals(stringArray[1])) {
                                this.type = stringArray[1];
                                this.reply(200, "Type set to " + stringArray[1] + ".");
                                break;
                            }
                            this.reply(504, "Type " + stringArray[1] + " not implemented.");
                            break;
                        }
                        case 13: {
                            this.checkArgAndPlainFile(stringArray);
                            OutputStream outputStream = this.getDataOutput();
                            this.dataStart(stringArray[1]);
                            this.eventHandler.retrieve(stringArray[1], outputStream, this.type.equals("I"));
                            this.dataComplete();
                            break;
                        }
                        case 14: {
                            InputStream inputStream = this.getDataInput();
                            this.dataStart(stringArray[1]);
                            this.eventHandler.store(stringArray[1], inputStream, this.type.equals("I"));
                            this.dataComplete();
                            break;
                        }
                        case 19: {
                            this.eventHandler.renameFrom(stringArray[1]);
                            this.reply(350, "File exists, ready for destination name.");
                            break;
                        }
                        case 20: {
                            this.eventHandler.renameTo(stringArray[1]);
                            this.reply(250, "RNTO command successful.");
                            break;
                        }
                        case 21: {
                            this.eventHandler.abort();
                            this.dataReset();
                            this.reply(225, "ABOR command successful.");
                            break;
                        }
                        case 22: {
                            this.eventHandler.delete(stringArray[1]);
                            this.reply(250, "DELE command successful.");
                            break;
                        }
                        case 23: {
                            this.eventHandler.rmdir(stringArray[1]);
                            this.reply(250, "RMD command successful.");
                            break;
                        }
                        case 24: {
                            this.eventHandler.mkdir(stringArray[1]);
                            this.reply(257, "\"" + stringArray[1] + "\" new directory created.");
                            break;
                        }
                        case 25: {
                            this.reply(257, "\"" + this.eventHandler.pwd() + "\" is current directory.");
                            break;
                        }
                        case 26: {
                            OutputStream outputStream = this.getDataOutput();
                            String[] stringArray2 = FTPServer.splitLsArgs(stringArray[1]);
                            this.dataStart("list" + (stringArray[1] != null ? " " + stringArray[1] : ""));
                            this.eventHandler.list(stringArray2[1], outputStream);
                            this.dataComplete();
                            break;
                        }
                        case 27: {
                            OutputStream outputStream = this.getDataOutput();
                            String[] stringArray2 = FTPServer.splitLsArgs(stringArray[1]);
                            this.dataStart("nlst" + (stringArray[1] != null ? " " + stringArray[1] : ""));
                            this.eventHandler.nameList(stringArray2[1], outputStream);
                            this.dataComplete();
                            break;
                        }
                        case 29: {
                            this.reply(215, this.eventHandler.system());
                            break;
                        }
                        case 32: {
                            this.reply(200, "NOOP command successful.");
                            break;
                        }
                        case 33: {
                            this.reply(211, "Extensions supported:\nSIZE\nMDTM\nSITE CHMOD\nEND");
                            break;
                        }
                        case 34: {
                            this.checkArgAndPlainFile(stringArray);
                            long l = this.eventHandler.modTime(stringArray[1]);
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
                            this.reply(213, simpleDateFormat.format(new Date(l)));
                            break;
                        }
                        case 35: {
                            this.checkArgAndPlainFile(stringArray);
                            long l = this.eventHandler.size(stringArray[1]);
                            this.reply(213, String.valueOf(l));
                            break;
                        }
                        case 1: {
                            this.reply(230, "User " + this.user + " logged in.");
                            break;
                        }
                        case 28: {
                            if (stringArray[1] != null) {
                                String[] stringArray3 = new String[2];
                                int n2 = stringArray[1].indexOf(32);
                                if (n2 > 0) {
                                    stringArray3[0] = stringArray[1].substring(0, n2);
                                    stringArray3[1] = stringArray[1].substring(n2).trim();
                                    if (stringArray3[0] != null && stringArray3[0].equals("CHMOD") && stringArray3[1] != null && (n2 = stringArray3[1].indexOf(32)) > 0) {
                                        stringArray3[0] = stringArray3[1].substring(0, n2);
                                        stringArray3[1] = stringArray3[1].substring(n2).trim();
                                        if (stringArray3[1].length() > 0) {
                                            try {
                                                int n3 = Integer.parseInt(stringArray3[0], 8);
                                                this.eventHandler.chmod(n3, stringArray3[1]);
                                                this.reply(200, "SITE CHMOD command successful.");
                                                break;
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        case 0: 
                        case 2: 
                        case 5: 
                        case 7: 
                        case 11: 
                        case 12: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 30: 
                        case 31: {
                            this.reply(502, "'" + stringArray[0] + "': command not implemented");
                            break;
                        }
                        case -1: {
                            this.reply(500, "'" + stringArray[0] + "': command not understood");
                        }
                    }
                }
                catch (FTPException fTPException) {
                    if (this.dataConnected) {
                        this.dataReset();
                    }
                    this.reply(fTPException.getCode(), fTPException.getMessage());
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                this.cmdOutput.close();
            }
            catch (IOException iOException) {}
            try {
                this.cmdInput.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void terminate() {
        try {
            this.cmdOutput.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.cmdInput.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkArgAndPlainFile(String[] stringArray) throws FTPException {
        if (stringArray.length < 2 || stringArray[1] == null) {
            throw new FTPException(500, "'" + stringArray[0] + "': command not understood");
        }
        if (!this.eventHandler.isPlainFile(stringArray[1])) {
            throw new FTPException(550, stringArray[1] + ": Not a plain file.");
        }
    }

    private int readCommand(String[] stringArray) throws IOException {
        String string = this.cmdInput.readLine();
        if (string == null) {
            throw new EOFException();
        }
        int n = string.indexOf(32);
        if (n != -1) {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n).trim();
        } else {
            stringArray[0] = string.trim();
            stringArray[1] = null;
        }
        stringArray[0] = stringArray[0].toUpperCase();
        Integer n2 = (Integer)commands.get(stringArray[0]);
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    public void reply(int n, String string) throws IOException {
        String string2;
        if (string.indexOf(10) != -1) {
            string2 = n + "-";
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = string2 + " " + string3 + "\r\n";
                    continue;
                }
                string2 = string2 + n + " " + string3 + "\r\n";
            }
        } else {
            string2 = n + " " + string + "\r\n";
        }
        this.cmdOutput.write(string2.getBytes());
    }

    public void readLogin() throws IOException {
        this.user = null;
        this.password = null;
        while (this.user == null || this.password == null) {
            String[] stringArray = new String[2];
            int n = this.readCommand(stringArray);
            if (n == 0) {
                this.user = stringArray[1];
                if (this.user != null) {
                    if (this.needPassword) {
                        this.reply(331, "Password required for " + this.user + ".");
                        continue;
                    }
                    return;
                }
            } else if (n == 1 && this.user != null) {
                this.password = stringArray[1];
            }
            if (this.password != null) continue;
            this.reply(530, "Please login with USER and PASS.");
        }
    }

    protected int[] dataPort(String string) throws FTPException {
        this.dataReset();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        int[] nArray = new int[6];
        while (n < 6 && stringTokenizer.hasMoreTokens()) {
            try {
                nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new FTPException(500, "'PORT " + string + "': command not understood");
            }
        }
        if (n < 6) {
            throw new FTPException(500, "'PORT " + string + "': command not understood");
        }
        return nArray;
    }

    protected String dataPassive() throws FTPException {
        this.dataReset();
        try {
            this.dataPasvAccept = new ServerSocket(0, 16, this.localHost);
            this.dataPasvAccept.setSoTimeout(30000);
        }
        catch (Exception exception) {
            this.dataReset();
            throw new FTPException(500, "Error, unable to proceede: " + exception.getMessage());
        }
        byte[] byArray = null;
        byArray = this.localHost.getAddress();
        if ((byArray[0] & 0xFF) == 0) {
            try {
                byArray = InetAddress.getLocalHost().getAddress();
            }
            catch (UnknownHostException unknownHostException) {
                throw new Error("Error in FTPServer: " + unknownHostException);
            }
        }
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = byArray[2] & 0xFF;
        int n4 = byArray[3] & 0xFF;
        int n5 = this.dataPasvAccept.getLocalPort();
        int n6 = n5 >>> 8 & 0xFF;
        int n7 = n5 & 0xFF;
        return n + "," + n2 + "," + n3 + "," + n4 + "," + n6 + "," + n7;
    }

    protected OutputStream getDataOutput() throws FTPException {
        this.dataConnect();
        if (this.dataSocket == null) {
            throw new FTPException(550, "Error when making data connection.");
        }
        try {
            this.dataOut = this.dataSocket.getOutputStream();
            return this.dataOut;
        }
        catch (IOException iOException) {
            throw new FTPException(425, "Can't build data connection: " + iOException.getMessage());
        }
    }

    protected InputStream getDataInput() throws FTPException {
        this.dataConnect();
        try {
            this.dataIn = this.dataSocket.getInputStream();
            return this.dataIn;
        }
        catch (IOException iOException) {
            throw new FTPException(425, "Can't build data connection: " + iOException.getMessage());
        }
    }

    protected void dataConnect() throws FTPException {
        try {
            if (this.dataPasvAccept != null) {
                this.dataSocket = this.dataPasvAccept.accept();
            } else if (this.dataPortAddr != null) {
                String string = this.dataPortAddr[0] + "." + this.dataPortAddr[1] + "." + this.dataPortAddr[2] + "." + this.dataPortAddr[3];
                int n = this.dataPortAddr[4] << 8 | this.dataPortAddr[5];
                this.dataSocket = new Socket(string, n);
            }
            this.dataConnected = true;
        }
        catch (IOException iOException) {
            this.dataReset();
            throw new FTPException(425, "Can't build data connection: " + iOException.getMessage());
        }
    }

    protected void dataStart(String string) throws IOException {
        this.reply(150, "Opening " + (this.type.equals("A") ? "ASCII" : "BINARY") + " mode data connection for " + string + ".");
    }

    protected void dataComplete() throws IOException {
        this.reply(226, "Transfer complete.");
        this.dataReset();
    }

    protected void dataReset() {
        if (this.dataPasvAccept != null) {
            try {
                this.dataPasvAccept.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dataPasvAccept = null;
        }
        this.dataPortAddr = null;
        if (this.dataSocket != null) {
            try {
                if (this.dataOut != null) {
                    this.dataOut.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.dataIn != null) {
                    this.dataIn.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.dataSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dataSocket = null;
        this.dataOut = null;
        this.dataIn = null;
        this.dataConnected = false;
    }

    static {
        commands.put("USER", new Integer(0));
        commands.put("PASS", new Integer(1));
        commands.put("ACCT", new Integer(2));
        commands.put("CWD", new Integer(3));
        commands.put("CDUP", new Integer(4));
        commands.put("SMNT", new Integer(5));
        commands.put("QUIT", new Integer(6));
        commands.put("REIN", new Integer(7));
        commands.put("PORT", new Integer(8));
        commands.put("PASV", new Integer(9));
        commands.put("TYPE", new Integer(10));
        commands.put("STRU", new Integer(11));
        commands.put("MODE", new Integer(12));
        commands.put("RETR", new Integer(13));
        commands.put("STOR", new Integer(14));
        commands.put("STOU", new Integer(15));
        commands.put("APPE", new Integer(16));
        commands.put("ALLO", new Integer(17));
        commands.put("REST", new Integer(18));
        commands.put("RNFR", new Integer(19));
        commands.put("RNTO", new Integer(20));
        commands.put("ABOR", new Integer(21));
        commands.put("DELE", new Integer(22));
        commands.put("RMD", new Integer(23));
        commands.put("MKD", new Integer(24));
        commands.put("XPWD", new Integer(25));
        commands.put("PWD", new Integer(25));
        commands.put("LIST", new Integer(26));
        commands.put("NLST", new Integer(27));
        commands.put("SITE", new Integer(28));
        commands.put("SYST", new Integer(29));
        commands.put("STAT", new Integer(30));
        commands.put("HELP", new Integer(31));
        commands.put("NOOP", new Integer(32));
        commands.put("FEAT", new Integer(33));
        commands.put("MDTM", new Integer(34));
        commands.put("SIZE", new Integer(35));
    }
}

