/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.net;

import com.mindbright.jca.security.MessageDigest;
import com.mindbright.jce.crypto.Cipher;
import com.mindbright.jce.crypto.spec.SecretKeySpec;
import com.mindbright.net.HttpHeader;
import com.mindbright.net.ProxyAuthenticator;
import com.mindbright.net.SocketFactory;
import com.mindbright.net.WebProxyException;
import com.mindbright.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Random;

public class WebProxyTunnelSocket {
    private String proxyHost;
    private int proxyPort;
    private String targetHost;
    private int targetPort;
    private Socket socket;
    HttpHeader responseHeader;
    String serverDesc;
    private static int NTLM_NEGOTIATE_UNICODE = 1;
    private static int NTLM_NEGOTIATE_OEM = 2;
    private static int NTLM_REQUEST_TARGET = 4;
    private static int NTLM_NEGOTIATE_NTLM = 512;
    private static int NTLM_NEGOTIATE_SIGN = 32768;
    private static int NTLM_NEGOTIATE_NTLM2_KEY = 524288;
    private static int NTLM_CHALLENGE_SIZE = 8;
    private static int NTLM_PADDED_HASH_SIZE = 21;
    private static int NTLM_RESPONSE_SIZE = 24;
    private static String NTLMSSP_SIGNATURE = "NTLMSSP\u0000";
    private static byte[] NTLMType1Msg = new byte[]{78, 84, 76, 77, 83, 83, 80, 0, 1, 0, 0, 0, 7, -126, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public HttpHeader getResponseHeader() {
        return this.responseHeader;
    }

    public String getServerDesc() {
        return this.serverDesc;
    }

    private WebProxyTunnelSocket(String string, int n, String string2, int n2, long l) throws IOException, UnknownHostException {
        this.socket = SocketFactory.newSocket(string2, n2, l);
        this.proxyHost = string2;
        this.proxyPort = n2;
        this.targetHost = this.targetHost;
        this.targetPort = this.targetPort;
    }

    public static Socket getProxy(String string, int n, String string2, int n2, ProxyAuthenticator proxyAuthenticator, String string3) throws IOException, UnknownHostException {
        return WebProxyTunnelSocket.getProxy(string, n, string2, n2, 0L, null, proxyAuthenticator, string3);
    }

    public static Socket getProxy(String string, int n, String string2, int n2, long l, ProxyAuthenticator proxyAuthenticator, String string3) throws IOException, UnknownHostException {
        return WebProxyTunnelSocket.getProxy(string, n, string2, n2, l, null, proxyAuthenticator, string3);
    }

    public static Socket getProxy(String string, int n, String string2, int n2, String string3, ProxyAuthenticator proxyAuthenticator, String string4) throws IOException, UnknownHostException {
        return WebProxyTunnelSocket.getProxy(string, n, string2, n2, 0L, string3, proxyAuthenticator, string4);
    }

    private static void clearbytes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
    }

    private static byte[] getBytes(String string, String string2) {
        try {
            return string.getBytes(string2);
        }
        catch (Throwable throwable) {
            return string.getBytes();
        }
    }

    private static void oddParity(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            boolean bl;
            byte by = byArray[i];
            boolean bl2 = bl = ((by >>> 7 ^ by >>> 6 ^ by >>> 5 ^ by >>> 4 ^ by >>> 3 ^ by >>> 2 ^ by >>> 1) & 1) == 0;
            if (bl) {
                int n = i;
                byArray[n] = (byte)(byArray[n] | 1);
                continue;
            }
            int n = i;
            byArray[n] = (byte)(byArray[n] & 0xFFFFFFFE);
        }
    }

    private static void des_encrypt(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2) {
        try {
            Cipher cipher = Cipher.getInstance("DES/ECB");
            byte[] byArray4 = new byte[]{byArray[n], (byte)(byArray[n + 0] << 7 | (byArray[n + 1] & 0xFF) >>> 1), (byte)(byArray[n + 1] << 6 | (byArray[n + 2] & 0xFF) >>> 2), (byte)(byArray[n + 2] << 5 | (byArray[n + 3] & 0xFF) >>> 3), (byte)(byArray[n + 3] << 4 | (byArray[n + 4] & 0xFF) >>> 4), (byte)(byArray[n + 4] << 3 | (byArray[n + 5] & 0xFF) >>> 5), (byte)(byArray[n + 5] << 2 | (byArray[n + 6] & 0xFF) >>> 6), (byte)(byArray[n + 6] << 1)};
            WebProxyTunnelSocket.oddParity(byArray4);
            cipher.init(2, new SecretKeySpec(byArray4, cipher.getAlgorithm()));
            cipher.doFinal(byArray2, 0, NTLM_CHALLENGE_SIZE, byArray3, n2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static boolean do_ntlm_hash(String string, byte[] byArray) {
        try {
            WebProxyTunnelSocket.clearbytes(byArray);
            byte[] byArray2 = string.getBytes("UnicodeLittleUnmarked");
            byte[] byArray3 = MessageDigest.getInstance("MD4").digest(byArray2);
            System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
        return true;
    }

    private static LMAndNTLMResponse do_ntlm2(String string, byte[] byArray) {
        byte[] byArray2 = new byte[NTLM_PADDED_HASH_SIZE];
        LMAndNTLMResponse lMAndNTLMResponse = new LMAndNTLMResponse();
        if (string == null || !WebProxyTunnelSocket.do_ntlm_hash(string, byArray2)) {
            return null;
        }
        WebProxyTunnelSocket.clearbytes(lMAndNTLMResponse.lm);
        try {
            byte[] byArray3 = new byte[NTLM_CHALLENGE_SIZE];
            Random random = new Random();
            random.nextBytes(byArray3);
            System.arraycopy(byArray3, 0, lMAndNTLMResponse.lm, 0, byArray3.length);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray);
            messageDigest.update(lMAndNTLMResponse.lm, 0, NTLM_CHALLENGE_SIZE);
            byte[] byArray4 = messageDigest.digest();
            for (int i = 0; i < 3; ++i) {
                WebProxyTunnelSocket.des_encrypt(byArray2, i * 7, byArray4, lMAndNTLMResponse.ntlm, i * 8);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
        return lMAndNTLMResponse;
    }

    private static LMAndNTLMResponse do_lm_and_ntlm(String string, byte[] byArray) {
        int n;
        byte[] byArray2 = new byte[NTLM_PADDED_HASH_SIZE];
        LMAndNTLMResponse lMAndNTLMResponse = new LMAndNTLMResponse();
        if (string == null) {
            return null;
        }
        WebProxyTunnelSocket.clearbytes(byArray2);
        int n2 = string.length();
        if (n2 <= 14) {
            byte[] byArray3 = new byte[14];
            String string2 = "KGS!@#$%";
            WebProxyTunnelSocket.clearbytes(byArray3);
            String string3 = string.toUpperCase();
            for (n = 0; n < n2; ++n) {
                byArray3[n] = (byte)string3.charAt(n);
            }
            for (n = 0; n < 2; ++n) {
                WebProxyTunnelSocket.des_encrypt(byArray3, n * 7, WebProxyTunnelSocket.getBytes(string2, "US-ASCII"), byArray2, n * 8);
            }
            WebProxyTunnelSocket.clearbytes(byArray3);
        }
        for (n = 0; n < 3; ++n) {
            WebProxyTunnelSocket.des_encrypt(byArray2, n * 7, byArray, lMAndNTLMResponse.lm, n * 8);
        }
        if (!WebProxyTunnelSocket.do_ntlm_hash(string, byArray2)) {
            return null;
        }
        for (n = 0; n < 3; ++n) {
            WebProxyTunnelSocket.des_encrypt(byArray2, n * 7, byArray, lMAndNTLMResponse.ntlm, n * 8);
        }
        WebProxyTunnelSocket.clearbytes(byArray2);
        return lMAndNTLMResponse;
    }

    private static void writeShort(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
    }

    private static void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n >> 16 & 0xFF);
        outputStream.write(n >> 24 & 0xFF);
    }

    private static void writeBytes(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            outputStream.write(byArray[n + i]);
        }
    }

    public static Socket getProxy(String string, int n, String string2, int n2, long l, String string3, ProxyAuthenticator proxyAuthenticator, String string4) throws IOException, UnknownHostException {
        String string5;
        WebProxyTunnelSocket webProxyTunnelSocket = new WebProxyTunnelSocket(string, n, string2, n2, l);
        int n3 = -1;
        try {
            InputStream inputStream = webProxyTunnelSocket.socket.getInputStream();
            OutputStream outputStream = webProxyTunnelSocket.socket.getOutputStream();
            HttpHeader httpHeader = new HttpHeader();
            if (string3 == null) {
                string3 = "";
            }
            httpHeader.setStartLine("CONNECT " + string3 + string + ":" + n + " HTTP/1.0");
            httpHeader.setHeaderField("User-Agent", string4);
            httpHeader.setHeaderField("Pragma", "No-Cache");
            httpHeader.setHeaderField("Proxy-Connection", "Keep-Alive");
            httpHeader.writeTo(outputStream);
            webProxyTunnelSocket.responseHeader = new HttpHeader(inputStream);
            string5 = webProxyTunnelSocket.responseHeader.getHeaderField("server");
            if (webProxyTunnelSocket.responseHeader.getStatus() == 407 && proxyAuthenticator != null) {
                String string6 = webProxyTunnelSocket.responseHeader.getProxyAuthMethod();
                if ("basic".equalsIgnoreCase(string6)) {
                    String string7 = webProxyTunnelSocket.responseHeader.getProxyAuthRealm();
                    if (string7 == null) {
                        string7 = "";
                    }
                    webProxyTunnelSocket.socket.close();
                    webProxyTunnelSocket = new WebProxyTunnelSocket(string, n, string2, n2, l);
                    inputStream = webProxyTunnelSocket.socket.getInputStream();
                    outputStream = webProxyTunnelSocket.socket.getOutputStream();
                    String string8 = proxyAuthenticator.getProxyUsername("HTTP Proxy", string7);
                    String string9 = proxyAuthenticator.getProxyPassword("HTTP Proxy", string7);
                    httpHeader.setBasicProxyAuth(string8, string9);
                    httpHeader.writeTo(outputStream);
                    webProxyTunnelSocket.responseHeader = new HttpHeader(inputStream);
                } else {
                    if ("digest".equalsIgnoreCase(string6)) {
                        throw new IOException("We don't support 'Digest' HTTP Authentication");
                    }
                    if ("ntlm".equalsIgnoreCase(string6) || "negotiate".equalsIgnoreCase(string6)) {
                        String string10;
                        byte[] byArray;
                        int n4;
                        String string11;
                        String string12 = webProxyTunnelSocket.responseHeader.getHeaderField("proxy-connection");
                        if (string12 == null || !string12.equalsIgnoreCase("keep-alive")) {
                            webProxyTunnelSocket.socket.close();
                            webProxyTunnelSocket = new WebProxyTunnelSocket(string, n, string2, n2, l);
                            inputStream = webProxyTunnelSocket.socket.getInputStream();
                            outputStream = webProxyTunnelSocket.socket.getOutputStream();
                        } else {
                            string11 = webProxyTunnelSocket.responseHeader.getHeaderField("content-length");
                            int n5 = 0;
                            if (string11 != null) {
                                n5 = Integer.parseInt(string11);
                            }
                            while (n5 > 0) {
                                n4 = (int)inputStream.skip(n5);
                                n5 -= n4;
                            }
                        }
                        string11 = "NTLM " + new String(Base64.encode(NTLMType1Msg));
                        httpHeader.setHeaderField("Proxy-Authorization", string11);
                        httpHeader.writeTo(outputStream);
                        webProxyTunnelSocket.responseHeader = new HttpHeader(inputStream);
                        if (webProxyTunnelSocket.responseHeader.getStatus() != 407) {
                            throw new WebProxyException("Proxy authentication with NTLM failed");
                        }
                        String string13 = webProxyTunnelSocket.responseHeader.getHeaderField("content-length");
                        n4 = 0;
                        if (string13 != null) {
                            n4 = Integer.parseInt(string13);
                        }
                        while (n4 > 0) {
                            int n6 = (int)inputStream.skip(n4);
                            n4 -= n6;
                        }
                        string13 = webProxyTunnelSocket.responseHeader.getHeaderField("Proxy-Authenticate");
                        if (string13 == null) {
                            throw new WebProxyException("Proxy authentication with NTLM failed");
                        }
                        n4 = (string13 = string13.trim()).indexOf(32);
                        if (n4 == -1) {
                            throw new WebProxyException("Proxy authentication with NTLM failed");
                        }
                        String string14 = string13.substring(0, n4);
                        if (!string14.equalsIgnoreCase("NTLM")) {
                            throw new WebProxyException("Proxy authentication with NTLM failed");
                        }
                        if ((n4 = (string13 = string13.substring(n4).trim()).indexOf(32)) > 0) {
                            string13 = string13.substring(0, n4);
                        }
                        if ((byArray = Base64.decode(WebProxyTunnelSocket.getBytes(string13, "US-ASCII"))).length < 32 || byArray[8] != 2) {
                            throw new WebProxyException("Proxy authentication with NTLM failed");
                        }
                        int n7 = (byArray[12] & 0xFF) + ((byArray[13] & 0xFF) << 8);
                        int n8 = (byArray[16] & 0xFF) + ((byArray[17] & 0xFF) << 8) + ((byArray[18] & 0xFF) << 16) + ((byArray[19] & 0xFF) << 24);
                        int n9 = (byArray[20] & 0xFF) + ((byArray[21] & 0xFF) << 8) + ((byArray[22] & 0xFF) << 16) + ((byArray[23] & 0xFF) << 24);
                        byte[] byArray2 = new byte[NTLM_CHALLENGE_SIZE];
                        System.arraycopy(byArray, 24, byArray2, 0, NTLM_CHALLENGE_SIZE);
                        String string15 = proxyAuthenticator.getProxyUsername("HTTP Proxy", null);
                        String string16 = proxyAuthenticator.getProxyPassword("HTTP Proxy", null);
                        LMAndNTLMResponse lMAndNTLMResponse = (n9 & NTLM_NEGOTIATE_NTLM2_KEY) != 0 ? WebProxyTunnelSocket.do_ntlm2(string16, byArray2) : WebProxyTunnelSocket.do_lm_and_ntlm(string16, byArray2);
                        if (lMAndNTLMResponse == null) {
                            throw new WebProxyException("Proxy authentication with NTLM failed");
                        }
                        n4 = 64;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        byteArrayOutputStream.write(WebProxyTunnelSocket.getBytes(NTLMSSP_SIGNATURE, "US-ASCII"));
                        WebProxyTunnelSocket.writeInt(byteArrayOutputStream, 3);
                        WebProxyTunnelSocket.writeShort(byteArrayOutputStream, lMAndNTLMResponse.lmsz);
                        WebProxyTunnelSocket.writeShort(byteArrayOutputStream, lMAndNTLMResponse.lmsz);
                        WebProxyTunnelSocket.writeInt(byteArrayOutputStream, n4);
                        WebProxyTunnelSocket.writeShort(byteArrayOutputStream, lMAndNTLMResponse.ntlmsz);
                        WebProxyTunnelSocket.writeShort(byteArrayOutputStream, lMAndNTLMResponse.ntlmsz);
                        WebProxyTunnelSocket.writeInt(byteArrayOutputStream, n4 += lMAndNTLMResponse.lmsz);
                        n4 += lMAndNTLMResponse.ntlmsz;
                        byte[] byArray3 = byArray;
                        int n10 = string15.indexOf(92);
                        if (n10 != -1) {
                            string10 = string15.substring(0, n10);
                            string15 = string15.substring(n10 + 1);
                            byArray3 = (n9 & NTLM_NEGOTIATE_UNICODE) != 0 ? WebProxyTunnelSocket.getBytes(string10, "UnicodeLittleUnmarked") : WebProxyTunnelSocket.getBytes(string10, "US-ASCII");
                            n7 = byArray3.length;
                            WebProxyTunnelSocket.writeShort(byteArrayOutputStream, n7);
                            WebProxyTunnelSocket.writeShort(byteArrayOutputStream, n7);
                            WebProxyTunnelSocket.writeInt(byteArrayOutputStream, n4);
                            n4 += n7;
                            n8 = 0;
                        } else if (n7 > 0) {
                            WebProxyTunnelSocket.writeShort(byteArrayOutputStream, n7);
                            WebProxyTunnelSocket.writeShort(byteArrayOutputStream, n7);
                            WebProxyTunnelSocket.writeInt(byteArrayOutputStream, n4);
                            n4 += n7;
                        } else {
                            WebProxyTunnelSocket.writeShort(byteArrayOutputStream, 0);
                            WebProxyTunnelSocket.writeShort(byteArrayOutputStream, 0);
                            WebProxyTunnelSocket.writeInt(byteArrayOutputStream, 0);
                        }
                        byte[] byArray4 = (n9 & NTLM_NEGOTIATE_UNICODE) != 0 ? WebProxyTunnelSocket.getBytes(string15, "UnicodeLittleUnmarked") : WebProxyTunnelSocket.getBytes(string15, "US-ASCII");
                        WebProxyTunnelSocket.writeShort(byteArrayOutputStream, byArray4.length);
                        WebProxyTunnelSocket.writeShort(byteArrayOutputStream, byArray4.length);
                        WebProxyTunnelSocket.writeInt(byteArrayOutputStream, n4);
                        string10 = "ag_server";
                        byte[] byArray5 = (n9 & NTLM_NEGOTIATE_UNICODE) != 0 ? WebProxyTunnelSocket.getBytes(string10, "UnicodeLittleUnmarked") : WebProxyTunnelSocket.getBytes(string10, "US-ASCII");
                        WebProxyTunnelSocket.writeShort(byteArrayOutputStream, byArray5.length);
                        WebProxyTunnelSocket.writeShort(byteArrayOutputStream, byArray5.length);
                        WebProxyTunnelSocket.writeInt(byteArrayOutputStream, n4 += byArray4.length);
                        n4 += byArray5.length;
                        WebProxyTunnelSocket.writeInt(byteArrayOutputStream, 0);
                        WebProxyTunnelSocket.writeInt(byteArrayOutputStream, 0);
                        WebProxyTunnelSocket.writeInt(byteArrayOutputStream, n9 & (NTLM_NEGOTIATE_UNICODE | NTLM_NEGOTIATE_OEM | NTLM_NEGOTIATE_NTLM | NTLM_NEGOTIATE_SIGN | NTLM_NEGOTIATE_NTLM2_KEY));
                        WebProxyTunnelSocket.writeBytes(byteArrayOutputStream, lMAndNTLMResponse.lm, 0, lMAndNTLMResponse.lmsz);
                        WebProxyTunnelSocket.writeBytes(byteArrayOutputStream, lMAndNTLMResponse.ntlm, 0, lMAndNTLMResponse.ntlmsz);
                        if (n7 > 0) {
                            WebProxyTunnelSocket.writeBytes(byteArrayOutputStream, byArray3, n8, n7);
                        }
                        WebProxyTunnelSocket.writeBytes(byteArrayOutputStream, byArray4, 0, byArray4.length);
                        WebProxyTunnelSocket.writeBytes(byteArrayOutputStream, byArray5, 0, byArray5.length);
                        String string17 = "NTLM " + new String(Base64.encode(byteArrayOutputStream.toByteArray()));
                        httpHeader.setHeaderField("Proxy-Authorization", string17);
                        httpHeader.writeTo(outputStream);
                        webProxyTunnelSocket.responseHeader = new HttpHeader(inputStream);
                    } else {
                        throw new IOException("Unknown HTTP Authentication method '" + string6 + "'");
                    }
                }
            }
            n3 = webProxyTunnelSocket.responseHeader.getStatus();
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
            throw new SocketException("Error communicating with proxy server " + string2 + ":" + n2 + " (" + socketException.getMessage() + ")");
        }
        if (n3 < 200 || n3 > 299) {
            throw new WebProxyException("Proxy tunnel setup failed: " + webProxyTunnelSocket.responseHeader.getStartLine());
        }
        webProxyTunnelSocket.serverDesc = string5;
        return webProxyTunnelSocket.socket;
    }

    public String toString() {
        return "WebProxyTunnelSocket[addr=" + this.socket.getInetAddress() + ",port=" + this.socket.getPort() + ",localport=" + this.socket.getLocalPort() + "]";
    }

    private static class LMAndNTLMResponse {
        byte[] lm;
        byte[] ntlm;
        int lmsz;
        int ntlmsz;

        LMAndNTLMResponse() {
            this.lmsz = this.ntlmsz = NTLM_RESPONSE_SIZE;
            this.lm = new byte[NTLM_RESPONSE_SIZE];
            this.ntlm = new byte[NTLM_RESPONSE_SIZE];
        }
    }
}

