/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.jce.crypto;

import com.mindbright.jca.security.InvalidAlgorithmParameterException;
import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.Key;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.NoSuchProviderException;
import com.mindbright.jca.security.Provider;
import com.mindbright.jca.security.ProviderLookup;
import com.mindbright.jca.security.spec.AlgorithmParameterSpec;
import com.mindbright.jce.crypto.MacSpi;
import com.mindbright.jce.crypto.ShortBufferException;

public class Mac
implements Cloneable {
    private Provider provider;
    private MacSpi engine;
    private String algorithm;
    private boolean initialized;
    private int macLength;

    protected Mac(MacSpi macSpi, Provider provider, String string) {
        this.provider = provider;
        this.engine = macSpi;
        this.algorithm = string;
        this.initialized = false;
    }

    public Object clone() throws CloneNotSupportedException {
        Mac mac = new Mac((MacSpi)this.engine.clone(), this.provider, this.algorithm);
        mac.initialized = this.initialized;
        return mac;
    }

    public final byte[] doFinal() throws IllegalStateException {
        if (this.initialized) {
            byte[] byArray = this.engine.engineDoFinal();
            this.engine.engineReset();
            return byArray;
        }
        throw new IllegalStateException(this.algorithm + " not initialized");
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException {
        if (this.initialized) {
            this.engine.engineUpdate(byArray, 0, byArray.length);
            return this.doFinal();
        }
        throw new IllegalStateException(this.algorithm + " not initialized");
    }

    public final void doFinal(byte[] byArray, int n) throws ShortBufferException, IllegalStateException {
        if (this.initialized) {
            if (byArray.length - n < this.macLength) {
                throw new ShortBufferException("Output buffer is too small for " + this.algorithm);
            }
        } else {
            throw new IllegalStateException(this.algorithm + " not initialized");
        }
        System.arraycopy(this.engine.engineDoFinal(), 0, byArray, n, this.macLength);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final Mac getInstance(String string) throws NoSuchAlgorithmException {
        try {
            String string2 = ProviderLookup.findImplementingProvider("Mac", string);
            return Mac.getInstance(string, string2);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new Error("Error in Mac: " + noSuchProviderException);
        }
    }

    public static final Mac getInstance(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        ProviderLookup providerLookup = ProviderLookup.getImplementation("Mac", string, string2);
        return new Mac((MacSpi)providerLookup.getImpl(), providerLookup.getProvider(), string);
    }

    public final int getMacLength() {
        int n = this.macLength;
        if (!this.initialized) {
            n = this.engine.engineGetMacLength();
        }
        return n;
    }

    Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException {
        try {
            this.init(key, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new Error("Error in Mac: " + invalidAlgorithmParameterException);
        }
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engine.engineInit(key, algorithmParameterSpec);
        this.macLength = this.engine.engineGetMacLength();
        this.initialized = true;
    }

    public final void reset() {
        this.engine.engineReset();
    }

    public final void update(byte by) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException(this.algorithm + " not initialized");
        }
        this.engine.engineUpdate(by);
    }

    public final void update(byte[] byArray) throws IllegalStateException {
        this.update(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n, int n2) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException(this.algorithm + " not initialized");
        }
        this.engine.engineUpdate(byArray, n, n2);
    }
}

