/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.util;

import com.mindbright.jca.security.MessageDigest;
import com.mindbright.util.Progress;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Properties;

public final class RandomSeed
implements MouseMotionListener,
MouseListener,
KeyListener,
FocusListener,
ComponentListener {
    private static final boolean DEBUG = false;
    private InputStream devRand;
    private InputStream devURand;
    private String devRandName;
    private String devURandName;
    private byte[] entropyPool;
    private int entropyRIdx;
    private int entropyWIdx;
    private volatile int entropyCount;
    private boolean haveEntropyGenerator;
    private int entropyGeneratorCount = 0;
    private long tickT;
    private int evtCnt;
    private int mouseCnt;
    private int evtHash;
    private int keyHash;
    private int mouseHash;
    private int lastX;
    private int lastY;
    private Progress progress;

    public RandomSeed() {
        this.init();
        for (int i = 0; i < 16; ++i) {
            this.addEntropyBits((byte)RandomSeed.spin(8L), 4);
        }
    }

    public RandomSeed(String string, String string2) {
        this.init();
        this.devRandName = string;
        this.devURandName = string2;
        this.devRand = this.openRandFile(string);
        this.devURand = this.openRandFile(string2);
    }

    private void init() {
        this.entropyPool = new byte[1200];
        this.entropyCount = 16;
        this.entropyRIdx = 0;
        this.entropyWIdx = 0;
        this.tickT = 0L;
        this.evtCnt = 0;
        this.mouseCnt = 0;
        this.devRand = null;
        this.devURand = null;
        this.progress = null;
        byte[] byArray = RandomSeed.getSystemStateHash();
        System.arraycopy(byArray, 0, this.entropyPool, 0, byArray.length);
    }

    private InputStream openRandFile(String string) {
        FileInputStream fileInputStream = null;
        try {
            File file = new File(string);
            if (file.exists() && file.canRead()) {
                fileInputStream = new FileInputStream(file);
            }
        }
        catch (Throwable throwable) {
            fileInputStream = null;
        }
        return fileInputStream;
    }

    public void addProgress(Progress progress) {
        this.progress = progress;
    }

    public void removeProgress() {
        this.progress = null;
    }

    public void addEntropyGenerator(Component component) {
        if (component != null) {
            component.addComponentListener(this);
            component.addKeyListener(this);
            component.addFocusListener(this);
            component.addMouseMotionListener(this);
            component.addMouseListener(this);
            this.haveEntropyGenerator = true;
            ++this.entropyGeneratorCount;
        }
    }

    public void removeEntropyGenerator(Component component) {
        if (component != null) {
            component.removeComponentListener(this);
            component.removeKeyListener(this);
            component.removeFocusListener(this);
            component.removeMouseMotionListener(this);
            component.removeMouseListener(this);
            if (0 == --this.entropyGeneratorCount) {
                this.haveEntropyGenerator = false;
            }
        }
    }

    public synchronized void addEntropyBits(byte by, int n) {
        int n2 = this.entropyWIdx++;
        this.entropyPool[n2] = (byte)(this.entropyPool[n2] ^ by);
        if (this.entropyWIdx == this.entropyPool.length) {
            this.entropyWIdx = 0;
        }
        this.entropyCount += n;
        if (this.progress != null) {
            this.progress.progress(this.entropyCount);
        }
    }

    public boolean haveDevRandom() {
        return this.devRand != null;
    }

    public boolean haveDevURandom() {
        return this.devURand != null;
    }

    public boolean haveEntropyGenerator() {
        return this.haveEntropyGenerator;
    }

    public int getAvailableBits() {
        return this.entropyCount;
    }

    public void resetEntropyCount() {
        this.entropyCount = 0;
    }

    public byte[] getBytes(int n) {
        if (this.haveDevURandom()) {
            try {
                for (int i = 0; i < n; ++i) {
                    int n2 = this.devURand.read();
                    this.addEntropyBits((byte)n2, 8);
                }
            }
            catch (IOException iOException) {
                throw new Error("Error reading '" + this.devURandName + "'");
            }
        }
        return this.getBytesInternal(n);
    }

    public byte[] getBytesBlocking(int n) {
        return this.getBytesBlocking(n, true);
    }

    public byte[] getBytesBlocking(int n, boolean bl) {
        int n2 = n * 8;
        while (this.entropyCount < n2) {
            if (this.haveDevRandom()) {
                try {
                    int n3 = this.devRand.read();
                    this.addEntropyBits((byte)n3, 8);
                    continue;
                }
                catch (IOException iOException) {
                    throw new Error("Error reading '" + this.devRandName + "'");
                }
            }
            if (bl && this.haveEntropyGenerator) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.addEntropyBits((byte)RandomSeed.spin(8L), 4);
        }
        return this.getBytesInternal(n);
    }

    private synchronized byte[] getBytesInternal(int n) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (Exception exception) {
            throw new Error("Error in RandomSeed, no sha1 hash");
        }
        int n2 = 0;
        byte[] byArray = new byte[n];
        int n3 = this.entropyRIdx;
        while (n2 < n) {
            messageDigest.update((byte)System.currentTimeMillis());
            messageDigest.update(this.entropyPool, n3, 40);
            messageDigest.update((byte)this.evtCnt);
            byte[] byArray2 = messageDigest.digest();
            System.arraycopy(byArray2, 0, byArray, n2, n - n2 > byArray2.length ? byArray2.length : n - n2);
            n2 += byArray2.length;
            n3 += 40;
            n3 %= this.entropyPool.length;
        }
        this.entropyRIdx = n3;
        this.entropyCount -= n * 8;
        if (this.entropyCount < 0) {
            this.entropyCount = 0;
        }
        return byArray;
    }

    public static synchronized byte[] getSystemStateHash() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (Exception exception) {
            throw new Error("Error in RandomSeed, no sha1 hash");
        }
        messageDigest.update((byte)System.currentTimeMillis());
        messageDigest.update((byte)Runtime.getRuntime().totalMemory());
        messageDigest.update((byte)Runtime.getRuntime().freeMemory());
        messageDigest.update(RandomSeed.stackDump(new Throwable()));
        try {
            Properties properties = System.getProperties();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                messageDigest.update(string.getBytes("US-ASCII"));
                messageDigest.update(properties.getProperty(string).getBytes("US-ASCII"));
            }
        }
        catch (Throwable throwable) {
            messageDigest.update(RandomSeed.stackDump(throwable));
        }
        messageDigest.update((byte)System.currentTimeMillis());
        try {
            messageDigest.update(InetAddress.getLocalHost().toString().getBytes("US-ASCII"));
        }
        catch (Throwable throwable) {
            messageDigest.update(RandomSeed.stackDump(throwable));
        }
        messageDigest.update((byte)System.currentTimeMillis());
        Runtime.getRuntime().gc();
        messageDigest.update((byte)Runtime.getRuntime().freeMemory());
        messageDigest.update((byte)System.currentTimeMillis());
        return messageDigest.digest();
    }

    public static int spin(long l) {
        int n = 0;
        Sleeper sleeper = new Sleeper(l);
        do {
            ++n;
            Thread.yield();
        } while (sleeper.isAlive());
        return n;
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.keyHash ^= keyEvent.getModifiers();
        this.keyHash += keyEvent.getKeyCode() ^ this.evtHash;
        this.eventTick(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.eventTick(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.keyHash ^= keyEvent.getKeyChar();
        this.keyHash ^= keyEvent.hashCode();
        if (this.evtCnt % 7 == 0) {
            this.addEntropyBits((byte)this.keyHash, 4);
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.eventTick(componentEvent);
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.eventTick(componentEvent);
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.eventTick(componentEvent);
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.eventTick(componentEvent);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.eventTick(focusEvent);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.eventTick(focusEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.eventTick(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.eventTick(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.eventTick(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.eventTick(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.eventTick(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        ++this.mouseCnt;
        int n = this.lastX - mouseEvent.getX();
        int n2 = this.lastY - mouseEvent.getY();
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
        this.mouseHash ^= mouseEvent.hashCode();
        this.mouseHash ^= mouseEvent.getX();
        this.mouseHash ^= n2;
        this.mouseHash ^= mouseEvent.getY();
        this.mouseHash ^= n;
        if (this.mouseCnt % 3 == 0) {
            this.addEntropyBits((byte)this.mouseHash, 4);
        }
    }

    public static byte[] stackDump(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        throwable.printStackTrace(printWriter);
        return byteArrayOutputStream.toByteArray();
    }

    private void eventTick(Object object) {
        ++this.evtCnt;
        this.evtHash ^= object.hashCode();
        if (this.evtCnt % 5 == 0) {
            long l = System.currentTimeMillis();
            this.addEntropyBits((byte)(l - this.tickT), 4);
            this.tickT = l;
            this.evtHash = (int)((long)this.evtHash ^ l);
        }
        if (this.evtCnt % 17 == 0) {
            this.addEntropyBits((byte)this.evtHash, 4);
        }
    }

    private static class Sleeper
    extends Thread {
        long sleepTime;

        public Sleeper(long l) {
            super("RandomSeed.Sleeper");
            this.sleepTime = l;
            this.start();
        }

        public void run() {
            Thread.yield();
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

