/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.tandem6530;

import com.mindbright.terminal.DisplayView;
import com.mindbright.terminal.SearchContext;
import com.mindbright.terminal.tandem6530.AsciiCodes;
import com.mindbright.terminal.tandem6530.Screen6530Buffer;
import com.mindbright.terminal.tandem6530.VideoAttributeMap;

public class Screen6530
implements AsciiCodes {
    protected static final boolean DEBUG = false;
    public static final int MIN_ROWS = 2;
    public static final int MIN_COLS = 8;
    public static final int MAX_COLS = 512;
    public static final int MAX_ROWS = 512;
    public static final int MAX_SAVED_LINES = 8192;
    protected int rows;
    protected int cols;
    protected int curRow;
    protected int curCol;
    protected int bufferRow;
    protected int bufferCol;
    protected int selectTopRow;
    protected int selectTopCol;
    protected int selectBottomRow;
    protected int selectBottomCol;
    protected boolean hasSelection;
    protected int selectClickRow = -1;
    protected boolean selectClickState;
    protected boolean insertMode;
    protected boolean wrapAroundLastLine;
    protected char[][] screen;
    protected boolean[] autowraps;
    protected VideoAttributeMap attribMap;
    protected char defaultChar;
    protected char[] defaultChars;
    protected int saveLines;
    protected int visTop;
    protected static final char[] spacerow = new char[512];
    protected static final int[] zerorow = new int[512];
    protected boolean[] tabStops = new boolean[512];
    protected boolean[] termOptions;
    protected DisplayView display = null;

    public Screen6530(int n, int n2, char c, boolean bl) {
        this.reset();
        this.defaultChar = c;
        this.wrapAroundLastLine = bl;
        this.attribMap = new VideoAttributeMap(n, n2, 0);
        this.defaultChars = new char[512];
        for (int i = 0; i < 512; ++i) {
            this.defaultChars[i] = c;
        }
        this.resizeBuffers(n, n2);
        this.resetTabs();
    }

    public void setDisplay(DisplayView displayView) {
        this.display = displayView;
        this.attribMap.setDisplay(displayView);
        this.updateCursorPosition();
    }

    protected void updateDirtyArea(int n, int n2, int n3, int n4) {
        if (this.display != null) {
            if (n3 < n) {
                n = 0;
                n3 = this.rows;
            }
            this.display.updateDirtyArea(this.visTop + n, n2, this.visTop + n3, n4);
        }
    }

    protected void updateCursorPosition() {
        if (this.display != null) {
            this.display.setCursorPosition(this.visTop + this.curRow, this.curCol);
        }
    }

    public int getSaveLines() {
        return this.saveLines;
    }

    public boolean setSaveLines(int n) {
        boolean bl = false;
        int n2 = this.saveLines;
        boolean bl2 = false;
        n = n < 0 ? 0 : n;
        int n3 = n = n > 8192 ? 8192 : n;
        if (this.saveLines != n) {
            int n4;
            int n5;
            char[][] cArray = this.screen;
            boolean[] blArray = this.autowraps;
            this.saveLines = n;
            try {
                this.resizeBuffers(this.rows, this.cols);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.saveLines = n2;
                this.resizeBuffers(this.rows, this.cols);
                bl2 = true;
            }
            int n6 = 0;
            if (n2 < this.saveLines) {
                n5 = 0;
                n4 = n2 + this.rows;
            } else if (this.visTop <= this.saveLines) {
                n5 = 0;
                n4 = this.visTop + this.rows;
            } else {
                n5 = this.visTop - this.saveLines;
                n4 = this.saveLines + this.rows;
                this.visTop -= n5;
                bl = true;
            }
            System.arraycopy(cArray, n5, this.screen, n6, n4);
            System.arraycopy(blArray, n5, this.autowraps, n6, n4);
            this.attribMap.resize(this.rows + this.saveLines, this.cols);
        }
        if (bl && this.display != null) {
            this.display.setVisTop(this.visTop);
        }
        return !bl2;
    }

    public void clearSaveLines() {
        char[][] cArray = this.screen;
        boolean[] blArray = this.autowraps;
        this.resizeBuffers(this.rows, this.cols);
        System.arraycopy(cArray, this.visTop, this.screen, 0, this.rows);
        System.arraycopy(blArray, this.visTop, this.screen, 0, this.rows);
        this.visTop = 0;
        if (this.display != null) {
            this.display.setVisTop(this.visTop);
        }
    }

    protected char[] makeCharLine() {
        char[] cArray = new char[this.cols];
        System.arraycopy(this.defaultChars, 0, cArray, 0, this.cols);
        return cArray;
    }

    public void resizeBuffers(int n, int n2) {
        this.rows = n;
        this.cols = n2;
        int n3 = n + this.saveLines;
        this.screen = new char[n3][];
        this.autowraps = new boolean[n3];
        for (int i = 0; i < n3; ++i) {
            this.screen[i] = this.makeCharLine();
        }
        this.attribMap.resize(n + this.saveLines, n2);
    }

    public void cursorWrite(char c) {
        this.cursorWrite(c, this.insertMode, false);
    }

    public void cursorWrite(char c, boolean bl, boolean bl2) {
        int n;
        if (bl) {
            this.insertChars(1);
        }
        int n2 = n = this.visTop + this.curRow;
        int n3 = this.curCol;
        if (!bl2 && this.attribMap.isAttrib(n, this.curCol)) {
            this.attribMap.delete(n, this.curCol);
        }
        this.screen[n][this.curCol++] = c;
        if (this.curCol == this.cols) {
            this.autowraps[this.visTop + this.curRow] = true;
            this.doLF();
            this.doCR();
        }
        this.updateDirtyArea(n2, n3, this.curRow + 1, this.curCol + 1);
        this.updateCursorPosition();
    }

    public void bufferWrite(char c) {
        int n = this.visTop + this.bufferRow;
        int n2 = this.bufferCol;
        this.screen[n][this.bufferCol++] = c;
        if (this.bufferCol == this.cols) {
            this.autowraps[this.visTop + this.bufferRow] = true;
            this.bufferCol = 0;
            ++this.bufferRow;
            if (this.bufferRow == this.rows) {
                this.bufferRow = 0;
            }
        }
        this.updateDirtyArea(n, n2, n + 1, this.bufferCol + 1);
    }

    public int getCursorRow() {
        return this.curRow;
    }

    public int getCursorCol() {
        return this.curCol;
    }

    public int getScreenTop() {
        return this.visTop;
    }

    public int getTotalLines() {
        return this.saveLines + this.rows;
    }

    public char[] getCharsAt(int n, int n2) {
        if ((n2 += n) < 0 || n2 >= this.rows + this.saveLines) {
            return null;
        }
        return this.screen[n2];
    }

    public int[] getAttribsAt(int n, int n2) {
        return this.attribMap.getAttribsAt(n, n2);
    }

    public void setInsertMode(boolean bl) {
        this.insertMode = bl;
    }

    public int getVisTop() {
        return this.visTop;
    }

    public int getCurRow() {
        return this.curRow;
    }

    public int getCurCol() {
        return this.curCol;
    }

    public int getSelectTopRow() {
        return this.selectTopRow;
    }

    public int getSelectTopCol() {
        return this.selectTopCol;
    }

    public int getSelectBottomRow() {
        return this.selectBottomRow;
    }

    public int getSelectBottomCol() {
        return this.selectBottomCol;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public void doBS() {
        this.cursorBackward(1);
    }

    public void doBackTabs(int n) {
        if (this.curCol > 0 && n >= 0) {
            int n2;
            for (n2 = this.curCol - 1; !(n2 < 0 || this.tabStops[n2] && --n == 0); --n2) {
            }
            this.curCol = n2 < 0 ? 0 : n2;
            this.updateCursorPosition();
        }
    }

    public void doCR() {
        this.curCol = 0;
        this.updateCursorPosition();
    }

    public void doLF() {
        this.cursorDown(1);
    }

    public int getCursorV() {
        return this.curRow;
    }

    public int getCursorH() {
        return this.curCol;
    }

    public void cursorSetPos(int n, int n2, boolean bl) {
        this.cursorSetPos(n, n2);
    }

    public void cursorSetPos(int n, int n2) {
        int n3 = this.rows - 1;
        int n4 = this.cols - 1;
        int n5 = 0;
        int n6 = 0;
        if (n < n5) {
            n = n5;
        }
        if (n2 < n6) {
            n2 = n6;
        }
        if (n > n3) {
            n = n3;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        this.curRow = n;
        this.curCol = n2;
        this.updateCursorPosition();
    }

    public void bufferSetPos(int n, int n2) {
        int n3 = this.rows - 1;
        int n4 = this.cols - 1;
        int n5 = 0;
        int n6 = 0;
        if (n < n5) {
            n = n5;
        }
        if (n2 < n6) {
            n2 = n6;
        }
        if (n > n3) {
            n = n3;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        this.bufferRow = n;
        this.bufferCol = n2;
    }

    public void cursorHome() {
        this.cursorSetPos(0, 0);
    }

    public void cursorHomeDown() {
        this.cursorSetPos(this.rows - 1, 0);
    }

    public void cursorToLastCharOnScreen() {
        this.cursorToLastCharOnRow(this.visTop + this.rows - 1, 0, true);
        if (this.curCol == this.cols - 1) {
            this.cursorDown(1);
            this.doCR();
        }
    }

    public void cursorToLastCharOnRow() {
        this.cursorToLastCharOnRow(this.visTop + this.curRow, this.curCol, true);
    }

    protected void cursorToLastCharOnRow(int n, int n2, boolean bl) {
        int n3 = this.prevPrintedChar(n, this.cols - 1) + 1;
        if (n3 == this.cols) {
            if (n < this.getLastRow() - 1) {
                n3 = 0;
                ++n;
            } else {
                n3 = this.cols - 1;
            }
        }
        if (n == this.getLastRow() - 1) {
            this.cursorSetPos(n, n3);
            return;
        }
        if (n3 <= n2 && (n2 > 0 || bl)) {
            this.cursorToLastCharOnRow(n + 1, 0, false);
            return;
        }
        this.cursorSetPos(n, n3);
    }

    public void cursorUp(int n) {
        this.curRow -= n;
        if (this.curRow < 0) {
            if (this.wrapAroundLastLine) {
                this.curRow = this.rows + this.curRow;
            } else {
                this.curRow = 0;
                this.setVisTopDelta(-1);
            }
        }
        this.updateCursorPosition();
    }

    public void cursorDown(int n) {
        if (!this.wrapAroundLastLine && this.visTop + this.curRow == this.getLastRow() - 1) {
            this.scrollUp(n);
        }
        this.curRow += n;
        if (this.curRow > this.rows - 1) {
            int n2 = this.curRow - (this.rows - 1);
            if (this.wrapAroundLastLine) {
                this.curRow = n2 - 1;
            } else {
                this.curRow = this.rows - 1;
                this.setVisTopDelta(n2);
            }
        }
        this.updateCursorPosition();
    }

    public void cursorForward(int n) {
        this.curCol += n;
        if (this.curCol >= this.cols) {
            this.curCol = 0;
            this.cursorDown(1);
        }
        this.updateCursorPosition();
    }

    public void cursorBackward(int n) {
        this.curCol -= n;
        if (this.curCol < 0) {
            this.curCol = this.cols - (0 - this.curCol);
            this.cursorUp(1);
        }
        this.updateCursorPosition();
    }

    public void scrollUp(int n) {
        int n2 = 0;
        boolean bl = false;
        if (this.rows == this.rows && this.saveLines > 0) {
            int n3;
            int n4 = n3 = n < this.rows ? n : this.rows;
            if (this.visTop + n3 > this.saveLines) {
                if (this.hasSelection) {
                    if (this.selectTopRow - n < 0) {
                        this.resetSelection();
                    } else {
                        this.scrollSelection(-n);
                    }
                }
                int n5 = this.rows - n3;
                System.arraycopy(this.screen, n3, this.screen, 0, this.saveLines + n5);
                System.arraycopy(this.autowraps, n3, this.autowraps, 0, this.saveLines + n5);
                for (int i = this.rows - n3; i < this.rows; ++i) {
                    this.screen[this.saveLines + i] = this.makeCharLine();
                    this.autowraps[this.saveLines + i] = false;
                }
            } else {
                this.visTop += n3;
                bl = true;
            }
        } else {
            if (n < this.rows) {
                int n6 = this.visTop + 0 + n;
                int n7 = this.visTop + 0;
                int n8 = this.rows - n;
                n2 = this.rows - n + 0;
                System.arraycopy(this.screen, n6, this.screen, n7, n8);
                System.arraycopy(this.autowraps, n6, this.autowraps, n7, n8);
            }
            for (int i = n2; i < this.rows; ++i) {
                this.screen[this.visTop + i] = this.makeCharLine();
                this.autowraps[this.visTop + i] = false;
            }
        }
        if (bl && this.display != null) {
            this.display.setVisTop(this.visTop);
        }
        this.updateCursorPosition();
        this.updateDirtyArea(0, 0, this.rows, this.cols);
    }

    public void scrollDown(int n) {
        int n2 = this.rows;
        if (n < this.rows) {
            n2 = 0 + n;
            int n3 = this.visTop + 0;
            int n4 = this.visTop + 0 + n;
            int n5 = this.rows - n;
            System.arraycopy(this.screen, n3, this.screen, n4, n5);
            System.arraycopy(this.autowraps, n3, this.autowraps, n4, n5);
        }
        for (int i = 0; i < n2; ++i) {
            this.screen[this.visTop + i] = this.makeCharLine();
            this.autowraps[this.visTop + i] = false;
        }
        this.updateCursorPosition();
        this.updateDirtyArea(0, 0, this.rows, this.cols);
    }

    public void clearBelow() {
        this.clearBelow(true);
    }

    public void clearBelow(boolean bl) {
        this.clearRight(bl);
        int n = bl ? this.curRow : this.bufferRow;
        for (int i = n + this.visTop; i < this.getTotalLines(); ++i) {
            this.screen[i] = this.makeCharLine();
            this.autowraps[i] = false;
            this.attribMap.clearLine(i);
        }
        if (this.isIntersectingSelect(n, 0, this.rows, this.cols)) {
            this.resetSelection();
        }
        this.updateDirtyArea(n, 0, this.rows, this.cols);
    }

    protected void clear(int n, int n2, int n3) {
        System.arraycopy(this.defaultChars, 0, this.screen[this.visTop + n], n2, n3 - n2);
        this.attribMap.clear(this.visTop + n, n2, n3);
        if (this.isIntersectingSelect(n, n2, n + 1, n3 + 1)) {
            this.resetSelection();
        }
        this.updateDirtyArea(n, n2, n + 1, n3 + 1);
    }

    public void clear(int n, int n2, int n3, int n4) {
        if (n == n3) {
            this.clear(n, n2, n4);
        } else {
            this.clear(n, n2, this.cols - 1);
            for (int i = n + 1; i < n3; ++i) {
                this.clear(i, 0, this.cols - 1);
            }
            this.clear(n3, 0, n3);
        }
    }

    public void clearScreen() {
        for (int i = 0; i < this.rows; ++i) {
            this.screen[this.visTop + i] = this.makeCharLine();
            this.autowraps[this.visTop + i] = false;
            this.attribMap.clearLine(this.visTop + i);
        }
        if (this.isIntersectingSelect(0, 0, this.rows, this.cols)) {
            this.resetSelection();
        }
        this.updateDirtyArea(0, 0, this.rows, this.cols);
    }

    public void clearRight() {
        this.clearRight(true);
    }

    public void clearRight(boolean bl) {
        int n = bl ? this.curRow : this.bufferRow;
        int n2 = bl ? this.curCol : this.bufferCol;
        this.clear(n, n2, this.cols);
    }

    public void insertChars(int n) {
        this.insertChars(n, true);
    }

    public void insertChars(int n, boolean bl) {
        int n2;
        int n3 = this.cols;
        int n4 = bl ? this.curRow : this.bufferRow;
        int n5 = n2 = bl ? this.curCol : this.bufferCol;
        if (n2 < 0 || n2 > this.cols) {
            return;
        }
        if (n2 + n < this.cols) {
            n3 = n2 + n;
            System.arraycopy(this.screen[this.visTop + n4], n2, this.screen[this.visTop + n4], n3, this.cols - n3);
        }
        System.arraycopy(spacerow, 0, this.screen[this.visTop + n4], n2, n3 - n2);
        this.attribMap.insertChars(this.visTop + n4, n2, n);
        if (this.isIntersectingSelect(n4, n2, n4 + 1, this.cols)) {
            this.resetSelection();
        }
        this.updateDirtyArea(n4, n2, n4 + 1, this.cols);
    }

    public void deleteChars(int n) {
        this.deleteChars(n, true);
    }

    public void deleteChars(int n, boolean bl) {
        int n2;
        int n3 = bl ? this.curRow : this.bufferRow;
        int n4 = n2 = bl ? this.curCol : this.bufferCol;
        if (n2 < 0 || n2 > this.cols) {
            return;
        }
        if (n2 + n < this.cols) {
            n4 = this.cols - n;
            System.arraycopy(this.screen[this.visTop + n3], n2 + n, this.screen[this.visTop + n3], n2, n4 - n2);
        }
        System.arraycopy(spacerow, 0, this.screen[this.visTop + n3], n4, this.cols - n4);
        this.attribMap.deleteChars(this.visTop + n3, n2, n);
        if (this.isIntersectingSelect(n3, n2, n3 + 1, this.cols)) {
            this.resetSelection();
        }
        this.updateDirtyArea(n3, n2, n3 + 1, this.cols);
    }

    public void insertLines(int n) {
        this.insertLines(n, true);
    }

    public void insertLines(int n, boolean bl) {
        int n2;
        int n3 = bl ? this.curRow : this.bufferRow;
        int n4 = bl ? this.curCol : this.bufferCol;
        int n5 = this.rows;
        if (n3 < 0 || n3 > this.rows) {
            return;
        }
        if (n3 + n < this.rows) {
            n5 = n3 + n;
            System.arraycopy(this.screen, this.visTop + n3, this.screen, this.visTop + n5, this.rows - n5);
            System.arraycopy(this.autowraps, this.visTop + n3, this.autowraps, this.visTop + n5, this.rows - n5);
        }
        for (n2 = n3; n2 < n5; ++n2) {
            this.screen[this.visTop + n2] = this.makeCharLine();
            this.autowraps[this.visTop + n2] = false;
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.attribMap.insertLine(this.visTop + n3);
        }
        if (this.isIntersectingSelect(n3, 0, this.rows, this.cols)) {
            this.resetSelection();
        }
        this.updateDirtyArea(n3, 0, this.rows, this.cols);
    }

    public void deleteLines(int n) {
        this.deleteLines(n, true);
    }

    public void deleteLines(int n, boolean bl) {
        int n2;
        int n3 = bl ? this.curRow : this.bufferRow;
        int n4 = bl ? this.curCol : this.bufferCol;
        int n5 = n3;
        if (n3 < 0 || n3 > this.rows) {
            return;
        }
        if (n3 + n < this.rows) {
            n5 = this.rows - n;
            System.arraycopy(this.screen, this.visTop + n3 + n, this.screen, this.visTop + n3, n5 - n3);
            System.arraycopy(this.autowraps, this.visTop + n3 + n, this.autowraps, this.visTop + n3, n5 - n3);
        }
        for (n2 = n5; n2 < this.rows; ++n2) {
            this.screen[this.visTop + n2] = this.makeCharLine();
            this.autowraps[this.visTop + n2] = false;
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.attribMap.deleteLine(this.visTop + n3);
        }
        if (this.isIntersectingSelect(n3, 0, this.rows, this.cols)) {
            this.resetSelection();
        }
        this.updateDirtyArea(n3, 0, this.rows, this.cols);
    }

    public void setAttribute(int n) {
        this.attribMap.add(this.visTop + this.curRow, this.curCol, n);
        this.cursorWrite(' ', this.insertMode, true);
    }

    public void setDefaultAttribute(int n) {
        this.attribMap.setDefault(n);
    }

    protected int nextPrintedChar(int n, int n2) {
        int n3;
        for (n3 = n2; n3 < this.cols && this.screen[n][n3] == this.defaultChar; ++n3) {
        }
        return n3;
    }

    protected int prevPrintedChar(int n, int n2) {
        int n3;
        for (n3 = n2; n3 >= 0 && this.screen[n][n3] == this.defaultChar; --n3) {
        }
        return n3;
    }

    protected String addSpaces(int n, int n2) {
        int n3 = n2 - n;
        if (n2 == this.cols) {
            return "";
        }
        char[] cArray = new char[n3];
        System.arraycopy(spacerow, 0, cArray, 0, n3);
        return new String(cArray);
    }

    protected boolean isIntersectingSelect(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        if (!this.hasSelection) {
            return false;
        }
        n += this.visTop;
        n3 += this.visTop;
        if (this.selectTopCol < this.selectBottomCol) {
            n8 = this.selectTopCol;
            n7 = this.selectBottomCol;
        } else {
            n8 = this.selectBottomCol;
            n7 = this.selectTopCol;
        }
        if (n2 < n4) {
            n6 = n2;
            n5 = n4;
        } else {
            n6 = n4;
            n5 = n2;
        }
        if (this.selectTopRow > n3) {
            return false;
        }
        if (this.selectBottomRow < n) {
            return false;
        }
        if (n8 > n5) {
            return false;
        }
        return n7 >= n6;
    }

    public void resetSelection() {
        this.hasSelection = false;
        if (this.display != null) {
            this.display.resetSelection();
        }
    }

    public void selectAll() {
        this.setSelection(this.visTop, 0, this.visTop + this.rows - 1, this.cols - 1);
    }

    protected void scrollSelection(int n) {
        if (!this.hasSelection) {
            return;
        }
        int n2 = this.selectTopRow + n;
        int n3 = this.selectBottomRow + n;
        this.setSelection(n2, this.selectTopCol, n3, this.selectBottomCol);
    }

    public void setSelection(int n, int n2, int n3, int n4) {
        if (n < n3) {
            this.selectTopRow = n;
            this.selectTopCol = n2;
            this.selectBottomRow = n3;
            this.selectBottomCol = n4;
        } else if (n == n3) {
            this.selectTopRow = this.selectBottomRow = n;
            if (n2 < n4) {
                this.selectTopCol = n2;
                this.selectBottomCol = n4;
            } else {
                this.selectTopCol = n4;
                this.selectBottomCol = n2;
            }
        } else {
            this.selectTopRow = n3;
            this.selectTopCol = n4;
            this.selectBottomRow = n;
            this.selectBottomCol = n2;
        }
        this.hasSelection = true;
        if (this.display != null) {
            this.display.resetSelection();
            this.display.setSelection(this.selectTopRow, this.selectTopCol, this.selectBottomRow, this.selectBottomCol);
        }
    }

    public String getSelection(String string) {
        if (!this.hasSelection) {
            return null;
        }
        if (string == null) {
            string = "\r";
        }
        return this.getContents(this.selectTopRow, this.selectTopCol, this.selectBottomRow, this.selectBottomCol, string);
    }

    protected String getContents(int n, int n2, int n3, int n4, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n != n3) {
            int n5;
            int n6;
            for (n6 = n2; n6 < this.cols; ++n6) {
                if (this.screen[n][n6] == '\u0000') {
                    n5 = this.nextPrintedChar(n, n6);
                    stringBuffer.append(this.addSpaces(n6, n5));
                    n6 = n5 - 1;
                    continue;
                }
                stringBuffer.append(this.screen[n][n6]);
            }
            if (n6 == this.cols && !this.autowraps[n]) {
                stringBuffer.append(string);
            }
            for (n6 = n + 1; n6 < n3; ++n6) {
                for (int i = 0; i < this.cols; ++i) {
                    if (this.screen[n6][i] == '\u0000') {
                        n5 = this.nextPrintedChar(n6, i);
                        stringBuffer.append(this.addSpaces(i, n5));
                        i = n5 - 1;
                        continue;
                    }
                    stringBuffer.append(this.screen[n6][i]);
                }
                if (this.autowraps[n6]) continue;
                stringBuffer.append(string);
            }
            for (n6 = 0; n6 <= n4; ++n6) {
                if (this.screen[n3][n6] == '\u0000') {
                    n5 = this.nextPrintedChar(n3, n6);
                    stringBuffer.append(this.addSpaces(n6, n5));
                    n6 = n5 - 1;
                    continue;
                }
                stringBuffer.append(this.screen[n3][n6]);
            }
            if (n6 == this.cols && !this.autowraps[n3]) {
                stringBuffer.append(string);
            }
        } else {
            int n7;
            for (n7 = n2; n7 <= n4; ++n7) {
                if (this.screen[n][n7] == '\u0000') {
                    int n8 = this.nextPrintedChar(n, n7);
                    stringBuffer.append(this.addSpaces(n7, n8));
                    n7 = n8 - 1;
                    continue;
                }
                stringBuffer.append(this.screen[n][n7]);
            }
            if (n7 == this.cols) {
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public void resetClickSelect() {
        this.selectClickRow = -1;
        this.selectClickState = false;
    }

    public void doClickSelect(int n, int n2, String string) {
        int n3;
        int n4;
        if (this.selectClickRow == n && this.selectClickState) {
            n4 = 0;
            n3 = this.cols - 1;
        } else {
            if (this.screen[n][n2] != '\u0000') {
                int n5;
                for (n5 = n2; n5 >= 0 && string.indexOf(this.screen[n][n5]) == -1 && this.screen[n][n5] != '\u0000'; --n5) {
                }
                n4 = n5 + 1;
                for (n5 = n2; n5 < this.cols && string.indexOf(this.screen[n][n5]) == -1 && this.screen[n][n5] != '\u0000'; ++n5) {
                }
                n3 = n5 - 1;
            } else {
                n4 = this.prevPrintedChar(n, n2) + 1;
                n3 = this.nextPrintedChar(n, n2) - 1;
            }
            n4 = n4 > n2 ? n2 : n4;
            n3 = n3 < n2 ? n2 : n3;
        }
        this.selectClickState = !this.selectClickState;
        this.selectClickRow = n;
        this.setSelection(n, n4, n, n3);
    }

    public SearchContext search(SearchContext searchContext, String string, boolean bl, boolean bl2) {
        int n;
        char c;
        int n2 = string.length();
        int n3 = this.rows + this.saveLines;
        boolean bl3 = false;
        int n4 = 0;
        char c2 = c = bl2 ? string.charAt(0) : Character.toLowerCase(string.charAt(0));
        if (bl) {
            block21: {
                int n5;
                int n6;
                if (searchContext != null) {
                    n6 = searchContext.getStartRow();
                    n5 = searchContext.getStartCol() - 1;
                    if (n5 < 0) {
                        --n6;
                    }
                } else {
                    n6 = n3;
                    n5 = this.cols - n2;
                }
                n6 = n6 < 0 ? 0 : n6;
                n6 = n6 > n3 - 1 ? n3 - 1 : n6;
                n5 = n5 < 0 ? 0 : n5;
                n5 = n5 > this.cols - 1 ? this.cols - 1 : n5;
                try {
                    for (n = n6; n >= 0; --n) {
                        for (n4 = n5; n4 >= 0; --n4) {
                            if (!this.doMatch(string, c, this.screen[n], n4, bl2, n2)) {
                                continue;
                            }
                            break block21;
                        }
                        n5 = this.cols - 1;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    arrayIndexOutOfBoundsException.printStackTrace();
                    return null;
                }
            }
            if (n >= 0) {
                bl3 = true;
            }
        } else {
            block22: {
                int n7;
                int n8;
                if (searchContext != null) {
                    n8 = searchContext.getEndRow();
                    n7 = searchContext.getEndCol() + 1;
                    if (n7 >= this.cols) {
                        ++n8;
                    }
                } else {
                    n8 = 0;
                    n7 = 0;
                }
                n8 = n8 < 0 ? 0 : n8;
                n8 = n8 > n3 - 1 ? n3 - 1 : n8;
                n7 = n7 < 0 ? 0 : n7;
                n7 = n7 > this.cols - 1 ? this.cols - 1 : n7;
                try {
                    for (n = n8; n < n3; ++n) {
                        for (n4 = n7; n4 < this.cols - n2; ++n4) {
                            if (!this.doMatch(string, c, this.screen[n], n4, bl2, n2)) {
                                continue;
                            }
                            break block22;
                        }
                        n7 = 0;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    arrayIndexOutOfBoundsException.printStackTrace();
                    return null;
                }
            }
            if (n < n3) {
                bl3 = true;
            }
        }
        if (bl3) {
            return new SearchContext(n, n4, n, n4 + n2 - 1);
        }
        return null;
    }

    protected boolean doMatch(String string, char c, char[] cArray, int n, boolean bl, int n2) {
        if (bl) {
            if (cArray[n] != c) {
                return false;
            }
            String string2 = new String(cArray, n, n2);
            if (string2.equals(string)) {
                return true;
            }
        } else {
            if (Character.toLowerCase(cArray[n]) != c) {
                return false;
            }
            String string3 = new String(cArray, n, n2);
            if (string3.equalsIgnoreCase(string)) {
                return true;
            }
        }
        return false;
    }

    public String getStatus() {
        return "size=" + this.rows + "," + this.cols + " " + "visTop=" + this.visTop + " " + "curPos=" + this.curRow + "," + this.curCol + " ";
    }

    public int getLastRow() {
        return this.saveLines + this.rows;
    }

    public void setVisTop(int n) {
        this.visTop = n;
        if (this.visTop < 0) {
            this.visTop = 0;
        }
        if (this.visTop > this.saveLines) {
            this.visTop = this.saveLines;
        }
        if (this.display != null) {
            this.display.setVisTop(this.visTop);
        }
        this.updateCursorPosition();
    }

    public void setVisTopDelta(int n) {
        this.setVisTop(this.visTop + n);
    }

    public String spaceToNextTabStop() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = this.curCol + 1; n < this.cols; ++n) {
            stringBuffer.append(' ');
            if (this.tabStops[n]) break;
        }
        if (n == this.cols) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public void doHTab() {
        if (this.curCol < this.cols) {
            int n;
            for (n = this.curCol + 1; n < this.cols && !this.tabStops[n]; ++n) {
            }
            if (n < this.cols) {
                this.cursorSetPos(this.curRow, n);
            } else {
                this.doCR();
                this.cursorDown(1);
            }
        }
    }

    public void setTab(boolean bl) {
        if (bl) {
            this.tabStops[this.curCol] = true;
        } else {
            this.tabStops[this.bufferCol] = true;
        }
    }

    public void clearTab(boolean bl) {
        if (bl) {
            this.tabStops[this.curCol] = false;
        } else {
            this.tabStops[this.bufferCol] = false;
        }
    }

    public void clearAllTabs() {
        for (int i = 0; i < 512; ++i) {
            this.tabStops[i] = false;
        }
    }

    public void resetTabs() {
        for (int i = 0; i < 512; ++i) {
            this.tabStops[i] = false;
        }
    }

    public void reset() {
        this.curCol = 0;
        this.curRow = 0;
        this.bufferCol = 0;
        this.bufferRow = 0;
        this.visTop = 0;
    }

    public Screen6530Buffer getBuffer() {
        Screen6530Buffer screen6530Buffer = new Screen6530Buffer(this.rows, this.cols);
        for (int i = 0; i < this.rows; ++i) {
            int n = this.visTop + i;
            for (int j = 0; j < this.cols; ++j) {
                if (this.attribMap.isAttrib(n, j)) {
                    screen6530Buffer.setAttrib(i, j, this.attribMap.attribAt(n, j));
                    continue;
                }
                screen6530Buffer.setChar(i, j, this.screen[n][j]);
            }
        }
        return screen6530Buffer;
    }

    public void setBuffer(Screen6530Buffer screen6530Buffer) {
        int n = screen6530Buffer.getCols() < this.cols ? screen6530Buffer.getCols() : this.cols;
        int n2 = screen6530Buffer.getRows() < this.rows ? screen6530Buffer.getRows() : this.rows;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.visTop + i;
            for (int j = 0; j < n; ++j) {
                if (screen6530Buffer.isAttrib(i, j)) {
                    this.attribMap.add(n3, j, screen6530Buffer.getAttrib(i, j));
                    this.screen[n3][j] = 32;
                    continue;
                }
                this.screen[n3][j] = screen6530Buffer.getChar(i, j);
            }
        }
    }

    public String readWhole() {
        return this.read(0, 0, this.rows - 1, this.cols - 1);
    }

    public String read(int n, int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n == n3) {
            this.readLine(stringBuffer, n, n2, n4);
        } else {
            this.readLine(stringBuffer, n, n2, this.cols - 1);
            for (int i = n + 1; i < n3; ++i) {
                this.readLine(stringBuffer, i, 0, this.cols - 1);
            }
            this.readLine(stringBuffer, n3, 0, n4);
        }
        stringBuffer.append('\u0004');
        return stringBuffer.toString();
    }

    protected void readLine(StringBuffer stringBuffer, int n, int n2, int n3) {
        int n4;
        int n5 = this.prevPrintedChar(this.visTop + n, this.cols - 1);
        for (n4 = this.cols - 1; n4 > n5; --n4) {
            if (!this.attribMap.isAttrib(this.visTop + n, n4)) continue;
            n5 = n4;
            break;
        }
        if (n2 < n5) {
            n4 = n5 < n3 ? n5 : n3;
            int[] nArray = this.getAttribsAt(this.visTop, n);
            for (int i = n2; i <= n4; ++i) {
                if (this.attribMap.isAttrib(this.visTop + n, i)) {
                    stringBuffer.append('\u001b');
                    stringBuffer.append('6');
                    stringBuffer.append((char)(0x20 | nArray[i]));
                    continue;
                }
                stringBuffer.append(this.screen[this.visTop + n][i]);
            }
        }
        stringBuffer.append('\r');
    }

    static {
        for (int i = 0; i < 512; ++i) {
            Screen6530.spacerow[i] = 32;
            Screen6530.zerorow[i] = 0;
        }
    }
}

