/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2Channel;
import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2StreamFilter;
import com.mindbright.ssh2.SSH2TransportPDU;
import com.mindbright.util.Queue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class SSH2StreamChannel
extends SSH2Channel {
    protected InputStream in;
    protected OutputStream out;
    protected Thread transmitter;
    protected Thread receiver;
    protected Queue rxQueue;
    protected long txCounter;
    protected long rxCounter;
    private boolean rxChanIsQueued;

    protected SSH2StreamChannel(int n, SSH2Connection sSH2Connection, Object object, InputStream inputStream, OutputStream outputStream) {
        super(n, sSH2Connection, object);
        this.rxChanIsQueued = "true".equals(sSH2Connection.getPreferences().getPreference("queued-rx-chan"));
        this.in = inputStream;
        this.out = outputStream;
        this.createStreams();
    }

    public void applyFilter(SSH2StreamFilter sSH2StreamFilter) {
        if (sSH2StreamFilter != null) {
            this.in = sSH2StreamFilter.getInputFilter(this.in);
            this.out = sSH2StreamFilter.getOutputFilter(this.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void channelTransmitLoop() {
        this.connection.getLog().debug("SSH2StreamChannel", "starting ch. #" + this.channelId + " (" + this.getType() + ") transmitter");
        Thread.yield();
        try {
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            while (!this.eofSent && !this.closeSent) {
                SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(94, this.txMaxPktSz + 256);
                sSH2TransportPDU.writeInt(this.peerChanId);
                n = this.checkTxWindowSize(n2);
                do {
                    try {
                        n2 = this.in.read(sSH2TransportPDU.data, sSH2TransportPDU.wPos + 4, n);
                        bl = false;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        bl = true;
                    }
                } while (bl);
                if (n2 == -1) {
                    this.sendEOF();
                    continue;
                }
                if (this.eofSent || this.closeSent) continue;
                sSH2TransportPDU.writeInt(n2);
                sSH2TransportPDU.wPos += n2;
                this.txCounter += (long)n2;
                this.transmit(sSH2TransportPDU);
            }
        }
        catch (IOException iOException) {
            if (!this.eofSent) {
                this.connection.getLog().error("SSH2StreamChannel", "channelTransmitLoop", iOException.toString());
            }
        }
        finally {
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException iOException) {}
            this.sendClose();
        }
        this.connection.getLog().debug("SSH2StreamChannel", "exiting ch. #" + this.channelId + " (" + this.getType() + ") transmitter, " + this.txCounter + " bytes tx");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void channelReceiveLoop() {
        this.connection.getLog().debug("SSH2StreamChannel", "starting ch. #" + this.channelId + " (" + this.getType() + ") receiver");
        Thread.yield();
        try {
            SSH2TransportPDU sSH2TransportPDU;
            while ((sSH2TransportPDU = (SSH2TransportPDU)this.rxQueue.getFirst()) != null) {
                this.rxWrite(sSH2TransportPDU);
            }
        }
        catch (IOException iOException) {
            this.connection.getLog().error("SSH2StreamChannel", "channelReceiveLoop", iOException.toString());
        }
        finally {
            this.rxClosing();
        }
        this.connection.getLog().debug("SSH2StreamChannel", "exiting ch. #" + this.channelId + " (" + this.getType() + ") receiver, " + this.rxCounter + " bytes rx");
    }

    private final void rxWrite(SSH2TransportPDU sSH2TransportPDU) throws IOException {
        int n = sSH2TransportPDU.readInt();
        int n2 = sSH2TransportPDU.getRPos();
        this.rxCounter += (long)n;
        this.out.write(sSH2TransportPDU.data, n2, n);
        sSH2TransportPDU.release();
        this.checkRxWindowSize(n);
    }

    private final void rxClosing() {
        this.eofSent = true;
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.outputClosed();
        if (this.txCurrWinSz == 0) {
            this.txCurrWinSz = -1;
            this.transmitter.interrupt();
        }
    }

    private final synchronized int checkTxWindowSize(int n) {
        this.txCurrWinSz -= n;
        while (this.txCurrWinSz == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                if (this.eofSent) continue;
                this.connection.getLog().error("SSH2StreamChannel", "checkTxWindowSize", "window adjust wait interrupted");
            }
        }
        int n2 = this.txCurrWinSz < this.txMaxPktSz ? this.txCurrWinSz : this.txMaxPktSz;
        return n2;
    }

    protected final void checkRxWindowSize(int n) {
        this.rxCurrWinSz -= n;
        if (this.rxCurrWinSz < 0) {
            this.connection.fatalDisconnect(2, "Peer overflowed window");
        } else if (this.rxCurrWinSz <= this.rxInitWinSz >>> 1) {
            SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(93);
            sSH2TransportPDU.writeInt(this.peerChanId);
            sSH2TransportPDU.writeInt(this.rxInitWinSz - this.rxCurrWinSz);
            this.transmit(sSH2TransportPDU);
            this.rxCurrWinSz = this.rxInitWinSz;
        }
    }

    protected void data(SSH2TransportPDU sSH2TransportPDU) {
        if (this.rxChanIsQueued) {
            this.rxQueue.putLast(sSH2TransportPDU);
        } else {
            try {
                this.rxWrite(sSH2TransportPDU);
            }
            catch (IOException iOException) {
                this.connection.getLog().error("SSH2StreamChannel", "data", iOException.toString());
                this.rxClosing();
            }
        }
    }

    protected void openConfirmationImpl(SSH2TransportPDU sSH2TransportPDU) {
        this.startStreams();
    }

    protected boolean openFailureImpl(int n, String string, String string2) {
        return false;
    }

    protected synchronized void windowAdjustImpl(int n) {
        this.txCurrWinSz += n;
        this.notify();
    }

    protected void eofImpl() {
        if (this.rxChanIsQueued) {
            this.rxQueue.setBlocking(false);
        } else {
            this.rxClosing();
        }
    }

    protected void closeImpl() {
        this.eofImpl();
    }

    protected void outputClosed() {
    }

    protected void handleRequestImpl(String string, boolean bl, SSH2TransportPDU sSH2TransportPDU) {
    }

    protected void createStreams() {
        if (this.rxChanIsQueued) {
            this.receiver = new Thread(new Runnable(){

                public void run() {
                    SSH2StreamChannel.this.channelReceiveLoop();
                }
            }, "SSH2StreamRX_" + this.getType() + "_" + this.channelId);
            this.receiver.setDaemon(false);
            this.rxQueue = new Queue(this.connection.getPreferences().getIntPreference("queue-depth"), this.connection.getPreferences().getIntPreference("queue-hiwater"));
        }
        this.transmitter = new Thread(new Runnable(){

            public void run() {
                SSH2StreamChannel.this.channelTransmitLoop();
            }
        }, "SSH2StreamTX_" + this.getType() + "_" + this.channelId);
        this.transmitter.setDaemon(false);
    }

    protected void startStreams() {
        this.transmitter.start();
        if (this.rxChanIsQueued) {
            this.receiver.start();
        }
    }

    public void waitUntilClosed() {
        super.waitUntilClosed();
        if (this.rxChanIsQueued) {
            try {
                this.receiver.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

