/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.jca.security.GeneralSecurityException;
import com.mindbright.jca.security.MessageDigest;
import com.mindbright.jce.crypto.Cipher;
import com.mindbright.jce.crypto.Mac;
import com.mindbright.jce.crypto.spec.SecretKeySpec;
import com.mindbright.ssh2.SSH2DataBuffer;
import com.mindbright.ssh2.SSH2FatalException;
import com.mindbright.util.Base64;
import com.mindbright.util.HexDump;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class SSH2PuttyKeyFile {
    private boolean version1;
    private String format;
    private String encryption;
    private String comment;
    private String pubblob;
    private byte[] pubbytes;
    private String privblob;
    private byte[] privbytes;
    private String privmacorhash;
    private boolean isprivmac;

    public SSH2PuttyKeyFile(InputStream inputStream) throws IOException {
        this.load(inputStream);
    }

    public void load(InputStream inputStream) throws IOException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
        String string = stringTokenizer.nextToken();
        this.version1 = string.endsWith("-1:");
        this.format = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(bufferedReader.readLine());
        stringTokenizer.nextToken();
        this.encryption = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(bufferedReader.readLine());
        stringTokenizer.nextToken();
        this.comment = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(bufferedReader.readLine());
        stringTokenizer.nextToken();
        string = stringTokenizer.nextToken();
        int n2 = Integer.parseInt(string);
        this.pubblob = "";
        for (n = 0; n < n2; ++n) {
            this.pubblob = this.pubblob + bufferedReader.readLine();
        }
        this.pubbytes = Base64.decode(this.pubblob.getBytes());
        stringTokenizer = new StringTokenizer(bufferedReader.readLine());
        stringTokenizer.nextToken();
        string = stringTokenizer.nextToken();
        n2 = Integer.parseInt(string);
        this.privblob = "";
        for (n = 0; n < n2; ++n) {
            this.privblob = this.privblob + bufferedReader.readLine();
        }
        stringTokenizer = new StringTokenizer(bufferedReader.readLine());
        this.isprivmac = stringTokenizer.nextToken().equals("Private-MAC:");
        this.privmacorhash = stringTokenizer.nextToken();
    }

    public boolean validate(String string) throws SSH2FatalException {
        Object object;
        byte[] byArray;
        MessageDigest messageDigest;
        Object object2;
        byte[] byArray2 = Base64.decode(this.privblob.getBytes());
        if (this.encryption.equals("none")) {
            this.privbytes = byArray2;
        } else if (this.encryption.equals("aes256-cbc")) {
            try {
                object2 = new byte[40];
                messageDigest = MessageDigest.getInstance("SHA1");
                byArray = string == null ? new byte[]{} : string.getBytes();
                messageDigest.update(new byte[]{0, 0, 0, 0});
                messageDigest.update(byArray);
                messageDigest.digest((byte[])object2, 0, 20);
                messageDigest.reset();
                messageDigest.update(new byte[]{0, 0, 0, 1});
                messageDigest.update(byArray);
                messageDigest.digest((byte[])object2, 20, 20);
                object = Cipher.getInstance("AES/CBC");
                ((Cipher)object).init(1, new SecretKeySpec((byte[])object2, 0, 32, ((Cipher)object).getAlgorithm()));
                this.privbytes = ((Cipher)object).doFinal(byArray2);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new SSH2FatalException("Failed to decrypt PuTTY private key");
            }
        } else {
            throw new SSH2FatalException("Failed to decrypt PuTTY private key - unsupported encryption type: " + this.encryption);
        }
        if (this.version1) {
            byArray = this.privbytes;
        } else {
            object2 = new SSH2DataBuffer(32768);
            object2.writeString(this.format);
            object2.writeString(this.encryption);
            object2.writeString(this.comment);
            object2.writeString(this.pubbytes);
            object2.writeString(this.privbytes);
            byArray = object2.readRestRaw();
        }
        object2 = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
            if (this.isprivmac) {
                messageDigest.update("putty-private-key-file-mac-key".getBytes());
                if (!this.encryption.equals("none") && string != null) {
                    messageDigest.update(string.getBytes());
                }
                object = messageDigest.digest();
                Mac mac = Mac.getInstance("HmacSHA1");
                mac.init(new SecretKeySpec((byte[])object, 0, 20, mac.getAlgorithm()));
                object2 = mac.doFinal(byArray);
            } else {
                object2 = messageDigest.digest(byArray);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SSH2FatalException("Failed to calculate hash for PuTTY key file");
        }
        return object2 != null && this.privmacorhash.equals(HexDump.toString(object2));
    }

    public byte[] getPublicKeyBlob() {
        return this.pubbytes;
    }

    public byte[] getPrivateKeyBlob() {
        return this.privbytes;
    }

    public String getFormat() {
        return this.format;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "version1=" + this.version1 + ",format=" + this.format + ",encryption=" + this.encryption + ",comment=" + this.comment + ",pubblob=" + this.pubblob + ",privblob=" + this.privblob + ",privmacorhash=" + this.privmacorhash + ",isprivmac=" + this.isprivmac;
    }
}

