/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.publickey;

import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.interfaces.DSAParams;
import com.mindbright.jca.security.interfaces.DSAPrivateKey;
import com.mindbright.jca.security.interfaces.DSAPublicKey;
import com.mindbright.security.publickey.BaseSignature;
import com.mindbright.security.publickey.DSAAlgorithm;
import java.math.BigInteger;

public class RawDSAWithSHA1
extends BaseSignature {
    public RawDSAWithSHA1() {
        super("SHA1");
    }

    protected void initVerify() throws InvalidKeyException {
        if (this.publicKey == null || !(this.publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("Wrong key for DSAWithSHA1 verify: " + this.publicKey);
        }
    }

    protected void initSign() throws InvalidKeyException {
        if (this.privateKey == null || !(this.privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("Wrong key for DSAWithSHA1 sign: " + this.privateKey);
        }
    }

    protected byte[] sign(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)this.privateKey;
        DSAParams dSAParams = dSAPrivateKey.getParams();
        BigInteger bigInteger4 = dSAPrivateKey.getX();
        BigInteger[] bigIntegerArray = DSAAlgorithm.sign(bigInteger4, bigInteger3 = dSAParams.getP(), bigInteger2 = dSAParams.getQ(), bigInteger = dSAParams.getG(), byArray);
        if (bigIntegerArray == null || bigIntegerArray.length != 2) {
            return null;
        }
        BigInteger bigInteger5 = bigIntegerArray[0];
        BigInteger bigInteger6 = bigIntegerArray[1];
        int n = byArray.length;
        byte[] byArray2 = new byte[n * 2];
        byte[] byArray3 = RawDSAWithSHA1.unsignedBigIntToBytes(bigInteger5, n);
        System.arraycopy(byArray3, 0, byArray2, 0, n);
        byArray3 = RawDSAWithSHA1.unsignedBigIntToBytes(bigInteger6, n);
        System.arraycopy(byArray3, 0, byArray2, n, n);
        return byArray2;
    }

    protected boolean verify(byte[] byArray, byte[] byArray2) {
        DSAPublicKey dSAPublicKey = (DSAPublicKey)this.publicKey;
        DSAParams dSAParams = dSAPublicKey.getParams();
        BigInteger bigInteger = dSAPublicKey.getY();
        BigInteger bigInteger2 = dSAParams.getP();
        BigInteger bigInteger3 = dSAParams.getQ();
        BigInteger bigInteger4 = dSAParams.getG();
        int n = byArray.length / 2;
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        System.arraycopy(byArray, n, byArray4, 0, n);
        BigInteger bigInteger5 = new BigInteger(1, byArray3);
        BigInteger bigInteger6 = new BigInteger(1, byArray4);
        return DSAAlgorithm.verify(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, byArray2);
    }

    private static byte[] unsignedBigIntToBytes(BigInteger bigInteger, int n) {
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = null;
        if (byArray.length > n) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, byArray.length - n, byArray2, 0, n);
        } else if (byArray.length < n) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
        } else {
            byArray2 = byArray;
        }
        return byArray2;
    }
}

