/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.publickey;

import com.mindbright.asn1.ASN1DER;
import com.mindbright.asn1.ASN1Object;
import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.interfaces.DSAParams;
import com.mindbright.jca.security.interfaces.DSAPrivateKey;
import com.mindbright.jca.security.interfaces.DSAPublicKey;
import com.mindbright.security.publickey.BaseSignature;
import com.mindbright.security.publickey.DSAAlgorithm;
import com.mindbright.security.publickey.DSAWithSHA1;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public final class DSAWithSHA1
extends BaseSignature {
    public DSAWithSHA1() {
        super("SHA1");
    }

    protected void initVerify() throws InvalidKeyException {
        if (this.publicKey == null || !(this.publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("Wrong key for DSAWithSHA1 verify: " + this.publicKey);
        }
    }

    protected void initSign() throws InvalidKeyException {
        if (this.privateKey == null || !(this.privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("Wrong key for DSAWithSHA1 sign: " + this.privateKey);
        }
    }

    protected byte[] sign(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)this.privateKey;
        DSAParams dSAParams = dSAPrivateKey.getParams();
        BigInteger bigInteger4 = dSAPrivateKey.getX();
        BigInteger[] bigIntegerArray = DSAAlgorithm.sign(bigInteger4, bigInteger3 = dSAParams.getP(), bigInteger2 = dSAParams.getQ(), bigInteger = dSAParams.getG(), byArray);
        if (bigIntegerArray == null || bigIntegerArray.length != 2) {
            return null;
        }
        BigInteger bigInteger5 = bigIntegerArray[0];
        BigInteger bigInteger6 = bigIntegerArray[1];
        DSASIG dSASIG = new DSASIG(bigInteger5, bigInteger6);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
        ASN1DER aSN1DER = new ASN1DER();
        try {
            aSN1DER.encode(byteArrayOutputStream, (ASN1Object)dSASIG);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected boolean verify(byte[] byArray, byte[] byArray2) {
        DSAPublicKey dSAPublicKey = (DSAPublicKey)this.publicKey;
        DSAParams dSAParams = dSAPublicKey.getParams();
        BigInteger bigInteger = dSAPublicKey.getY();
        BigInteger bigInteger2 = dSAParams.getP();
        BigInteger bigInteger3 = dSAParams.getQ();
        BigInteger bigInteger4 = dSAParams.getG();
        DSASIG dSASIG = new DSASIG();
        try {
            ASN1DER aSN1DER = new ASN1DER();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            aSN1DER.decode(byteArrayInputStream, (ASN1Object)dSASIG);
        }
        catch (IOException iOException) {
            System.err.println("DSAWithSHA1.verify: " + iOException);
            return false;
        }
        return DSAAlgorithm.verify(bigInteger, bigInteger2, bigInteger3, bigInteger4, dSASIG.r.getValue(), dSASIG.s.getValue(), byArray2);
    }
}

