/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.publickey;

import com.mindbright.jca.security.SecureRandom;
import com.mindbright.jca.security.spec.DSAParameterSpec;
import com.mindbright.util.Math;
import java.math.BigInteger;

public final class DSAAlgorithm {
    private static final BigInteger one = BigInteger.valueOf(1L);

    public static BigInteger[] sign(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, byte[] byArray) {
        BigInteger bigInteger5 = new BigInteger(1, byArray);
        bigInteger5 = bigInteger5.mod(bigInteger3);
        BigInteger bigInteger6 = bigInteger4.modPow(bigInteger, bigInteger2).mod(bigInteger3);
        BigInteger bigInteger7 = bigInteger.modInverse(bigInteger3).multiply(bigInteger5.add(bigInteger.multiply(bigInteger6))).mod(bigInteger3);
        return new BigInteger[]{bigInteger6, bigInteger7};
    }

    public static boolean verify(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, byte[] byArray) {
        BigInteger bigInteger7 = new BigInteger(1, byArray);
        bigInteger7 = bigInteger7.mod(bigInteger3);
        BigInteger bigInteger8 = bigInteger6.modInverse(bigInteger3);
        BigInteger bigInteger9 = bigInteger7.multiply(bigInteger8).mod(bigInteger3);
        BigInteger bigInteger10 = bigInteger5.multiply(bigInteger8).mod(bigInteger3);
        BigInteger bigInteger11 = bigInteger4.modPow(bigInteger9, bigInteger2).multiply(bigInteger.modPow(bigInteger10, bigInteger2)).mod(bigInteger2).mod(bigInteger3);
        return bigInteger11.compareTo(bigInteger5) == 0;
    }

    public static DSAParameterSpec generateParams(int n, int n2, SecureRandom secureRandom) {
        BigInteger[] bigIntegerArray = Math.findRandomStrongPrime(n, n2, secureRandom);
        BigInteger bigInteger = Math.findRandomGenerator(bigIntegerArray[1], bigIntegerArray[0], secureRandom);
        return new DSAParameterSpec(bigIntegerArray[0], bigIntegerArray[1], bigInteger);
    }

    public static BigInteger generatePrivateKey(BigInteger bigInteger, SecureRandom secureRandom) {
        BigInteger bigInteger2;
        while ((bigInteger2 = new BigInteger(bigInteger.bitLength(), secureRandom)).compareTo(one) < 0 || bigInteger2.compareTo(bigInteger) > 0) {
        }
        return bigInteger2;
    }

    public static BigInteger generatePublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger.modPow(bigInteger3, bigInteger2);
    }
}

