/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.cipher;

import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.Key;
import com.mindbright.jca.security.SecureRandom;
import com.mindbright.jca.security.spec.AlgorithmParameterSpec;
import com.mindbright.jce.crypto.CipherSpi;
import com.mindbright.jce.crypto.spec.IvParameterSpec;
import com.mindbright.jce.crypto.spec.SecretKeySpec;

public abstract class BlockCipher
extends CipherSpi {
    static final int MODE_ECB = 0;
    static final int MODE_CBC = 1;
    static final int MODE_CFB = 2;
    static final int MODE_OFB = 3;
    static final int MODE_CTR = 4;
    byte[] iv;
    byte[] tmpBlk;
    byte[] ctr;
    int opMode;
    int feedbackMode;
    int streamBits;
    int blockSize;
    boolean pkcs5Padding;
    boolean ctrInit = false;

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = 0;
        switch (this.feedbackMode) {
            case 0: {
                n4 = this.internalDoFinalECB(byArray, n, n2, byArray2, n3);
                break;
            }
            case 1: {
                n4 = this.internalDoFinalCBC(byArray, n, n2, byArray2, n3);
                break;
            }
            case 2: {
                n4 = this.internalDoFinalCFB(byArray, n, n2, byArray2, n3);
                break;
            }
            case 3: {
                n4 = this.internalDoFinalOFB(byArray, n, n2, byArray2, n3);
                break;
            }
            case 4: {
                n4 = this.internalDoFinalCTR(byArray, n, n2, byArray2, n3);
                break;
            }
        }
        return n4;
    }

    private final int internalDoFinalECB(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n2 / this.blockSize;
        if (this.opMode == 2) {
            for (int i = 0; i < n4; ++i) {
                this.blockEncrypt(byArray, n, byArray2, n3);
                n += this.blockSize;
                n3 += this.blockSize;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                this.blockDecrypt(byArray, n, byArray2, n3);
                n += this.blockSize;
                n3 += this.blockSize;
            }
        }
        return n2;
    }

    private final int internalDoFinalCBC(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n2 / this.blockSize;
        if (this.opMode == 2) {
            int n5;
            for (n5 = 0; n5 < n4; ++n5) {
                BlockCipher.blockXor(byArray, n, this.blockSize, this.iv, 0);
                this.blockEncrypt(this.iv, 0, byArray2, n3);
                System.arraycopy(byArray2, n3, this.iv, 0, this.blockSize);
                n += this.blockSize;
                n3 += this.blockSize;
            }
            if (this.pkcs5Padding) {
                n5 = n2 % this.blockSize;
                int n6 = this.blockSize - n5;
                for (int i = 0; i < this.blockSize; ++i) {
                    if (i < n5) {
                        int n7 = i;
                        this.iv[n7] = (byte)(this.iv[n7] ^ byArray[n++]);
                        continue;
                    }
                    int n8 = i;
                    this.iv[n8] = (byte)(this.iv[n8] ^ (byte)n6);
                }
                this.blockEncrypt(this.iv, 0, byArray2, n3);
                System.arraycopy(byArray2, n3, this.iv, 0, this.blockSize);
                n2 += this.blockSize - n5;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                this.blockDecrypt(byArray, n, this.tmpBlk, 0);
                for (int j = 0; j < this.blockSize; ++j) {
                    int n9 = j;
                    this.tmpBlk[n9] = (byte)(this.tmpBlk[n9] ^ this.iv[j]);
                    this.iv[j] = byArray[n + j];
                    byArray2[n3 + j] = this.tmpBlk[j];
                }
                n += this.blockSize;
                n3 += this.blockSize;
            }
        }
        return n2;
    }

    private final int internalDoFinalCFB(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n + n2;
        int n5 = this.blockSize;
        if (this.opMode == 2) {
            while (n < n4) {
                this.blockEncrypt(this.iv, 0, this.iv, 0);
                if (n + n5 > n4) {
                    n5 = n4 - n;
                }
                BlockCipher.blockXor(byArray, n, n5, this.iv, 0);
                System.arraycopy(this.iv, 0, byArray2, n3, n5);
                n += n5;
                n3 += n5;
            }
        } else {
            while (n < n4) {
                this.blockEncrypt(this.iv, 0, this.tmpBlk, 0);
                if (n + n5 > n4) {
                    n5 = n4 - n;
                }
                System.arraycopy(byArray, n, this.iv, 0, n5);
                BlockCipher.blockXor(this.iv, 0, n5, this.tmpBlk, 0);
                System.arraycopy(this.tmpBlk, 0, byArray2, n3, n5);
                n += n5;
                n3 += n5;
            }
        }
        return n2;
    }

    private final int internalDoFinalOFB(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n + n2;
        while (n < n4) {
            this.blockEncrypt(this.iv, 0, this.iv, 0);
            int n5 = n + this.blockSize <= n4 ? this.blockSize : n4 - n;
            for (int i = 0; i < n5; ++i) {
                byArray2[n3 + i] = byArray[n + i];
                int n6 = n3 + i;
                byArray2[n6] = (byte)(byArray2[n6] ^ this.iv[i]);
            }
            n += this.blockSize;
            n3 += this.blockSize;
        }
        return n2;
    }

    private final int internalDoFinalCTR(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (!this.ctrInit) {
            this.ctr = new byte[this.blockSize];
            System.arraycopy(this.iv, 0, this.ctr, 0, this.blockSize);
            this.ctrInit = true;
        }
        int n4 = n2 / this.blockSize;
        for (int i = 0; i < n4; ++i) {
            this.blockEncrypt(this.ctr, 0, this.tmpBlk, 0);
            System.arraycopy(byArray, n, byArray2, n3, this.blockSize);
            BlockCipher.blockXor(this.tmpBlk, 0, this.blockSize, byArray2, n3);
            n += this.blockSize;
            n3 += this.blockSize;
            BlockCipher.nboIncr(this.ctr);
        }
        return n2;
    }

    private static final void blockXor(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        while (n2 > 0) {
            int n4 = n3++;
            byArray2[n4] = (byte)(byArray2[n4] ^ byArray[n++]);
            --n2;
        }
    }

    protected static final int getIntMSBO(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    protected static final int getIntLSBO(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    protected static final void putIntMSBO(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24 & 0xFF);
        byArray[n2 + 1] = (byte)(n >>> 16 & 0xFF);
        byArray[n2 + 2] = (byte)(n >>> 8 & 0xFF);
        byArray[n2 + 3] = (byte)(n & 0xFF);
    }

    protected static final void putIntLSBO(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n & 0xFF);
        byArray[n2 + 1] = (byte)(n >>> 8 & 0xFF);
        byArray[n2 + 2] = (byte)(n >>> 16 & 0xFF);
        byArray[n2 + 3] = (byte)(n >>> 24 & 0xFF);
    }

    protected static final void nboIncr(byte[] byArray) {
        int n = byArray.length - 1;
        while (n >= 0) {
            int n2 = n--;
            byArray[n2] = (byte)(byArray[n2] + 1);
            if (0 == byArray[n2]) continue;
        }
    }

    protected int engineGetBlockSize() {
        return this.getBlockSize();
    }

    protected byte[] engineGetIV() {
        return this.iv;
    }

    protected int engineGetOutputSize(int n) {
        int n2 = this.getBlockSize();
        if (n % n2 > 0 || this.pkcs5Padding) {
            n += n2 - n % n2;
        }
        return n;
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException {
        this.initializeKey(((SecretKeySpec)key).getEncoded());
        this.blockSize = this.getBlockSize();
        if (algorithmParameterSpec == null) {
            algorithmParameterSpec = new IvParameterSpec(new byte[this.blockSize]);
        }
        this.opMode = n;
        this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
        this.tmpBlk = new byte[this.blockSize];
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInit(n, key, null, secureRandom);
    }

    protected void engineSetMode(String string) {
        if ("CBC".equalsIgnoreCase(string)) {
            this.feedbackMode = 1;
        } else if ("ECB".equalsIgnoreCase(string)) {
            this.feedbackMode = 0;
        } else if ("CFB".equalsIgnoreCase(string)) {
            this.feedbackMode = 2;
        } else if ("OFB".equalsIgnoreCase(string)) {
            this.feedbackMode = 3;
        } else if ("CTR".equalsIgnoreCase(string)) {
            this.feedbackMode = 4;
        }
    }

    protected void engineSetPadding(String string) {
        if ("PKCS5Padding".equalsIgnoreCase(string)) {
            this.pkcs5Padding = true;
        }
    }

    public abstract int getBlockSize();

    public abstract void initializeKey(byte[] var1) throws InvalidKeyException;

    public abstract void blockEncrypt(byte[] var1, int var2, byte[] var3, int var4);

    public abstract void blockDecrypt(byte[] var1, int var2, byte[] var3, int var4);
}

