/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.jca.security;

import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.NoSuchProviderException;
import com.mindbright.jca.security.Provider;
import com.mindbright.jca.security.ProviderLookup;
import com.mindbright.jca.security.SecureRandomSpi;
import com.mindbright.security.prng.BlumBlumShub;
import com.mindbright.util.RandomSeed;
import java.util.Random;

public class SecureRandom
extends Random {
    SecureRandomSpi engine;
    Provider provider;

    public SecureRandom() {
        this(new BlumBlumShub(), null);
    }

    public SecureRandom(byte[] byArray) {
        this(new BlumBlumShub(byArray), null);
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        super(0L);
        this.engine = secureRandomSpi;
        this.provider = provider;
    }

    public byte[] generateSeed(int n) {
        return this.engine.engineGenerateSeed(n);
    }

    public static SecureRandom getInstance(String string) throws NoSuchAlgorithmException {
        try {
            String string2 = ProviderLookup.findImplementingProvider("SecureRandom", string);
            return SecureRandom.getInstance(string, string2);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new Error("Error in SecureRandom: " + noSuchProviderException);
        }
    }

    public static SecureRandom getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        ProviderLookup providerLookup = ProviderLookup.getImplementation("SecureRandom", string, string2);
        return new SecureRandom((SecureRandomSpi)providerLookup.getImpl(), providerLookup.getProvider());
    }

    public Provider getProvider() {
        return this.provider;
    }

    public static byte[] getSeed(int n) {
        RandomSeed randomSeed = new RandomSeed("/dev/urandom", "/dev/urandom");
        return randomSeed.getBytesBlocking(n);
    }

    protected final int next(int n) {
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        this.nextBytes(byArray);
        for (int i = 0; i < n2; ++i) {
            n3 = (n3 << 8) + (byArray[i] & 0xFF);
        }
        return n3 >>> n2 * 8 - n;
    }

    public void nextBytes(byte[] byArray) {
        this.engine.engineNextBytes(byArray);
    }

    public void setSeed(byte[] byArray) {
        this.engine.engineSetSeed(byArray);
    }

    public void setSeed(long l) {
        if (l == 0L) {
            return;
        }
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        this.setSeed(byArray);
    }
}

