/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class MultiLineLabel
extends Canvas {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected String[] lines;
    protected int num_lines;
    protected int margin_width;
    protected int margin_height;
    protected int line_height;
    protected int line_ascent;
    protected int[] line_widths;
    protected int max_width;
    protected int alignment = 0;

    protected void newLabel(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        this.num_lines = stringTokenizer.countTokens();
        this.lines = new String[this.num_lines];
        this.line_widths = new int[this.num_lines];
        for (int i = 0; i < this.num_lines; ++i) {
            this.lines[i] = stringTokenizer.nextToken();
        }
    }

    protected void measure() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        this.line_height = fontMetrics.getHeight();
        this.line_ascent = fontMetrics.getAscent();
        this.max_width = 0;
        for (int i = 0; i < this.num_lines; ++i) {
            this.line_widths[i] = fontMetrics.stringWidth(this.lines[i]);
            if (this.line_widths[i] <= this.max_width) continue;
            this.max_width = this.line_widths[i];
        }
    }

    public MultiLineLabel(String string, int n, int n2, int n3) {
        this.newLabel(string);
        this.margin_width = n;
        this.margin_height = n2;
        this.alignment = n3;
    }

    public MultiLineLabel(String string, int n, int n2) {
        this(string, n, n2, 0);
    }

    public MultiLineLabel(String string, int n) {
        this(string, 10, 10, n);
    }

    public MultiLineLabel(String string) {
        this(string, 10, 10, 0);
    }

    public void setLabel(String string) {
        this.newLabel(string);
        this.measure();
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.measure();
        this.repaint();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setAlignment(int n) {
        this.alignment = n;
        this.repaint();
    }

    public void setMarginWidth(int n) {
        this.margin_width = n;
        this.repaint();
    }

    public void setMarginHeight(int n) {
        this.margin_height = n;
        this.repaint();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getMarginWidth() {
        return this.margin_width;
    }

    public int getMarginHeight() {
        return this.margin_height;
    }

    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.max_width + 2 * this.margin_width, this.num_lines * this.line_height + 2 * this.margin_height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.max_width, this.num_lines * this.line_height);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = this.line_ascent + (dimension.height - this.num_lines * this.line_height) / 2;
        int n2 = 0;
        while (n2 < this.num_lines) {
            int n3;
            switch (this.alignment) {
                case 0: {
                    n3 = this.margin_width;
                    break;
                }
                default: {
                    n3 = (dimension.width - this.line_widths[n2]) / 2;
                    break;
                }
                case 2: {
                    n3 = dimension.width - this.margin_width - this.line_widths[n2];
                }
            }
            graphics.drawString(this.lines[n2], n3, n);
            ++n2;
            n += this.line_height;
        }
    }
}

