/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.application;

import com.mindbright.application.MindTermApp;
import com.mindbright.application.MindTermModule;
import com.mindbright.gui.AWTConvenience;
import com.mindbright.terminal.GlobalClipboard;
import com.mindbright.terminal.TerminalFrameTitle;
import com.mindbright.terminal.TerminalMenuHandler;
import com.mindbright.terminal.TerminalMenuHandlerFull;
import com.mindbright.terminal.TerminalMenuListener;
import com.mindbright.terminal.TerminalWin;
import com.mindbright.terminal.TerminalWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ModuleBaseTerminal
extends WindowAdapter
implements MindTermModule,
Runnable,
TerminalMenuListener {
    protected MindTermApp mindterm;
    private Vector instances;

    public void init(MindTermApp mindTermApp) {
        this.mindterm = mindTermApp;
    }

    protected boolean haveMenus() {
        return Boolean.valueOf(this.mindterm.getProperty("havemenus"));
    }

    protected boolean useChaff() {
        return Boolean.valueOf(this.mindterm.getProperty("key-timing-noise"));
    }

    public void activate(MindTermApp mindTermApp) {
        if (this.instances == null) {
            this.instances = new Vector();
        }
        ModuleBaseTerminal moduleBaseTerminal = this.newInstance();
        this.instances.addElement(moduleBaseTerminal);
        moduleBaseTerminal.init(mindTermApp);
        Thread thread = new Thread((Runnable)moduleBaseTerminal, "Terminal_" + this.getClass());
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        Object object2;
        Frame frame = AWTConvenience.tryToAllocateJFrame();
        if (frame == null) {
            frame = this.haveMenus() ? AWTConvenience.newFrameWithMenuBar() : new Frame();
        } else if (this.haveMenus()) {
            try {
                object2 = Class.forName("com.mindbright.gui.SwingConvenience");
                object = ((Class)object2).getMethod("newJFrameWithMenuBar", new Class[0]);
                frame = (Frame)((Method)object).invoke(object2, (Object[])null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        object2 = new TerminalWin(frame, this.mindterm.getProperties());
        ((TerminalWin)object2).addAsEntropyGenerator(this.mindterm.getRandomSeed());
        AWTConvenience.getContentPane(frame).setLayout(new BorderLayout());
        AWTConvenience.getContentPane(frame).add((Component)((TerminalWin)object2).getPanelWithScrollbar(), "Center");
        object = new TerminalFrameTitle(frame, this.getTitle());
        ((TerminalFrameTitle)object).attach((TerminalWindow)object2);
        TerminalMenuHandler terminalMenuHandler = null;
        if (this.haveMenus()) {
            try {
                terminalMenuHandler = this.getTerminalMenuHandler(frame);
                terminalMenuHandler.setTitleName(this.mindterm.getAppName());
                terminalMenuHandler.addBasicMenus((TerminalWin)object2, frame);
                terminalMenuHandler.setTerminalMenuListener(this);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else {
            ((TerminalWin)object2).setClipboard(GlobalClipboard.getClipboardHandler());
        }
        frame.addWindowListener(this);
        frame.pack();
        ((Component)frame).setVisible(true);
        try {
            this.runTerminal(this.mindterm, (TerminalWindow)object2, frame, (TerminalFrameTitle)object);
        }
        finally {
            frame.dispose();
            if (this.haveMenus() && terminalMenuHandler != null) {
                GlobalClipboard.getClipboardHandler().removeMenuHandler(terminalMenuHandler);
            }
            this.instances = null;
            this.mindterm = null;
        }
    }

    protected TerminalMenuHandler getTerminalMenuHandler(Frame frame) {
        try {
            return TerminalMenuHandlerFull.getInstance(frame);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void connected(MindTermApp mindTermApp) {
    }

    public void disconnected(MindTermApp mindTermApp) {
        if (this.instances != null) {
            Enumeration enumeration = this.instances.elements();
            while (enumeration.hasMoreElements()) {
                ModuleBaseTerminal moduleBaseTerminal = (ModuleBaseTerminal)enumeration.nextElement();
                if (!moduleBaseTerminal.closeOnDisconnect()) continue;
                moduleBaseTerminal.doClose();
                this.instances.removeElement(moduleBaseTerminal);
            }
        }
    }

    public String description(MindTermApp mindTermApp) {
        return null;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.doClose();
    }

    public void close(TerminalMenuHandler terminalMenuHandler) {
        this.doClose();
    }

    public void update() {
    }

    protected abstract void runTerminal(MindTermApp var1, TerminalWindow var2, Frame var3, TerminalFrameTitle var4);

    protected abstract boolean closeOnDisconnect();

    protected abstract String getTitle();

    protected abstract void doClose();

    protected abstract ModuleBaseTerminal newInstance();

    public abstract /* synthetic */ boolean isAvailable(MindTermApp var1);
}

