<?php
require '../../main.inc.php';

require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT . '/product/class/html.formproduct.class.php';

require_once __DIR__ . '/class/productionrules.class.php';
require_once __DIR__ . '/class/ruleset.class.php';
require_once __DIR__ . '/class/RuleSetFlowBuilder.php';
require_once __DIR__ . '/class/RuleSetFlowRenderer.php';

$langs->load("admin");
$langs->load("productionrules@productionrules");

if (empty($user->rights->productionrules->read)) accessforbidden();

$form        = new Form($db);
$formproduct = new FormProduct($db);

$prodRules   = new ProdRules($db);
$ruleSetObj  = new ProdRuleSet($db);

$action = GETPOST('action', 'alpha');
$edit_rule_id = GETPOST('edit_rule_id', 'int');
$edit_rule = null;

$fg_ref = GETPOST('fg_ref', 'alpha');

// Step order list from setup
$steporder_list = getDolGlobalString('PRODUCTIONRULES_STEPORDER_LIST', '10,20,30,40,50');
$steporder_options = array();
foreach (explode(',', $steporder_list) as $val) {
    $val = trim($val);
    if ($val === '') continue;
    if (!is_numeric($val)) continue;
    $steporder_options[] = (int) $val;
}
if (empty($steporder_options)) $steporder_options = array(10,20,30,40,50);
$max_steporder = max($steporder_options);

// RuleSets for current user
$rulesets = $ruleSetObj->fetchAllForUser($user);

// current RuleSet
$current_ruleset_id = GETPOST('ruleset_id', 'int');
if (empty($current_ruleset_id) && !empty($rulesets)) {
    $ids = array_keys($rulesets);
    $current_ruleset_id = reset($ids);
}

/*
 * ACTIONS
 */

// CREATE NEW RULESET
if ($action === 'add_ruleset' && ($user->admin || !empty($user->rights->productionrules->config))) {
    $newref   = trim(GETPOST('new_ruleset_ref', 'alpha'));

    if (empty($newref)) {
        setEventMessage('Ref are mandatory for RuleSet', 'errors');
    } else {
        $resid = $ruleSetObj->createMinimal($user, $newref);
        if ($resid > 0) {
            setEventMessage('RuleSet created (ref: '.$ruleSetObj->ref.')', 'mesgs');
            $current_ruleset_id = $resid;
            $rulesets = $ruleSetObj->fetchAllForUser($user);
        } else {
            setEventMessage('Error creating RuleSet: '.$ruleSetObj->error, 'errors');
        }
    }
}

// DELETE RULESET (with all its rules)
if ($action === 'delete_ruleset' && !empty($current_ruleset_id) && !empty($user->rights->productionrules->write)) {
    $rid = (int) $current_ruleset_id;

    // delete rules of this ruleset for this user
    $sql  = "DELETE FROM ".MAIN_DB_PREFIX."prod_rules";
    $sql .= " WHERE fk_ruleset = ".$rid;
    $sql .= " AND fk_user_creat = ".(int) $user->id;
    $sql .= " AND entity IN (".getEntity('prod_rules').")";
    $db->query($sql);

    // delete ruleset itself
    $sql  = "DELETE FROM ".MAIN_DB_PREFIX."prod_ruleset";
    $sql .= " WHERE rowid = ".$rid;
    $sql .= " AND fk_user_creat = ".(int) $user->id;
    $sql .= " AND entity IN (".getEntity('prod_ruleset').")";

    if ($db->query($sql)) {
        setEventMessage('RuleSet deleted', 'mesgs');
        $current_ruleset_id = 0;
        $rulesets = $ruleSetObj->fetchAllForUser($user);
    } else {
        setEventMessage('Error deleting RuleSet: '.$db->lasterror(), 'errors');
    }
}

// DELETE SINGLE RULE (only own)
if ($action === 'del_rule' && !empty($user->rights->productionrules->write)) {
    $id = (int) GETPOST('id', 'int');
    if ($id > 0) {
        $sql  = "DELETE FROM ".MAIN_DB_PREFIX."prod_rules";
        $sql .= " WHERE rowid = ".$id;
        $sql .= " AND fk_user_creat = ".(int) $user->id;
        $sql .= " AND entity IN (".getEntity('prod_rules').")";
        $db->query($sql)
            ? setEventMessage("Rule deleted", 'mesgs')
            : setEventMessage("Error deleting rule: ".$db->lasterror(), 'errors');
    }
}

// UPDATE EXISTING RULE
if ($action === 'update_rule' && !empty($user->rights->productionrules->write)) {
    $rid = (int) GETPOST('rule_id', 'int');

    if ($rid > 0) {
        $from_ref  = trim(GETPOST('from_ref_edit', 'alpha'));
        $operation = trim(GETPOST('operation_edit', 'alpha'));
        $to_ref    = trim(GETPOST('to_ref_edit', 'alpha'));

        if (empty($from_ref) || empty($to_ref) || empty($operation)) {
            setEventMessage('from_ref, to_ref and operation are mandatory', 'errors');
        } else {
            $qty_per_from = (float) GETPOST('qty_per_from_edit', 'alpha');
            if ($qty_per_from <= 0) $qty_per_from = 1.0;

            $workstation = trim(GETPOST('workstation_edit', 'alpha'));
            $step_order  = (int) GETPOST('step_order_edit', 'int');
            if (empty($step_order)) $step_order = $steporder_options[0];

            $is_final = 0;
            $is_raw   = 0;
            $note     = trim(GETPOST('note_edit', 'alpha'));

            $sql  = "UPDATE ".MAIN_DB_PREFIX."prod_rules SET";
            $sql .= " from_ref = '".$db->escape($from_ref)."'";
            $sql .= ", operation = '".$db->escape($operation)."'";
            $sql .= ", to_ref = '".$db->escape($to_ref)."'";
            $sql .= ", qty_per_from = ".$qty_per_from;
            $sql .= ", workstation = '".$db->escape($workstation)."'";
            $sql .= ", step_order = ".$step_order;
            $sql .= ", is_final = ".$is_final;
            $sql .= ", is_raw = ".$is_raw;
            $sql .= ", note = '".$db->escape($note)."'";
            $sql .= " WHERE rowid = ".$rid;
            $sql .= " AND fk_user_creat = ".((int) $user->id);
            $sql .= " AND entity IN (".getEntity('prod_rules').")";

            if ($db->query($sql)) {
                setEventMessage('Rule updated', 'mesgs');
                $edit_rule_id = 0;
            } else {
                setEventMessage('Error updating rule: '.$db->lasterror(), 'errors');
            }
        }
    }
}

// ADD NEW RULE (to current RuleSet)
if ($action === 'add' && !empty($user->rights->productionrules->write)) {
    if (empty($current_ruleset_id)) {
        setEventMessage('Select or create a RuleSet first', 'errors');
    } else {
        $data = array(
            'from_ref'     => GETPOST('from_ref_new', 'alpha'),
            'operation'    => GETPOST('operation_new', 'alpha'),
            'to_ref'       => GETPOST('to_ref_new', 'alpha'),
            'qty_per_from' => (float) GETPOST('qty_per_from_new', 'alpha'),
            'workstation'  => GETPOST('workstation_new', 'alpha'),
            'step_order'   => (int) GETPOST('step_order_new', 'int'),
            'is_final'     => 0,
            'is_raw'       => 0,
            'note'         => GETPOST('note_new', 'alpha'),
            'fk_ruleset'   => $current_ruleset_id,
        );

        if (empty($data['from_ref']) || empty($data['to_ref']) || empty($data['operation'])) {
            setEventMessage("from_ref, to_ref and operation are mandatory", 'errors');
        } else {
            $res = $prodRules->createRule($user, $data);
            $res < 0
                ? setEventMessage("Error inserting rule: ".$prodRules->error, 'errors')
                : setEventMessage("Rule created", 'mesgs');
        }
    }
}

// GENERATE BOM
if ($action === 'generate_bom' && !empty($user->rights->productionrules->generate_bom)) {
    // BOM generujemy zawsze dla SF (RuleSet ref), materiał podaje użytkownik
    $raw_bom = GETPOST('bom_raw_ref', 'alpha');
    $qty     = (float) GETPOST('fg_qty', 'alpha');
    $job     = GETPOST('job_number', 'alpha');
    if ($qty <= 0) $qty = 1.0;

    // SF (produkt docelowy) bierzemy z aktualnie wybranego RuleSetu
    $sf_ref = '';
    if (!empty($current_ruleset_id) && !empty($rulesets[$current_ruleset_id]->ref)) {
        $sf_ref = $rulesets[$current_ruleset_id]->ref;
    }

    if (empty($current_ruleset_id) || empty($sf_ref)) {
        setEventMessage("Select RuleSet first", 'errors');
    } elseif (empty($raw_bom)) {
        setEventMessage("Material ref is required", 'errors');
    } else {
        $res = $prodRules->generateBomForRuleset($user, $current_ruleset_id, $sf_ref, $qty, $job, $raw_bom);
        $res > 0
            ? setEventMessage("BOM generated for ".$sf_ref." (BOM id ".$res.")", 'mesgs')
            : setEventMessage("Error generating BOM: ".$prodRules->error, 'errors');
    }
}


/*
 * LOAD RULES FOR CURRENT RULESET
 */
$filter = array();
if (!empty($current_ruleset_id)) $filter['fk_ruleset'] = $current_ruleset_id;
$rules = $prodRules->fetchAll($filter);
// Jeśli mamy edit_rule_id, pobierz tę regułę do formularza edycji
if (!empty($edit_rule_id)) {
    $sql = "SELECT * FROM ".MAIN_DB_PREFIX."prod_rules";
    $sql .= " WHERE rowid = ".((int) $edit_rule_id);
    $sql .= " AND fk_user_creat = ".((int) $user->id);
    $sql .= " AND entity IN (".getEntity('prod_rules').")";
    $res = $db->query($sql);
    if ($res && $db->num_rows($res) > 0) {
        $edit_rule = $db->fetch_object($res);
    } else {
        $edit_rule_id = 0;
    }
}


/*
 * VIEW
 */

llxHeader('', 'Production rules');

print load_fiche_titre('Production rules module', '', 'generic');

// Główny CSS modułu
print '<link rel="stylesheet" type="text/css" href="'.dol_buildpath('/custom/productionrules/css/productionrules.css', 1).'">';
// Flow (desktop)
print '<link rel="stylesheet" type="text/css" href="'.dol_buildpath('/custom/productionrules/css/productionrules_flow.css', 1).'">';
// Flow mobile override
print '<link rel="stylesheet" type="text/css" href="'.dol_buildpath('/custom/productionrules/css/productionrules_flow_mobile.css', 1).'">';

print '<div id="productionrules-page">';

// JS config dla modułu – musi być PRZED załadowaniem zewnętrznych plików
print '<script type="text/javascript">
window.PR_CONFIG = {
    urls: {
        getProducts: "'.dol_buildpath('/custom/productionrules/ajax/getproducts.php', 1).'",
        getOperations: "'.dol_buildpath('/custom/productionrules/ajax/getoperations.php', 1).'",
        getWorkstations: "'.dol_buildpath('/custom/productionrules/ajax/getworkstations.php', 1).'",
        addStepOrder: "'.dol_buildpath('/custom/productionrules/ajax/add_steporder.php', 1).'"
    },
    maxStepOrder: '.((int) $max_steporder).',
    isAdmin: '.($user->admin ? 'true' : 'false').'
};
</script>';

print '<script type="text/javascript" src="'.dol_buildpath('/custom/productionrules/js/productionrules_flow.js',1).'"></script>';
print '<script type="text/javascript" src="'.dol_buildpath('/custom/productionrules/js/productionrules_ui.js',1).'"></script>';



// GÓRNY BLOK: RuleSet / New / RAW / BOM (lewo) + Add new rule (prawo)
print '<div class="pr-container">';

// LEWA STRONA
print '<div class="pr-left">';

// RULE SET SELECTOR
print '<form method="GET" action="'.$_SERVER['PHP_SELF'].'">';
print '<input type="hidden" name="token" value="'.newToken().'">';
print 'Rule set: ';
print '<select name="ruleset_id" class="flat" style="min-width:220px;">';
if (empty($rulesets)) {
    print '<option value="0">(no rulesets yet)</option>';
} else {
    foreach ($rulesets as $id => $rs) {
        $sel = ($id == $current_ruleset_id ? ' selected' : '');
        print '<option value="'.$id.'"'.$sel.'>'.dol_escape_htmltag($rs->ref).'</option>';
    }
}

print '</select> ';
print '<input type="submit" class="button" value="SELECT" style="position:relative; top:3px;">';
print '</form>';

// BLOK FORMÓW POD RULESETEM – jedno pod drugim
print '<div style="margin-top:8px;">';

// NEW RULESET
if (!empty($user->rights->productionrules->write)) {
    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'" style="margin-bottom:4px;">';
    print '<input type="hidden" name="token" value="'.newToken().'">';
    print '<input type="hidden" name="action" value="add_ruleset">';
    print '<div class="pr-row">';
    print '<div class="pr-row-main">';
    print 'New RuleSet ref: <input type="text" id="new_ruleset_ref" name="new_ruleset_ref" size="8"> ';
    print '</div>';
    print '<div class="pr-row-btn">';
    print '<input type="submit" class="button" value="ADD RULESET">';
    print '</div>';
    print '</div>';
    print '</form>';
}

print '<br><br><br>';
// GENERATE BOM – zaraz pod RAW
if (!empty($user->rights->productionrules->generate_bom)) {
    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'" style="margin-bottom:4px;">';
    print '<input type="hidden" name="token" value="'.newToken().'">';
    print '<input type="hidden" name="action" value="generate_bom">';
    if (!empty($current_ruleset_id)) {
        print '<input type="hidden" name="ruleset_id" value="'.(int)$current_ruleset_id.'">';
    }
//    print '<div class="pr-row">';
//    print '<div class="pr-row-main">';
//    print 'Job: <input type="text" name="job_number" size="8" value="'.dol_escape_htmltag(GETPOST('job_number','alpha')).'"> ';
//    print 'Qty: <input type="text" name="fg_qty" size="4" value="1.0">';
//    print '</div>';
//    print '<div class="pr-row-btn">';
//    print '<input type="submit" class="button" value="GENERATE BOM">';
    print '<div class="pr-row">';
    print '<div class="pr-row-main">';
    print 'Product (SF): '.dol_escape_htmltag(!empty($rulesets[$current_ruleset_id]->ref) ? $rulesets[$current_ruleset_id]->ref : '').' ';
    print 'Material: <input type="text" id="bom_raw_ref" name="bom_raw_ref" size="18" placeholder="np. 62133x5, 61111x5" value="'.dol_escape_htmltag(GETPOST('bom_raw_ref','alpha')).'"> ';
    print 'Job: <input type="text" name="job_number" size="8" value="'.dol_escape_htmltag(GETPOST('job_number','alpha')).'"> ';
    print 'Qty: <input type="text" name="fg_qty" size="4" value="1.0">';
    print '</div>';
    print '<div class="pr-row-btn">';
    print '<input type="submit" class="button" value="GENERATE BOM">';
    print '</div>';
    print '</div>';
    print '</form>';
}

// DELETE RULESET
if (!empty($current_ruleset_id) && !empty($user->rights->productionrules->write)) {
    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'" style="margin-bottom:0;">';
    print '<input type="hidden" name="token" value="'.newToken().'">';
    print '<input type="hidden" name="action" value="delete_ruleset">';
    print '<input type="hidden" name="ruleset_id" value="'.(int)$current_ruleset_id.'">';
    print '<div class="pr-row">';
    print '<div class="pr-row-main">&nbsp;</div>';
    print '<div class="pr-row-btn">';
    print '<input type="submit" class="buttonDelete" value="DELETE THIS RULESET" ';
    print 'onclick="return confirm(\'Delete this ruleset and all its rules?\');">';
    print '</div>';
    print '</div>';
    print '</form>';
}

print '</div>'; // blok form
print '<br><br>';
/*
 * HORIZONTAL FLOW: tekst RAW → OPERACJE (top line),
 * a pod spodem kolumna z ostatnią operacją + wszystkimi FG
 */
// HORIZONTAL FLOW – wykorzystujemy nowy builder + renderer
if (!empty($current_ruleset_id)) {
    print '<div class="pr-flow-block">';
    $flow = RuleSetFlowBuilder::build($db, $current_ruleset_id);
    RuleSetFlowRenderer::render($flow);
    print '</div>';
}

print '</div>'; // .pr-left


// PRAWA STRONA – ADD / EDIT RULE
if (!empty($user->rights->productionrules->write)) {
    print '<div class="pr-right">';

    $is_edit = !empty($edit_rule_id) && is_object($edit_rule);

    if ($is_edit) {
        print load_fiche_titre('Edit rule', '', '', 0);
        print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        print '<input type="hidden" name="action" value="update_rule">';
        print '<input type="hidden" name="rule_id" value="'.(int)$edit_rule_id.'">';
    } else {
        print load_fiche_titre('Add new rule', '', '', 0);
        print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        print '<input type="hidden" name="action" value="add">';
    }

    if (!empty($current_ruleset_id)) {
        print '<input type="hidden" name="ruleset_id" value="'.(int)$current_ruleset_id.'">';
    }

    $from_val  = ($is_edit ? $edit_rule->from_ref  : '');
    $op_val    = ($is_edit ? $edit_rule->operation : '');
    $to_val    = ($is_edit ? $edit_rule->to_ref    : '');
    $qty_val   = ($is_edit ? rtrim(rtrim((string) $edit_rule->qty_per_from, '0'), '.') : '1');
    $ws_val    = ($is_edit ? $edit_rule->workstation  : '');
    $step_val  = ($is_edit ? (int)$edit_rule->step_order : 0);
    $is_final_checked = ($is_edit && !empty($edit_rule->is_final)) ? ' checked' : '';
    $is_raw_checked   = ($is_edit && !empty($edit_rule->is_raw)) ? ' checked' : '';
    $note_val  = ($is_edit ? $edit_rule->note : '');

    print '<table class="noborder centpercent pr-add-rule-table">';
    print '<tr><td>'.$form->textwithpicto(
        'From ref',
        'Start typing product code, e.g. FG2001-00, SF2001-00, 62011. Autocomplete searches all products.'
    ).'</td>';
    print '<td><input type="text" id="from_ref" name="'.($is_edit ? 'from_ref_edit' : 'from_ref_new').'" value="'.dol_escape_htmltag($from_val).'"></td></tr>';

    print '<tr><td>'.$form->textwithpicto(
        'Operation',
        'Start typing: FORMING, TRIMMING, WASH, PACKING... Autocomplete uses Workstations labels.'
    ).'</td>';
    print '<td><input type="text" id="operation" name="'.($is_edit ? 'operation_edit' : 'operation_new').'" value="'.dol_escape_htmltag($op_val).'"></td></tr>';

    print '<tr><td>To ref</td><td><input type="text" id="to_ref" name="'.($is_edit ? 'to_ref_edit' : 'to_ref_new').'" value="'.dol_escape_htmltag($to_val).'"></td></tr>';
    print '<tr><td>Qty per from</td><td><input type="text" name="'.($is_edit ? 'qty_per_from_edit' : 'qty_per_from_new').'" value="'.dol_escape_htmltag($qty_val).'"></td></tr>';

    print '<tr><td>'.$form->textwithpicto(
        'Workstation',
        'Type FM2, FM3, LASER1, PACKING… Autocomplete uses workstation ref.'
    ).'</td>';
    print '<td><input type="text" id="workstation" name="'.($is_edit ? 'workstation_edit' : 'workstation_new').'" value="'.dol_escape_htmltag($ws_val).'"></td></tr>';

    // Step order + Add
    print '<tr><td>Step order</td><td>';
    print '<select name="'.($is_edit ? 'step_order_edit' : 'step_order_new').'" class="flat">';
    $current_step = ($is_edit ? (int) $step_val : (int) GETPOST('step_order_new', 'int'));
    if (empty($current_step)) $current_step = $steporder_options[0];
    foreach ($steporder_options as $opt) {
        $sel = ($opt == $current_step ? ' selected' : '');
        print '<option value="'.$opt.'"'.$sel.'>'.$opt.'</option>';
    }
    print '</select>';
    if ($user->admin || !empty($user->rights->productionrules->config)) {
        print ' <a href="#" id="addStepLink" style="font-size:12px; margin-left:8px;">+ Add</a>';
    }
    print '</td></tr>';

    print '<tr><td>Note</td><td><input type="text" name="'.($is_edit ? 'note_edit' : 'note_new').'" size="40" value="'.dol_escape_htmltag($note_val).'"></td></tr>';
    print '</table>';

    print '<div class="center" style="margin-top:8px;">';
    if ($is_edit) {
        print '<input type="submit" class="button" value="UPDATE RULE"> ';
        print '<input type="button" class="button" value="CANCEL" onclick="window.location.href=\''.$_SERVER['PHP_SELF'].'?ruleset_id='.(int)$current_ruleset_id.'\'">';
    } else {
        print '<input type="submit" class="button" value="SAVE RULE">';
    }

    print '</div>';

    print '</form>';
    print '</div>'; // .pr-right
}

print '</div>'; // .pr-container

print '<br>';
print '</div>';  // zamknięcie #productionrules-page
llxFooter();
$db->close();