// JS odpowiedzialny TYLKO za flow (tooltipy dla .pr-flow-node)
$(function() {
    // Jeden globalny tooltip dla flow
    var $tip = $('#pr-flow-tooltip');
    if ($tip.length === 0) {
        $tip = $('<div id="pr-flow-tooltip"></div>')
            .css({
                position: 'fixed',
                zIndex: 3000,
                background: '#111',
                color: '#eee',
                border: '1px solid #555',
                padding: '6px 10px',
                borderRadius: '4px',
                fontSize: '13px',
                lineHeight: '1.4',
                maxWidth: '500px',
                display: 'none',
                pointerEvents: 'none',
                boxShadow: '0 2px 6px rgba(0,0,0,0.6)'
            })
            .appendTo('body');
    }

    function positionTip(e) {
        var padding = 12;

        var winW = $(window).width();
        var winH = $(window).height();

        var tipW = $tip.outerWidth();
        var tipH = $tip.outerHeight();

        // domyślnie: pod i na prawo od kursora
        var x = e.clientX + padding;
        var y = e.clientY + padding;

        // jeśli za bardzo w prawo → przesuń w lewo
        if (x + tipW > winW - padding) {
            x = winW - tipW - padding;
        }

        // jeśli nie mieści się na dole → pokaż nad kursorem
        if (y + tipH > winH - padding) {
            y = e.clientY - tipH - padding;
        }

        if (y < padding) y = padding;

        $tip.css({ left: x + 'px', top: y + 'px' });
    }

    // Pokazanie tooltipa
    $(document).on('mouseenter', '.pr-flow-node', function(e){
        // OBSŁUGUJEMY OBA PRZYPADKI:
        // - data-tooltip-html (stare)
        // - data-tooltip (nowsze)
        var html = $(this).attr('data-tooltip-html') || $(this).attr('data-tooltip');
        if (!html) return;

        $tip.html(html).show();
        positionTip(e);
    });

    // Ruch myszy
    $(document).on('mousemove', '.pr-flow-node', function(e){
        if (!$tip.is(':visible')) return;
        positionTip(e);
    });

    // Ukrycie tooltipa
    $(document).on('mouseleave', '.pr-flow-node', function(){
        $tip.hide();
    });
    // ------------------------------------------------------------------
    // Left click = edit rule
    $(document).on('click', '.pr-flow-node', function (e) {
        // tylko LPM
        if (e.which && e.which !== 1) {
            return;
        }

        var $node  = $(this);
        var ruleId = $node.data('rule-id');

        if (!ruleId) {
            return; // brak powiązanej reguły
        }

        // jeśli user zaznacza tekst – nie odpalaj edycji
        if (window.getSelection && window.getSelection().toString()) {
            return;
        }

        var url = new URL(window.location.href);

        // akcja edycji - parametr edit_rule_id
        url.searchParams.set('edit_rule_id', ruleId);

        // zachowaj ruleset_id (z URL albo z selecta)
        if (!url.searchParams.get('ruleset_id')) {
            var rs = $('select[name="ruleset_id"]').val();
            if (rs) {
                url.searchParams.set('ruleset_id', rs);
            }
        }

        window.location.href = url.toString();
    });

    // Right click (PPM) = delete rule
    $(document).on('contextmenu', '.pr-flow-node', function (e) {
        e.preventDefault();

        var $node  = $(this);
        var ruleId = $node.data('rule-id');

        if (!ruleId) {
            return;
        }

        // Tekst node'a bez komentarza w nawiasie
        var clone = $node.clone();
        clone.find('.pr-node-comment').remove();
        var refText = $.trim(clone.text());

        var msg = 'Delete rule for ' + (refText || ('ID ' + ruleId)) + '?';
        if (!window.confirm(msg)) {
            return;
        }

        var url = new URL(window.location.href);

        url.searchParams.set('action', 'del_rule');
        url.searchParams.set('id', ruleId);

        // zachowanie ruleset_id
        if (!url.searchParams.get('ruleset_id')) {
            var rs = $('select[name="ruleset_id"]').val();
            if (rs) {
                url.searchParams.set('ruleset_id', rs);
            }
        }

        var token = $('input[name="token"]').first().val();
        if (token) {
            url.searchParams.set('token', token);
        }

        window.location.href = url.toString();
    });

    // ------------------------------------------------------------------
    // Show comment = pokaż/ukryj span.pr-node-comment
    // ------------------------------------------------------------------
    $(document).on('change', '#pr-show-comments', function () {
        if (this.checked) {
            $('.pr-node-comment').show();
        } else {
            $('.pr-node-comment').hide();
        }
    });
});