<?php

// Ajax: add new step_order value to module constant

// Uwaga na ścieżkę: z ajax/ -> ../ (productionrules) -> ../ (custom) -> ../ (htdocs)
require '../../../main.inc.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';   // <-- DODANE

// Tylko upewniamy się, że user jest zalogowany – bez 403
if (empty($user->id) || (!$user->admin && empty($user->rights->productionrules->config))) {
    header('Content-Type: application/json');
    echo json_encode(array('status' => 'error', 'msg' => 'Access denied'));
    exit;
}

header('Content-Type: application/json');

$val = (int) GETPOST('val','int');
if ($val <= 0) {
    echo json_encode(array('status'=>'error','msg'=>'Invalid value'));
    exit;
}

// Pobierz aktualną listę
$steporder_list = getDolGlobalString('PRODUCTIONRULES_STEPORDER_LIST', '10,20,30,40,50');

$arr = array();
foreach (explode(',', $steporder_list) as $v) {
    $v = trim($v);
    if ($v === '') continue;
    if (!is_numeric($v)) continue;
    $arr[] = (int) $v;
}

// Dodaj, jeśli nie istnieje
if (!in_array($val, $arr)) {
    $arr[] = $val;
    sort($arr, SORT_NUMERIC);
}

$newlist = implode(',', $arr);

// Zapis stałej
dolibarr_set_const(
    $db,
    'PRODUCTIONRULES_STEPORDER_LIST',
    $newlist,
    'chaine',
    0,
    '',
    $conf->entity
);

echo json_encode(array('status'=>'ok','list'=>$newlist));
exit;
