// Ogólny JS modułu – autocomplete, +Add step, itd.
// WYMAGA: window.PR_CONFIG zdefiniowanego w productionrules_rules.php
$(function() {

    function attachProductAutocomplete(fieldId) {
        $("#" + fieldId).autocomplete({
            source: function(request, response) {
                $.ajax({
                    url: PR_CONFIG.urls.getProducts,
                    data: {
                        term: request.term,
                        field: fieldId
                    },
                    dataType: "json",
                    success: function(data){
                        response(data);
                    }
                });
            },
            minLength: 2,
            delay: 150
        });
    }

    function attachOperationAutocomplete(fieldId) {
        $("#" + fieldId).autocomplete({
            source: function(request, response) {
                $.ajax({
                    url: PR_CONFIG.urls.getOperations,
                    data: { term: request.term },
                    dataType: "json",
                    success: function(data){
                        response(data);
                    }
                });
            },
            minLength: 1,
            delay: 100
        });
    }

    function attachWorkstationAutocomplete(fieldId) {
        $("#" + fieldId).autocomplete({
            source: function(request, response) {
                $.ajax({
                    url: PR_CONFIG.urls.getWorkstations,
                    data: { term: request.term },
                    dataType: "json",
                    success: function(data){
                        response(data);
                    }
                });
            },
            minLength: 1,
            delay: 100
        });
    }

    // Inicjalizacja autocomplete
    attachProductAutocomplete("from_ref");
    attachProductAutocomplete("to_ref");
    attachProductAutocomplete("fg_ref");
    attachProductAutocomplete("new_ruleset_ref");
    attachProductAutocomplete("bom_raw_ref");
    
    attachOperationAutocomplete("operation");
    attachWorkstationAutocomplete("workstation");

    // ADMIN ONLY: +Add step order
    if (PR_CONFIG.isAdmin) {
        $("#addStepLink").click(function(e) {
            e.preventDefault();

            //var current = parseInt($("select[name='step_order_new']").val(), 10) || PR_CONFIG.maxStepOrder;
            var current = PR_CONFIG.maxStepOrder;
            var suggested = current + 10;

            var val = window.prompt(
                "Add new step order value (integer).\n" +
                "Current max: " + PR_CONFIG.maxStepOrder + "\n" +
                "Suggestion: " + suggested,
                suggested
            );

            if (val === null) return; // cancelled

            val = parseInt(val, 10);
            if (isNaN(val) || val <= 0) {
                alert("Invalid value");
                return;
            }

            $.ajax({
                url: PR_CONFIG.urls.addStepOrder,
                method: "POST",
                dataType: "json",
                data: {
                    value: val
                }
            }).done(function(resp) {
                if (!resp || !resp.success) {
                    alert("Ajax error: " + (resp && resp.message ? resp.message : "unknown"));
                    return;
                }

                // Zaktualizuj globalny max
                PR_CONFIG.maxStepOrder = resp.max_steporder;

                // Dodaj nową opcję do selecta (jeśli jej nie ma)
                var $sel = $("select[name='step_order_new']");
                if ($sel.find("option[value='" + val + "']").length === 0) {
                    $sel.append('<option value="'+val+'">'+val+'</option>');
                }
                $sel.val(val);
            }).fail(function(xhr) {
                alert("Ajax error: " + xhr.statusText);
            });
        });
    }

});
