<?php
/**
 * Planning Timeline - Read-only visual timeline view
 * Displays jobs as blocks on a horizontal timeline per machine.
 */

require '../../main.inc.php';

if (empty($user->rights->planning) || empty($user->rights->planning->read)) {
    accessforbidden();
}

$langs->loadLangs(array('main', 'mrp', 'products'));

// Get parameters
$group = GETPOST('group', 'aZ09');
if (empty($group) || !in_array($group, array('forming', 'trimming'))) {
    $group = 'forming';
}
$days = (int) GETPOST('days', 'int');
if ($days < 1 || $days > 60) {
    $days = 14;
}
$ganttMode = (int) GETPOST('gantt', 'int');
if ($ganttMode < 0 || $ganttMode > 1) {
    $ganttMode = 1;
}

// Check permissions
$canAddJob = !empty($user->rights->planning->addjob);
$canEditJob = !empty($user->rights->planning->editjob);
$canDeleteJob = !empty($user->rights->planning->deletejob);

// Load workstations if user can add or edit jobs
$workstations = array();
if ($canAddJob || $canEditJob) {
    $wsTables = array(
        MAIN_DB_PREFIX . 'workstation_workstation',
        MAIN_DB_PREFIX . 'workstation',
        MAIN_DB_PREFIX . 'mrp_workstation',
    );
    foreach ($wsTables as $tbl) {
        $sqlChk = "SELECT 1 FROM information_schema.TABLES
                   WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = '" . $db->escape($tbl) . "'";
        $resChk = $db->query($sqlChk);
        if ($resChk && $db->fetch_object($resChk)) {
            $sqlWs = "SELECT rowid, ref, label FROM " . $tbl . " ORDER BY ref ASC";
            $resWs = $db->query($sqlWs);
            if ($resWs) {
                while ($ws = $db->fetch_object($resWs)) {
                    $workstations[] = array(
                        'id' => (int) $ws->rowid,
                        'ref' => $ws->ref,
                        'label' => $ws->label ? $ws->label : $ws->ref
                    );
                }
            }
            break;
        }
    }
}

// Products now loaded via AJAX autocomplete (search_products.php)
// No preload needed

$morejs = array('/custom/planning/js/timeline.js');
$morecss = array('/custom/planning/css/timeline.css');

llxHeader('', 'Planning Timeline', '', '', 0, 0, $morejs, $morecss);

$tlEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/timeline_data.php';
$addJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/add_job.php';
$updateJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/update_job.php';
$deleteJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/delete_job.php';
$searchProductsEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/search_products.php';
print '<div class="pl-timeline-page" id="plTimelinePage"';
print ' data-group="' . dol_escape_htmltag($group) . '"';
print ' data-days="' . (int)$days . '"';
print ' data-endpoint="' . dol_escape_htmltag($tlEndpoint) . '"';
print ' data-addjob-endpoint="' . dol_escape_htmltag($addJobEndpoint) . '"';
print ' data-updatejob-endpoint="' . dol_escape_htmltag($updateJobEndpoint) . '"';
print ' data-deletejob-endpoint="' . dol_escape_htmltag($deleteJobEndpoint) . '"';
print ' data-search-products-endpoint="' . dol_escape_htmltag($searchProductsEndpoint) . '"';
print ' data-token="' . newToken() . '"';
print ' data-can-addjob="' . ($canAddJob ? '1' : '0') . '"';
print ' data-can-editjob="' . ($canEditJob ? '1' : '0') . '"';
print ' data-can-deletejob="' . ($canDeleteJob ? '1' : '0') . '"';
print ' data-workstations="' . dol_escape_htmltag(json_encode($workstations)) . '"';
print ' data-gantt-mode="' . (int)$ganttMode . '"';
print '>';

// Products loaded via AJAX autocomplete
print "<!-- Products loaded via AJAX autocomplete (search_products.php) -->\n";

// Title and tabs
print '<div class="pl-timeline-header">';
print '<h1 class="pl-timeline-title">Planning Timeline</h1>';

print '<div class="pl-timeline-tabs">';
$formingClass = ($group === 'forming') ? 'pl-tab-active' : '';
$trimmingClass = ($group === 'trimming') ? 'pl-tab-active' : '';
print '<a href="' . $_SERVER['PHP_SELF'] . '?group=forming&days=' . $days . '" class="pl-tab ' . $formingClass . '">Forming</a>';
print '<a href="' . $_SERVER['PHP_SELF'] . '?group=trimming&days=' . $days . '" class="pl-tab ' . $trimmingClass . '">Trimming</a>';
print '</div>';

print '<div class="pl-timeline-controls">';
print '<button type="button" class="pl-btn-add-job" id="plBtnPastToggle">Past</button>';
print '<label>Days: ';
print '<select id="plTimelineDays" onchange="plTimelineChangeDays(this.value)">';
foreach (array(7, 14, 21, 30) as $d) {
    $sel = ($days === $d) ? ' selected' : '';
    print '<option value="' . $d . '"' . $sel . '>' . $d . '</option>';
}
print '</select>';
print '</label>';
print '</div>';

print '</div>'; // header

// Main content: two-panel layout
print '<div class="pl-timeline-container">';

// Left panel: Job card (details of selected job)
print '<div class="pl-timeline-left" id="plJobCardPanel">';
print '<div class="pl-job-card" id="plJobCard">';
print '<div class="pl-job-card-placeholder">Select a job to view details</div>';
print '</div>';
print '</div>';

// Right panel: Timeline grid
print '<div class="pl-timeline-right" id="plTimelinePanel">';
print '<div class="pl-timeline-grid" id="plTimelineGrid">';
print '<div class="pl-timeline-loading">Loading timeline...</div>';
print '</div>';
print '</div>';

print '</div>'; // container

print '</div>'; // page

// Add Job Modal (only if user has permission)
if ($canAddJob) {
    print '<div class="pl-modal-overlay" id="plAddJobModal">';
    print '<div class="pl-modal">';
    print '<div class="pl-modal-header">';
    print '<h2 class="pl-modal-title">Add Job</h2>';
    print '<button type="button" class="pl-modal-close" id="plModalClose">&times;</button>';
    print '</div>';
    print '<form id="plAddJobForm">';
    print '<div class="pl-modal-body">';

    // Workstation (read-only) - format: "Workstation: Forming FM7" or "Workstation: Trimming TM3"
    print '<div class="pl-form-group">';
    print '<div id="plAddJobWorkstationDisplay" class="pl-form-readonly">-</div>';
    print '<input type="hidden" name="fk_workstation" id="plAddJobWorkstationHidden" value="">';
    print '<input type="hidden" name="group_code" id="plAddJobGroupHidden" value="">';
    print '</div>';

    // Product (FG) - Autocomplete
    print '<div class="pl-form-group">';
    print '<label class="pl-form-label">Product (FG) Search</label>';
    print '<div class="pl-autocomplete-container">';
    print '<input type="text" id="plAddJobProductSearch" class="pl-form-input" placeholder="Search by ref or name...">';
    print '<ul class="pl-autocomplete-results" id="plAddJobProductResults"></ul>';
    print '</div>';
    print '<input type="hidden" name="fk_product" id="plAddJobProduct" value="">';
    print '</div>';

    // Works Order No
    print '<div class="pl-form-group">';
    print '<label class="pl-form-label">Works Order No</label>';
    print '<input type="text" name="works_order_no" id="plAddJobWO" class="pl-form-input" placeholder="e.g. WO-12345">';
    print '</div>';

    // Quantity
    print '<div class="pl-form-group">';
    print '<label class="pl-form-label">Quantity</label>';
    print '<input type="number" name="qty" id="plAddJobQty" class="pl-form-input" step="0.01" min="0.01" value="1.00">';
    print '</div>';

    // Start datetime
    print '<div class="pl-form-group">';
    print '<label class="pl-form-label">Start</label>';
    print '<input type="datetime-local" name="date_start" id="plAddJobStart" class="pl-form-input">';
    print '</div>';

    // Notes
    print '<div class="pl-form-group">';
    print '<label class="pl-form-label">Notes</label>';
    print '<textarea name="notes" id="plAddJobNotes" class="pl-form-input" rows="2"></textarea>';
    print '</div>';

    // Error message area
    print '<div class="pl-form-error" id="plAddJobError"></div>';

    print '</div>'; // modal-body
    print '<div class="pl-modal-footer">';
    print '<button type="button" class="pl-btn pl-btn-cancel" id="plModalCancel">Cancel</button>';
    print '<button type="submit" class="pl-btn pl-btn-submit" id="plModalSubmit">Add Job</button>';
    print '</div>';
    print '</form>';
    print '</div>'; // modal
    print '</div>'; // overlay
}

llxFooter();
