function plSetBoardTheme(){
  try{
    var fs = !!(document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement);
    document.body.classList.toggle('pl-board-dark', fs);
    document.body.classList.toggle('pl-board-light', !fs);
  }catch(e){}
}

(function () {
  'use strict';

  function $(id) { return document.getElementById(id); }

  function isFullscreen() {
    return !!(document.fullscreenElement ||
              document.webkitFullscreenElement ||
              document.mozFullScreenElement ||
              document.msFullscreenElement);
  }

  function requestFullscreen(el) {
    const fn = el.requestFullscreen ||
               el.webkitRequestFullscreen ||
               el.mozRequestFullScreen ||
               el.msRequestFullscreen;
    if (fn) fn.call(el);
  }

  function exitFullscreen() {
    const fn = document.exitFullscreen ||
               document.webkitExitFullscreen ||
               document.mozCancelFullScreen ||
               document.msExitFullscreen;
    if (fn) fn.call(document);
  }

  function initTooltips() {
    // Re-init Dolibarr AJAX tooltips (classforajaxtooltip) after DOM replacement.
    // Without this, links keep the placeholder title="tocomplete" after auto-refresh.
    try {
      if (typeof window.dol_init_ajaxtooltip === 'function') window.dol_init_ajaxtooltip();
      if (typeof window.initAjaxToolTip === 'function') window.initAjaxToolTip();
      if (typeof window.initAjaxTooltips === 'function') window.initAjaxTooltips();
    } catch (e) {}

    // 1) TipTip for regular (non-AJAX) tooltips only.
    // IMPORTANT: Do NOT bind tipTip on .classforajaxtooltip here.
    // Dolibarr uses its own AJAX loader for those links; binding tipTip directly
    // makes the placeholder title="tocomplete" show up instead of the rich tooltip.
    try {
      if (window.jQuery && jQuery.fn && jQuery.fn.tipTip) {
        jQuery('.tiptip_holder').remove();
        jQuery('.classfortooltip, .classfortooltipfixed, .pl-job-tooltip').tipTip({
          maxWidth: 'auto',
          edgeOffset: 8,
          delay: 50,
          keepAlive: false
        });
      }
    } catch (e) {}



    // 2) Last resort fallback: lightweight HTML tooltip.
    // This is ONLY used if TipTip isn't available on the page after AJAX refresh.
    try {
      const nodes = document.querySelectorAll('.classfortooltip, .classfortooltipfixed, .pl-job-tooltip');
      if (!nodes || !nodes.length) return;

      // Create tooltip container once
      let tip = document.getElementById('plHtmlTooltip');
      if (!tip) {
        tip = document.createElement('div');
        tip.id = 'plHtmlTooltip';
        tip.style.position = 'fixed';
        tip.style.zIndex = '10080';
        tip.style.display = 'none';
        tip.style.maxWidth = '520px';
        tip.style.padding = '8px 10px';
        tip.style.borderRadius = '8px';
        tip.style.boxShadow = '0 6px 20px rgba(0,0,0,.25)';
        tip.style.fontSize = '12px';
        tip.style.lineHeight = '1.25';
        tip.style.pointerEvents = 'none';
        // Theme-aware background
        tip.style.background = 'rgba(30,30,30,.92)';
        tip.style.color = '#fff';
//        document.body.appendChild(tip);
        const host = document.fullscreenElement || document.webkitFullscreenElement || document.body;
        host.appendChild(tip);
      }

      function getHtml(el) {
        return el.getAttribute('data-pl-tt')
          || el.getAttribute('data-original-title')
          || el.getAttribute('title')
          || '';
      }

      function storeAndDisableNative(el) {
        if (el.getAttribute('data-pl-tt')) return;
        const html = getHtml(el);
        if (!html) return;
        el.setAttribute('data-pl-tt', html);
        // Prevent native browser tooltip
        if (el.hasAttribute('title')) el.removeAttribute('title');
      }

      function showTip(el, ev) {
        const html = getHtml(el);
        if (!html) return;
        tip.innerHTML = html;
        tip.style.display = 'block';
        moveTip(ev);
      }

      function hideTip() {
        tip.style.display = 'none';
      }

      function moveTip(ev) {
        const pad = 12;
        const vw = window.innerWidth;
        const vh = window.innerHeight;
        const rect = tip.getBoundingClientRect();
        let x = ev.clientX + pad;
        let y = ev.clientY + pad;
        if (x + rect.width + pad > vw) x = Math.max(pad, vw - rect.width - pad);
        if (y + rect.height + pad > vh) y = Math.max(pad, vh - rect.height - pad);
        tip.style.left = x + 'px';
        tip.style.top = y + 'px';
      }

      nodes.forEach(function (el) {
        storeAndDisableNative(el);
        if (el.getAttribute('data-pl-tt-bound')) return;
        el.setAttribute('data-pl-tt-bound', '1');
        el.addEventListener('mouseenter', function (ev) { showTip(el, ev); });
        el.addEventListener('mousemove', function (ev) { moveTip(ev); });
        el.addEventListener('mouseleave', function () { hideTip(); });
      });
    } catch (e) {}
  }

  let hideTimer = null;
let hotzoneEl = null;
function ensureHotzone(){
  if(hotzoneEl) return;
  hotzoneEl = document.createElement('div');
  hotzoneEl.id = 'plTopHotzone';
  document.body.appendChild(hotzoneEl);

  function reveal(){
    document.body.classList.remove('pl-top-hidden');
    scheduleHideTopbar();
  }

  hotzoneEl.addEventListener('mouseenter', reveal);
  hotzoneEl.addEventListener('mousemove', reveal);
  hotzoneEl.addEventListener('touchstart', reveal, {passive:true});

  document.addEventListener('mousemove', function(e){
    if(isFullscreen() && e.clientY <= 6) reveal();
  });
  document.addEventListener('touchstart', function(e){
    if(!isFullscreen()) return;
    const t = e.touches && e.touches[0];
    if(t && t.clientY <= 20) reveal();
  }, {passive:true});
}


  function scheduleHideTopbar() {
    clearTimeout(hideTimer);
    hideTimer = setTimeout(function () {
      if (isFullscreen()) document.body.classList.add('pl-top-hidden');
    }, 5000);
  }

  function onFullscreenChange() {
    plSetBoardTheme();
    
    try{ document.body.classList.toggle('pl-fullscreen', isFullscreen()); }catch(e){}
ensureHotzone();
    if (isFullscreen()) scheduleHideTopbar();
    else document.body.classList.remove('pl-top-hidden');
    // Do NOT re-init tooltips here; fullscreen toggles should not rebuild/bind tooltips.
    // Tooltips are initialized on page load and after refreshBoard() DOM updates.
  }

  let refreshInterval = 0;
  let countdown = 0;
  let tickTimer = null;
  let lastClock = '';

  
  function stopAutoRefresh(){
    if (tickTimer) { clearInterval(tickTimer); tickTimer = null; }
  }

function startAutoRefresh() {
    // Pure JS: read refresh interval from the UI combobox
    const selVal = getSelectedRefresh();
    refreshInterval = (selVal !== null ? selVal : 0);
    if (refreshInterval <= 0) return;

    countdown = refreshInterval;
    updateCountdown();
    renderStatusLine();

    clearInterval(tickTimer);
    tickTimer = setInterval(function () {
      countdown--;
      if (countdown <= 0) {
        countdown = refreshInterval;
        refreshBoard();
      }
      updateCountdown();
    }, 1000);
  }

  function updateCountdown() {
    renderStatusLine();
  }

  function renderStatusLine() {
    const lu = $('plLastUpdate');
    if (!lu) return;
    const selVal = getSelectedRefresh();
    const sec = (refreshInterval > 0 ? refreshInterval : (selVal !== null ? selVal : 0));
    const cd = countdown || 0;
    const clock = lastClock || '-';
    lu.textContent = 'Last update: ' + clock + ' • Auto-refresh: ' + (sec || 0) + 's (' + cd + ')';
  }



  function getTopbarForm(){
    const sel = document.querySelector('select[name="refresh"]') || $('plRefresh');
    if (sel) return sel.closest('form');
    const st = document.querySelector('select[name="station"]') || $('plStation');
    if (st) return st.closest('form');
    return null;
  }

  function getSelectedRefresh(){
    const sel = document.querySelector('select[name="refresh"]') || $('plRefresh');
    if (!sel) return null;
    const v = parseInt(sel.value, 10);
    return Number.isFinite(v) ? v : null;
  }

  function getSelectedStation(){
    const sel = document.querySelector('select[name="station"]') || $('plStation');
    if (!sel) return null;
    return sel.value || '';
  }

  function applyControlsNoReload(){
    const sec = getSelectedRefresh();
    const st = getSelectedStation();

    // Update URL so refreshBoard() uses current filters without reloading
    try{
      const url = new URL(window.location.href);
      if (sec !== null) url.searchParams.set('refresh', String(sec));
      if (st !== null) url.searchParams.set('station', String(st));
      // Sync showdraft checkbox to URL
      const sdCb = document.querySelector('input[name="showdraft"]');
      if (sdCb && sdCb.checked) url.searchParams.set('showdraft', '1');
      else url.searchParams.delete('showdraft');
      window.history.replaceState({}, '', url.toString());
    }catch(e){}

    // Apply new interval and restart countdown
    refreshInterval = (sec !== null ? sec : 0);
    countdown = (refreshInterval > 0 ? refreshInterval : 0);
    stopAutoRefresh();
    if (refreshInterval > 0) startAutoRefresh();

    // Refresh board immediately (ajax=1)
    refreshBoard();
  }


  // --- Late only filter ---
  var LATE_FILTER_KEY = 'plBoardLateOnly';

  function isLateFilterOn() {
    var cb = $('plLateOnly');
    return cb && cb.checked;
  }

  function applyLateFilter() {
    var on = isLateFilterOn();
    document.body.classList.toggle('pl-filter-late-only', on);
  }

  function saveLateFilter() {
    try {
      localStorage.setItem(LATE_FILTER_KEY, isLateFilterOn() ? '1' : '0');
    } catch (e) {}
  }

  function restoreLateFilter() {
    try {
      var val = localStorage.getItem(LATE_FILTER_KEY);
      var cb = $('plLateOnly');
      if (cb && val === '1') cb.checked = true;
    } catch (e) {}
    applyLateFilter();
  }

  function initLateFilter() {
    restoreLateFilter();
    var cb = $('plLateOnly');
    if (cb) {
      cb.addEventListener('change', function () {
        saveLateFilter();
        applyLateFilter();
        // Re-check empty columns after late filter changes
        if (typeof applyHideEmptyFilter === 'function') applyHideEmptyFilter();
        if (typeof organizeColumns === 'function') organizeColumns();
      });
    }
  }
  // --- End late filter ---

  // --- Hide empty columns filter ---
  var HIDE_EMPTY_KEY = 'plBoardHideEmpty';

  function isHideEmptyOn() {
    var cb = $('plHideEmpty');
    return cb && cb.checked;
  }

  function markEmptyColumns() {
    // Mark columns as empty if they have no visible cards
    var cols = document.querySelectorAll('.pl-col');
    cols.forEach(function(col) {
      var cards = col.querySelectorAll('.pl-card');
      var hasVisible = false;
      cards.forEach(function(card) {
        // Check if card is visible (not hidden by CSS like late filter)
        var style = window.getComputedStyle(card);
        if (style.display !== 'none') hasVisible = true;
      });
      col.classList.toggle('pl-col-empty', !hasVisible);
    });
  }

  function applyHideEmptyFilter() {
    markEmptyColumns();
    var on = isHideEmptyOn();
    document.body.classList.toggle('pl-filter-hide-empty', on);
  }

  function saveHideEmptyFilter() {
    try {
      localStorage.setItem(HIDE_EMPTY_KEY, isHideEmptyOn() ? '1' : '0');
    } catch (e) {}
  }

  function restoreHideEmptyFilter() {
    try {
      var val = localStorage.getItem(HIDE_EMPTY_KEY);
      var cb = $('plHideEmpty');
      if (cb && val === '1') cb.checked = true;
    } catch (e) {}
    applyHideEmptyFilter();
  }

  function initHideEmptyFilter() {
    restoreHideEmptyFilter();
    var cb = $('plHideEmpty');
    if (cb) {
      cb.addEventListener('change', function () {
        saveHideEmptyFilter();
        applyHideEmptyFilter();
        if (typeof organizeColumns === 'function') organizeColumns();
      });
    }
  }
  // --- End hide empty filter ---

  // --- Organize columns into Forming/Trimming sections ---
  function getColLabel(col) {
    var head = col.querySelector('.pl-col-head');
    if (!head) return '';
    // Get text before the count span
    var clone = head.cloneNode(true);
    var countSpan = clone.querySelector('.pl-col-count');
    if (countSpan) countSpan.remove();
    return clone.textContent.trim();
  }

  function getEarliestVisibleEnd(col) {
    var cards = col.querySelectorAll('.pl-card');
    var earliest = null;
    cards.forEach(function(card) {
      var style = window.getComputedStyle(card);
      if (style.display === 'none') return;
      var endTs = parseInt(card.getAttribute('data-end'), 10);
      if (endTs > 0 && (earliest === null || endTs < earliest)) {
        earliest = endTs;
      }
    });
    return earliest;
  }

  function organizeColumns() {
    var srcGrid = $('plBoardGrid');
    if (!srcGrid) return;

    var gridForming = document.querySelector('#plSectionForming .pl-board-grid');
    var gridTrimming = document.querySelector('#plSectionTrimming .pl-board-grid');
    if (!gridForming || !gridTrimming) return;

    // Collect columns from source
    var cols = Array.prototype.slice.call(srcGrid.querySelectorAll('.pl-col'));
    var formingCols = [];
    var trimmingCols = [];

    cols.forEach(function(col) {
      var label = getColLabel(col).toLowerCase();
      if (/trim/.test(label)) {
        trimmingCols.push(col);
      } else {
        // Forming + Other go to Forming section
        formingCols.push(col);
      }
    });

    // Sort by earliest visible card end (null = last)
    function sortByEnd(arr) {
      return arr.sort(function(a, b) {
        var endA = getEarliestVisibleEnd(a);
        var endB = getEarliestVisibleEnd(b);
        if (endA === null && endB === null) return 0;
        if (endA === null) return 1;
        if (endB === null) return -1;
        return endA - endB;
      });
    }

    formingCols = sortByEnd(formingCols);
    trimmingCols = sortByEnd(trimmingCols);

    // Clear and populate grids
    gridForming.innerHTML = '';
    gridTrimming.innerHTML = '';
    formingCols.forEach(function(col) { gridForming.appendChild(col); });
    trimmingCols.forEach(function(col) { gridTrimming.appendChild(col); });

    // Hide section if empty
    var secForming = $('plSectionForming');
    var secTrimming = $('plSectionTrimming');
    if (secForming) secForming.style.display = formingCols.length ? '' : 'none';
    if (secTrimming) secTrimming.style.display = trimmingCols.length ? '' : 'none';
  }
  // --- End organize columns ---

function refreshBoard() {
  // Fetch from the same page renderer (ajax=1) so the HTML/tooltip markup
  // is identical to a full manual refresh.
  const url = new URL(window.location.href);
  url.searchParams.set('ajax', '1');
  url.searchParams.set('_ts', Date.now());

  // Detect scroll container (the one that actually scrolls)
  function getScrollContainer() {
    var page = $('plBoardPage');
    var grid = $('plBoardGrid');
    if (page && page.scrollHeight > page.clientHeight) return page;
    if (grid && grid.scrollHeight > grid.clientHeight) return grid;
    if (page) return page;
    return null;
  }
  var scrollEl = getScrollContainer();
  var savedScroll = scrollEl ? { id: scrollEl.id || null, top: scrollEl.scrollTop, left: scrollEl.scrollLeft } : null;

  return fetch(url.toString(), { cache: 'no-store', credentials: 'same-origin' })
    .then(r => r.json())
    .then(data => {
      if (data && data.html) {

        // === CRITICAL: CLEAN OLD AJAX TOOLTIP ARTIFACTS ===
        document
          .querySelectorAll('.classforajaxtooltip,[data-params]')
          .forEach(el => {
            el.removeAttribute('data-params');
            el.removeAttribute('title');
            el.classList.remove('classforajaxtooltip');
          });
        // =================================================

        const grid = $('plBoardGrid');
        if (grid) {
          // Keep the same #plBoardGrid node (so fullscreen doesn't exit), replace only its contents.
          const tmp = document.createElement('div');
          tmp.innerHTML = data.html;
          const newGrid = tmp.querySelector('#plBoardGrid');
          grid.innerHTML = newGrid ? newGrid.innerHTML : data.html;

        }
        // Restore scroll position after DOM update (in rAF to survive reflow)
        if (savedScroll) {
          requestAnimationFrame(function() {
            // Try saved element first, fallback to detection
            var el = (savedScroll.id && $(savedScroll.id)) || getScrollContainer();
            if (el) {
              el.scrollTop = savedScroll.top;
              el.scrollLeft = savedScroll.left;
            }
          });
        }
      }

      lastClock = (data.clock || data.server_time || '-');
      renderStatusLine();

      // Re-init ONLY non-AJAX tooltips (HTML / Job / custom)
      setTimeout(initTooltips, 0);

      // Re-apply filters after DOM update
      applyLateFilter();
      applyHideEmptyFilter();
      organizeColumns();
    })
    .catch(() => {
      const lu = $('plLastUpdate');
      if (lu) lu.textContent = 'Last update: ERROR';
    });
}

  // Debug: expose refresh function globally
  window.plBoardRefresh = refreshBoard;

  function init() {

    // Ensure Dolibarr AJAX endpoints (ajaxtooltip.php) get CSRF token + action after auto-refresh
    (function(){
      try {
        var meta = document.querySelector('meta[name=token]');
        var tok = (meta && meta.getAttribute('content')) || window.dolibarr_token || window.token || '';
        if (tok) {
          window.dolibarr_token = window.dolibarr_token || tok;
          window.token = window.token || tok;
        }
        if (!window.jQuery || !window.jQuery.ajaxPrefilter) return;

        // Only register once
        if (window.__plAjaxPrefilterInstalled) return;
        window.__plAjaxPrefilterInstalled = true;

        window.jQuery.ajaxPrefilter(function(options, originalOptions, jqXHR){
          try {
            if (!options || !options.url) return;
            if (options.url.indexOf('/core/ajax/ajaxtooltip.php') === -1) return;

            var m = document.querySelector('meta[name=token]');
            var t = (m && m.getAttribute('content')) || window.dolibarr_token || window.token || '';
            if (!t) return;

            var ensure = function(obj){
              if (!obj.action) obj.action = 'fetch';
              if (!obj.token) obj.token = t;
            };

            var method = (options.type || 'GET').toUpperCase();
            if (method === 'POST') {
              if (typeof options.data === 'string') {
                if (options.data.indexOf('action=') === -1) options.data += (options.data ? '&' : '') + 'action=fetch';
                if (options.data.indexOf('token=') === -1) options.data += (options.data ? '&' : '') + 'token=' + encodeURIComponent(t);
              } else if (typeof options.data === 'object' && options.data) {
                ensure(options.data);
              } else {
                options.data = 'action=fetch&token=' + encodeURIComponent(t);
              }
            } else {
              if (options.url.indexOf('action=') === -1) options.url += (options.url.indexOf('?') === -1 ? '?' : '&') + 'action=fetch';
              if (options.url.indexOf('token=') === -1) options.url += (options.url.indexOf('?') === -1 ? '?' : '&') + 'token=' + encodeURIComponent(t);
            }
          } catch(e) {}
        });
      } catch(e) {}
    })();

  try{ document.body.classList.toggle('pl-fullscreen', isFullscreen()); }catch(e){}

    // ensure hotzone style
(function(){
  if(document.getElementById('plTopHotzoneStyle')) return;
  const st=document.createElement('style');
  st.id='plTopHotzoneStyle';
  st.textContent = '#plTopHotzone{position:fixed;top:0;left:0;right:0;height:14px;z-index:10050;} body:not(.pl-top-hidden) #plTopHotzone{display:none;}';
  document.head.appendChild(st);
})();

    ensureHotzone();
    initLateFilter();
    initHideEmptyFilter();
    organizeColumns();
//    initTooltips();
    startAutoRefresh();

    // Apply (station/refresh) without page reload to keep fullscreen
    const topForm = getTopbarForm();
    if (topForm && !topForm.__plBound) {
      topForm.__plBound = true;
      topForm.addEventListener('submit', function(e){
        e.preventDefault();
        applyControlsNoReload();
      }, true);
    }


    const fsBtn = $('plFullscreen');
    if (fsBtn) {
      fsBtn.addEventListener('click', function () {
        const page = $('plBoardPage') || document.documentElement;
        if (!isFullscreen()) requestFullscreen(page);
        else exitFullscreen();
      });
    }

    document.addEventListener('fullscreenchange', onFullscreenChange);
    document.addEventListener('webkitfullscreenchange', onFullscreenChange);
    // tooltip przenosimy osobno
    document.addEventListener('fullscreenchange', plMoveTooltipToFullscreenHost);
    document.addEventListener('webkitfullscreenchange', plMoveTooltipToFullscreenHost);
  }

  if (document.readyState === 'loading')
    document.addEventListener('DOMContentLoaded', function(){ plSetBoardTheme(); init(); });
  else init();
})();


function plMoveTooltipToFullscreenHost() {
  const tip = document.getElementById('plHtmlTooltip');
  if (!tip) return;
  const host = document.fullscreenElement || document.webkitFullscreenElement || document.body;
  if (tip.parentNode !== host) host.appendChild(tip);
}
