# Debug Example Output

## Scenario: Rate Not Configured Error

### Step 1: Enable Debug
Edit [timeline.php](timeline.php) line ~100:
```php
$addJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/add_job.php?debug=1';
```

### Step 2: User Submits Modal Form with Missing Rate

User clicks "Add Job" in modal when product has no `qty_per_hour_form` configured.

### Step 3: Browser Console / Network Tab Shows:

**Request:**
```
POST /custom/planning/ajax/add_job.php?debug=1
Content-Type: multipart/form-data

token=xyz123
group_code=forming
fk_workstation=5
fk_product=42
qty=100
date_start=2026-01-22T08:00
```

**Response (HTTP 500):**
```json
{
  "error": "Product rate (qty_per_hour_form) is not configured or is invalid. Please set the production rate for this product.",
  "debug_message": "Product rate (qty_per_hour_form) is not configured or is invalid. Please set the production rate for this product.",
  "debug_file": "/var/www/dolibarr/custom/planning/ajax/add_job.php",
  "debug_line": 313,
  "db_error": null
}
```

### Step 4: Modal Shows User-Friendly Error + Debug Info

**In the modal error div:**
```
Product rate (qty_per_hour_form) is not configured or is invalid. Please set the production rate for this product.

Debug Info:
  Message: Product rate (qty_per_hour_form) is not configured or is invalid. Please set the production rate for this product.
  File: /var/www/dolibarr/custom/planning/ajax/add_job.php
  Line: 313
  DB Error: 
```

### Step 5: Server Logs Show Full Context

**In Dolibarr logs (e.g., `/var/www/dolibarr/documents/dolibarr.log`):**
```
[time] Planning Add Job Error: Product rate (qty_per_hour_form) is not configured or is invalid. Please set the production rate for this product. in /var/www/dolibarr/custom/planning/ajax/add_job.php:313
```

---

## Scenario: Database Connection Error

### Step 1: Same as above - enable `?debug=1`

### Step 2: Database temporarily unavailable

### Response (HTTP 500):
```json
{
  "error": "Database error: Lost connection to MySQL server",
  "debug_message": "Database error: Lost connection to MySQL server",
  "debug_file": "/var/www/dolibarr/custom/planning/ajax/add_job.php",
  "debug_line": 368,
  "db_error": "Lost connection to MySQL server during query"
}
```

### Modal Error Display:
```
Database error: Lost connection to MySQL server

Debug Info:
  Message: Database error: Lost connection to MySQL server
  File: /var/www/dolibarr/custom/planning/ajax/add_job.php
  Line: 368
  DB Error: Lost connection to MySQL server during query
```

### Server Log:
```
[time] Planning Add Job Error: Database error: Lost connection to MySQL server in /var/www/dolibarr/custom/planning/ajax/add_job.php:368
[time] Planning Add Job DB Error: Lost connection to MySQL server during query
```

---

## Scenario: Without Debug (Production)

### Same scenario, but `add_job.php` URL has NO `?debug=1`

**Response (still HTTP 500, but NO debug fields):**
```json
{
  "error": "Product rate (qty_per_hour_form) is not configured or is invalid. Please set the production rate for this product."
}
```

**Modal Error Display:**
```
Product rate (qty_per_hour_form) is not configured or is invalid. Please set the production rate for this product.
```

**Server Log (still detailed, always):**
```
[time] Planning Add Job Error: Product rate (qty_per_hour_form) is not configured or is invalid. Please set the production rate for this product. in /var/www/dolibarr/custom/planning/ajax/add_job.php:313
```

---

## Key Differences

| Aspect | With Debug | Without Debug |
|--------|-----------|---------------|
| User sees file/line | ✅ Yes | ❌ No |
| Server always logs details | ✅ Yes | ✅ Yes |
| GET requests show debug | ❌ No (POST only) | N/A |
| CSRF still validated | ✅ Yes | ✅ Yes |
| Works for admins | ✅ Yes | ✅ Yes |

---

## How to Enable for Testing

### Option A: Temporary (for this session)
Edit [timeline.php](timeline.php):
```php
$addJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/add_job.php?debug=1';
```
Then refresh the page.

### Option B: Persistent (in your module config)
In your module's setup/configuration file:
```php
$conf->global->PLANNING_DEBUG = 1;
```

### Option C: Admin Auto-Enable
No code needed. If logged in as admin, debug is automatic.

---

## Checking Server Logs

### Dolibarr Default Logs
Location: `dolibarr_root/documents/dolibarr.log`

Commands to view:
```bash
# Last 20 lines
tail -20 /var/www/dolibarr/documents/dolibarr.log

# Follow in real-time
tail -f /var/www/dolibarr/documents/dolibarr.log

# Search for Planning errors
grep "Planning Add Job" /var/www/dolibarr/documents/dolibarr.log
```

### Example log output:
```
2026-01-22 12:34:56 Planning Add Job Error: Product rate (qty_per_hour_form) is not configured or is invalid. Please set the production rate for this product. in /var/www/dolibarr/custom/planning/ajax/add_job.php:313
2026-01-22 12:34:57 Planning Add Job: Product #42 missing rate field options_qty_per_hour_form. Available options: product_name, color, weight
```
