# ANALIZA POSTĘPU - ETAP 3.2 (Edit Job w lewym panelu)

Data: 2026-01-21  
Projekt: Dolibarr Planning Module

---

## 1. ETAPY REALIZOWANE (CLOSED / COMPLETED)

### ✅ ETAP 2.4 — Timeline layout & scroll
**STATUS: CLOSED & FROZEN**

**Realizacja:**
- [css/timeline.css](css/timeline.css#L1-L100) — Kontener `.pl-timeline-page` z `overflow: hidden` (brak scrollbarów na stronie)
- [js/timeline.js](js/timeline.js#L1-L150) — `renderTimeline()` obsługuje Days: 7/14/21/30 via `data-days` attribute
- CSS Variables: `--pl-day-count`, `--pl-day-width` dla responsywności
- Pojedynczy horizontal scrollbar w `.pl-timeline-grid` (kontener graficzny)
- Layout **FROZEN** — jakakolwiek zmiana grozi naruszeniem specyfikacji

**Ryzyko dla ETAP 3.2:** ⚠️ **WYSOKIE** — edycja nie może zmienić dimenzji kolumn, liczby dni, wysokości rzędów

---

### ✅ ETAP 3.0 — Add Job via Timeline
**STATUS: CLOSED**

**Realizacja:**
- [ajax/add_job.php](ajax/add_job.php) — Backend endpoint, weryfikacja `planning->addjob` permission
- [js/timeline.js](js/timeline.js#L700-L800) — Modal `.plAddJobModal`, forma `plAddJobForm`
- Button `.pl-btn-add-job` w headerze (przed Days combobox)
- Prefill na klik kratki: workstation, data_start = 06:30
- Auto-refresh timeline po zapisie
- Obsługa CSRF token

**Pola zapisywane:**
```
fk_workstation, group_code, works_order_no, estimated_hours, 
date_start, date_end, notes, sort_order (auto), status = 'planned'
```

---

### ✅ ETAP 3.1 — Add Job stabilization
**STATUS: CLOSED**

**Realizacja:**
- [ajax/add_job.php](ajax/add_job.php#L60-L90) — Walidacja: group_code, fk_workstation, workstation exists
- Domyślne wartości: `estimated_hours = 1.0`, `status = 'planned'`, `sort_order = auto (MAX+10)`
- Obsługa non-JSON: `.catch(function() { throw new Error('Invalid server response'); })`
- Modal pozostaje otwarty przy błędzie (error div: `#plAddJobError`)
- Obsługa formatów datetime: `YYYY-MM-DDTHH:MM`, `YYYY-MM-DD HH:MM:SS`

---

### ✅ ETAP 3.2a — Add Job z kliknięcia kratki
**STATUS: CLOSED**

**Realizacja:**
- [js/timeline.js](js/timeline.js#L170-L185) — Event bind na `.pl-tl-day-cell` (empty cell click)
- Funkcja `openAddJobModalWithPrefill(machineId, date)` [js/timeline.js](js/timeline.js#L780-L805)
- Prefill: `date_start = YYYY-MM-DD 06:30` (planning day boundary)
- Obliczenie `date_end` na podstawie `estimated_hours` (helper `updateEndTime()`)
- Poprawne pozycjonowanie joba w timeline po zapisie (auto-refresh)
- Klik w job blok: `selectJob()` → renderuje kartę w lewym panelu [js/timeline.js](js/timeline.js#L250-L320)

---

## 2. ETAP 3.2 — Edit Job (left panel) — CURRENT PHASE

**STATUS: OPEN** → **IN ANALYSIS**

### 2.1 CO JUŻ JEST ZROBIONE

#### Backend
- [ajax/update_job.php](ajax/update_job.php) — **PEŁNY ENDPOINT GOTOWY** ✅
  - Permission check: `planning->editjob`
  - Obsługuje: fk_workstation, group_code, date_start, date_end, estimated_hours, status, notes
  - Walidacja workstation existence
  - Walidacja status: `planned|in_progress|paused|completed|cancelled`
  - Transaction handling: `$db->begin()` / `$db->commit()` / `$db->rollback()`
  - Update modifier info: `fk_user_modif`, `tms`

#### Frontend — struktury HTML/CSS
- [js/timeline.js](js/timeline.js#L380-L510) — `renderJobCardEditMode()` — **FORMA GOTOWA**
  - Formularze: workstation select, group select, status select
  - Inputs: estimated_hours (number), date_start (datetime-local), date_end (datetime-local)
  - Textarea: notes
  - Error div: `#plEditJobError`
  - Submit button: `#plEditJobSave`
  - Cancel button: `#plEditJobCancel`

- [css/timeline.css](css/timeline.css#L716-L730) — Styling dla edit mode (`.pl-job-card-edit-form`)
  - Form groups, labels, inputs, buttons
  - Error display
  - Disabled state

#### Frontend — logika edycji
- [js/timeline.js](js/timeline.js#L560-L580) — `enterEditMode()` → ustawia `editMode=true`, przechowuje dane oryginalne
- [js/timeline.js](js/timeline.js#L582-L595) — `cancelEditMode()` → przywraca stare dane, wraca do view mode
- [js/timeline.js](js/timeline.js#L597-L670) — `submitEditJob()` — **LOGIKA GOTOWA**
  - Gromadzenie danych z formy
  - POST do `config.updatejobEndpoint`
  - Obsługa errorów (error div)
  - Disable button podczas wysyłki
  - Success: exit edit mode, `fetchTimeline()` (auto-refresh)

#### Database
- [sql/llx_planning.sql](sql/llx_planning.sql#L1-L60) — Tabela `llx_planning_job` ma wszystkie pola:
  ```sql
  fk_workstation, group_code, date_start, date_end, 
  estimated_hours, status, notes, fk_user_modif, tms
  ```

---

### 2.2 CO BRAKUJE — LISTA TODO

| # | Zadanie | Plik | Typ | Status |
|---|---------|------|-----|--------|
| 1 | Dodać config `updatejobEndpoint` do data attrs `#plTimelinePage` | planning.php | PHP | ❌ TODO |
| 2 | Dodać config `canEditjob` do data attrs (permission check) | planning.php | PHP | ❌ TODO |
| 3 | Załadować workstations do `config.workstations` w timeline.js | planning.php | PHP | ❌ TODO |
| 4 | Obsłużyć `qty` pole (jeśli istnieje w DB) — optional | - | - | 🔄 OPTIONAL |
| 5 | Dodać przycisk "Edit" w karcie (view mode) | css/timeline.css + js/timeline.js | CSS/JS | ✅ JAW (jest w kodzie) |
| 6 | Zdefiniować route/permission dla editjob | core/modules/modPlanning.class.php | PHP | ❌ TODO |
| 7 | Testy: edycja pól, walidacja, error handling | - | Test | ❌ TODO |

---

### 2.3 SZCZEGÓŁY TODO — CO DOKŁADNIE TRZEBA ZMIENIĆ

#### TODO #1: planning.php — Dodać `updatejobEndpoint` do data attrs

**Lokacja:** [planning.php](planning.php#L30-L50)

**Co robić:**
```php
// Linie ~30-45, w miejscu gdzie renderuje się #plTimelinePage
// Dodać do HTML:

$updatejobEndpoint = dol_buildpath('/custom/planning/ajax/update_job.php', 1);

print '<div id="plTimelinePage"';
print ' data-group="' . esc($viewGroup) . '"';
print ' data-days="' . (int)$days . '"';
print ' data-endpoint="' . esc($timelineEndpoint) . '"';
print ' data-addjobEndpoint="' . esc($addjobEndpoint) . '"';
print ' data-updatejobEndpoint="' . esc($updatejobEndpoint) . '"';  // ← NOWE
print ' data-token="' . esc($_SESSION['newtoken'] ?? $_SESSION['token'] ?? '') . '"';
print ' data-canAddjob="' . ($user->rights->planning->addjob ? '1' : '0') . '"';
print ' data-canEditjob="' . ($user->rights->planning->editjob ? '1' : '0') . '"';  // ← NOWE
// ... reszta attrs
```

**Dlaczego:** Frontend potrzebuje URL do update_job.php i musi znać permission user'a, aby pokazać przycisk Edit.

---

#### TODO #2: planning.php — Załadować workstations do config

**Lokacja:** [planning.php](planning.php#L70-L100) (w sekcji workstation discovery)

**Co robić:**
```php
// W planning.php już są workstations loaded dla combobox na stronie
// Trzeba je przekazać do JS via data attr:

// Istniejący kod wczytuje workstations w $availableStations
// Dodać:

$wsForJson = array();
foreach ($availableStations as $wsId => $wsLabel) {
    $wsForJson[] = array(
        'id' => (int)$wsId,
        'label' => (string)$wsLabel
    );
}
$wsJson = json_encode($wsForJson);

// W data attrs #plTimelinePage:
print ' data-workstations="' . esc($wsJson) . '"';
```

**Dlaczego:** JS potrzebuje listy workstations dla selecta w edit formie. Obecnie `config.workstations` jest `[]`.

---

#### TODO #3: core/modules/modPlanning.class.php — Zdefiniować permission

**Lokacja:** [core/modules/modPlanning.class.php](core/modules/modPlanning.class.php) — sekcja `rights`

**Co robić:**
```php
// W klassie modPlanning, w konfiguracji permissions:
// Dodać (jeśli brakuje):

$this->rights = array(
    // ... existing rights
    array(
        0 => 12345,  // ID (unikatowy)
        1 => 'Edit planning job',
        2 => 'editjob',
        3 => 1,
        4 => 'planning'
    ),
    // ...
);
```

**Dlaczego:** Permission `planning->editjob` musi być zdefiniowana w module manifest, aby Dolibarr mogła ją przypisać użytkownikom.

---

#### TODO #4: CSS — edit mode styling (MAY EXIST)

**Lokacja:** [css/timeline.css](css/timeline.css#L716+)

**Status:** Styles dla `.pl-job-card-edit-form` już istnieją ✅

```css
.pl-job-card-edit-form .pl-form-group { ... }
.pl-job-card-edit-form .pl-form-label { ... }
.pl-job-card-edit-form .pl-form-input { ... }
.pl-job-card-edit-form textarea.pl-form-input { ... }
.pl-job-card-edit-footer { ... }
```

**Co ewentualnie trzeba:** Przysłonięcie `pl-job-card-edit-form` tak aby nie zajął całej karty — patrz risky point #1.

---

## 3. RYZYKA NARUSZENIA ETAP 2.4 (TIMELINE LAYOUT FROZEN)

### 🔴 RYZYKO #1: Edit card zmienia wysokość panelu lewego
**Opis:** Gdy user przejdzie w edit mode, form może być dłuższy niż view mode card. To może spowodować:
- Vertical scrollbar w lewym panelu
- Zmianę proporcji layout'u timeline
- Potencjalny layout jump

**Jak uniknąć:**
- Edit form ma max-height z vertical scrollbar (jeśli potrzebny)
- Lewu panel `.pl-timeline-left` ma `overflow-y: auto` (już powinno być)
- View mode card i edit form mają zbliżoną wysokość (designerskie wymaganie)

**Sprawdzenie w CSS:**
```css
.pl-timeline-left {
  flex: 0 0 280px;
  overflow-y: auto;  /* ← MUSI BYĆ */
  overflow-x: hidden;
  /* height zafiksowana na całą wysokość kontenera */
}
```

---

### 🔴 RYZYKO #2: Submit button w edit mode zmienia rozmiar przycisku
**Opis:** Jeśli przycisk "Save" ma inny font-size lub padding niż "Edit", layout mogą się przesunąć.

**Jak uniknąć:**
- CSS consistency: `.pl-btn`, `.pl-btn-submit`, `.pl-btn-cancel` mają spójne wymiary
- Footer formularza `.pl-job-card-edit-footer` ma fixed height

---

### 🔴 RYZYKO #3: Edit mode zmienia szerokość timeline'a
**Opis:** Jeśli left panel robi się narrower/wider, timeline grid mogą się przesunąć.

**Jak uniknąć:**
- Left panel `.pl-timeline-left` ma `flex: 0 0 280px` — fixed width
- Timeline grid `.pl-timeline-grid` zawsze `flex: 1 1 0`
- Nigdy nie zmieniamy tych wartości w edit mode

---

### 🟡 RYZYKO #4: Date inputs (datetime-local) mają inna wysokość/padding
**Opis:** HTML datetime-local inputs mogą renderować się różnie w różnych przeglądarkach.

**Jak uniknąć:**
- CSS: `.pl-form-input[type="datetime-local"]` ma jawny height i padding
- Już jest w CSS (linia ~600+): `.pl-form-input { ... padding: ... }`

---

### 🟢 BEZPIECZNE — Co nie zagraża ETAP 2.4:
✅ Edit form w lewym panelu (nie zmienia timeline grid)  
✅ AJAX update job (nie zmienia frontend layout)  
✅ Auto-refresh timeline (respektuje poprzedni scroll position)  
✅ Form validation (tylko błędy w error div, nie w layout)  

---

## 4. WALIDACJA BACKENDU — Co jest już OK w update_job.php

```php
✅ CSRF token check
✅ Permission check: planning->editjob
✅ Job existence validation
✅ Workstation validation
✅ Status validation: planned|in_progress|paused|completed|cancelled
✅ Group code validation: forming|trimming
✅ Datetime parsing (YYYY-MM-DDTHH:MM → YYYY-MM-DD HH:MM:SS)
✅ Transaction handling
✅ Modifier tracking (fk_user_modif, tms)
✅ JSON response format
```

**Brakuje:** Nic — backend jest gotów.

---

## 5. WALIDACJA FRONTENDU — Co jest już OK w timeline.js

```javascript
✅ Edit/Cancel/View mode toggle
✅ Form data gathering (FormData API)
✅ AJAX POST do config.updatejobEndpoint
✅ Error handling i display
✅ Button disable/enable (UX)
✅ Timeline refresh po success
✅ Job deselection po success
✅ ESC key binding (jeśli modal otwarta)
```

**Brakuje:**
- ❌ `config.updatejobEndpoint` nie jest ładowany (brakuje w planning.php data attrs)
- ❌ `config.canEditjob` nie jest ładowany
- ❌ `config.workstations` jest pusty (nie wczytane z serwera)

---

## 6. PODSUMOWANIE — LISTA ZMIAN DO WYKONANIA

### Krytyczne (MUST HAVE) — 3 zmiany
1. **planning.php** — Dodać `data-updatejobEndpoint`
2. **planning.php** — Dodać `data-canEditjob` 
3. **planning.php** — Dodać `data-workstations` z JSON array'em

### Opcjonalne (NICE TO HAVE)
4. **core/modules/modPlanning.class.php** — Dodać permission `editjob` (jeśli brakuje)
5. **CSS** — Zoptymalizować high of edit form (jeśli będzie zbyt duży)

### Ryzyka do monitorowania
- ⚠️ Wysokość lewego panelu przy edit form
- ⚠️ Fixed width left panel (nie może zmienić się w edit mode)
- ⚠️ Timeline grid responsywność (Day width musi się nie zmienić)

---

## 7. ARKUSZ DECYZJI — CO ROBIĆ DALEJ

**Opcja A: Szybka implementacja (1h)**
- Dodać 3 atrybuty do planning.php
- Test: czy permission check działa
- Test: czy form się renderuje z workstations
- Test: czy update_job.php odbiera dane

**Opcja B: Pełna implementacja (3h)**
- Opcja A
- Dodać permission w modPlanning.class.php
- Optimize CSS (jeśli form za duży)
- Pełne testy: edycja każdego pola, walidacje, cancel, etc.

**Opcja C: Szybka + Ryzyka mitygacja (2h)**
- Opcja A
- Dodać defensive CSS (max-height na form, overflow)
- Visual regression test (czy layout się nie przesunął)

---

## REKOMENDACJA
🎯 **Opcja B** — pełna, aby być pewnym że wszystko działa i ETAP 2.4 pozostaje FROZEN.
