<?php
/**
 * Planning Timeline - Read-only visual timeline view
 * Displays jobs as blocks on a horizontal timeline per machine.
 */

require '../../main.inc.php';

if (empty($user->rights->planning) || empty($user->rights->planning->read)) {
    accessforbidden();
}

$langs->loadLangs(array('main', 'mrp', 'products'));

// Get parameters
$group = GETPOST('group', 'aZ09');
if (empty($group) || !in_array($group, array('forming', 'trimming'))) {
    $group = 'forming';
}
$days = (int) GETPOST('days', 'int');
if ($days < 1 || $days > 60) {
    $days = 14;
}

$morejs = array('/custom/planning/js/timeline.js');
$morecss = array('/custom/planning/css/timeline.css');

llxHeader('', 'Planning Timeline', '', '', 0, 0, $morejs, $morecss);

$tlEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/timeline_data.php';
print '<div class="pl-timeline-page" id="plTimelinePage"';
print ' data-group="' . dol_escape_htmltag($group) . '"';
print ' data-days="' . (int)$days . '"';
print ' data-endpoint="' . dol_escape_htmltag($tlEndpoint) . '"';
print '>';

// Title and tabs
print '<div class="pl-timeline-header">';
print '<h1 class="pl-timeline-title">Planning Timeline</h1>';

print '<div class="pl-timeline-tabs">';
$formingClass = ($group === 'forming') ? 'pl-tab-active' : '';
$trimmingClass = ($group === 'trimming') ? 'pl-tab-active' : '';
print '<a href="' . $_SERVER['PHP_SELF'] . '?group=forming&days=' . $days . '" class="pl-tab ' . $formingClass . '">Forming</a>';
print '<a href="' . $_SERVER['PHP_SELF'] . '?group=trimming&days=' . $days . '" class="pl-tab ' . $trimmingClass . '">Trimming</a>';
print '</div>';

print '<div class="pl-timeline-controls">';
print '<label>Days: ';
print '<select id="plTimelineDays" onchange="plTimelineChangeDays(this.value)">';
foreach (array(7, 14, 21, 30) as $d) {
    $sel = ($days === $d) ? ' selected' : '';
    print '<option value="' . $d . '"' . $sel . '>' . $d . '</option>';
}
print '</select>';
print '</label>';
print '</div>';

print '</div>'; // header

// Main content: two-panel layout
print '<div class="pl-timeline-container">';

// Left panel: Job card (details of selected job)
print '<div class="pl-timeline-left" id="plJobCardPanel">';
print '<div class="pl-job-card" id="plJobCard">';
print '<div class="pl-job-card-placeholder">Select a job to view details</div>';
print '</div>';
print '</div>';

// Right panel: Timeline grid
print '<div class="pl-timeline-right" id="plTimelinePanel">';
print '<div class="pl-timeline-grid" id="plTimelineGrid">';
print '<div class="pl-timeline-loading">Loading timeline...</div>';
print '</div>';
print '</div>';

print '</div>'; // container

print '</div>'; // page

llxFooter();
