<?php
/**
 * Planning Board - shared rendering functions
 */

if (!function_exists('pl_status_badge')) {
    /**
     * Render status badge HTML
     */
    function pl_status_badge($status) {
        $map = array(
            0 => array('Draft','pl-status-draft'),
            1 => array('Validated','pl-status-validated'),
            2 => array('In progress','pl-status-inprogress'),
            3 => array('Produced','pl-status-produced'),
            9 => array('Cancelled','pl-status-cancelled'),
        );
        if (!isset($map[$status])) return '<span class="pl-status pl-status-unknown">?</span>';
        return '<span class="pl-status '.$map[$status][1].'">'.$map[$status][0].'</span>';
    }
}

if (!function_exists('pl_render_mo_card_html')) {
    /**
     * Render single MO card HTML
     *
     * @param array  $j        Job data array (from SQL result)
     * @param string $moLink   Pre-built MO link HTML
     * @param string $prodLink Pre-built product link HTML
     * @param string $jobLink  Pre-built job link HTML
     * @return string Card HTML
     */
    function pl_render_mo_card_html($j, $moLink, $prodLink, $jobLink)
    {
        $qty = (float)$j['qty'];
        $done = (float)$j['qty_done'];
        $left = max(0, $qty - $done);
        $pct = ($qty > 0) ? min(100, max(0, ($done / $qty) * 100)) : 0;

        $startTxt = $j['start'] ? dol_print_date($j['start'], 'dayhour') : '';
        $endTxt   = $j['end'] ? dol_print_date($j['end'], 'dayhour') : '';
        $duration = '';
        if (!empty($j['start']) && !empty($j['end'])) {
            $sec = ((int)$j['end']) - ((int)$j['start']);
            if ($sec > 0) $duration = convertSecondToTime($sec, 'allhourmin');
        } elseif (!empty($j['start']) && (int)$j['status'] === 2) {
            $sec = time() - ((int)$j['start']);
            if ($sec > 0) $duration = convertSecondToTime($sec, 'allhourmin');
        }

        // Late alert
        $isLate = false;
        $lateIcon = '';
        if (!in_array((int)$j['status'], array(3, 9)) && !empty($j['end']) && $j['end'] < time()) {
            $isLate = true;
            $lateTooltip = 'Late (planned end: '.dol_print_date($j['end'], 'dayhour').')';
            $lateIcon = ' <span class="classfortooltip pl-late-icon" title="'.dol_escape_htmltag($lateTooltip).'"><i class="fas fa-exclamation-triangle"></i></span>';
        }

        // Card class: late has priority, then status highlight
        $cardClass = 'pl-card';
        if ($isLate) {
            $cardClass .= ' pl-card-late';
        } elseif ((int)$j['status'] === 2) {
            $cardClass .= ' pl-card-inprogress';
        } elseif ((int)$j['status'] === 1) {
            $cardClass .= ' pl-card-validated';
        } elseif ((int)$j['status'] === 0) {
            $cardClass .= ' pl-card-draft';
        }
        $endTs = !empty($j['end']) ? (int)$j['end'] : 0;
        $html = '<div class="'.$cardClass.'" data-end="'.$endTs.'">';
        $html .= '<div class="pl-card-top">';
        $html .= '<div class="pl-card-mo">'.$moLink.$lateIcon.'</div>';
        $html .= '<div class="pl-card-status">'.pl_status_badge((int)$j['status']).'</div>';
        $html .= '</div>';

        $html .= '<div class="pl-card-prod">'.$prodLink.'</div>';
        $html .= '<div class="pl-card-job">Job: '.$jobLink.'</div>';

        $html .= '<div class="pl-card-nums">';
        $html .= '<div><span class="pl-k">Qty</span><span class="pl-v">'.dol_escape_htmltag((string)$qty).'</span></div>';
        $html .= '<div><span class="pl-k">Done</span><span class="pl-v">'.dol_escape_htmltag((string)$done).'</span></div>';
        $html .= '<div><span class="pl-k">Left</span><span class="pl-v">'.dol_escape_htmltag((string)$left).'</span></div>';
        $html .= '</div>';

        $html .= '<div class="pl-progress"><div class="pl-progress-bar" style="width:'.((int)$pct).'%"></div></div>';

        $html .= '<div class="pl-card-times">';
        if ($startTxt) $html .= '<span>'.$startTxt.'</span>';
        if ($endTxt) $html .= '<span>→ '.$endTxt.'</span>';
        if ($duration) $html .= '<span class="pl-card-dur pl-dur">'.$duration.'</span>';
        $html .= '</div>';

        $html .= '</div>';

        return $html;
    }
}
