# Planning – Dolibarr Module

## Overview

**Planning** is a custom module for **Dolibarr ERP** focused on Manufacturing Resource Planning (MRP).
It provides clear, production‑ready planning views for Manufacturing Orders (MO), with the **Planning Board** as the primary interface.

The module is designed for real production use:
- minimal magic
- predictable behavior
- UI aligned with Dolibarr core

---

## Main Features

### Planning Board (Primary View)
- Board / Kanban‑style layout grouped by **Workstation**
- Server‑rendered HTML with AJAX auto‑refresh
- Fullscreen mode with dark theme
- Sticky workstation headers
- Responsive behavior (desktop‑first, usable on mobile)

### Late Order Visibility
- Late / overdue indicator on MO cards (Dolibarr‑style icon)
- Tooltip with planned end date
- Backend‑calculated (single source of truth)
- Optional **Late only** filter (frontend)

### UX & Stability
- Auto‑refresh without breaking tooltips
- Scroll works correctly in fullscreen mode
- Scrollbars hidden in fullscreen (scroll still enabled)
- Top bar layout adapts correctly to browser zoom (e.g. 150%)

---

## Architecture

### Rendering Model
- **Server‑rendered HTML**
- `board_data.php` returns:
  ```json
  {
    "clock": "...",
    "html": "<div>...</div>"
  }
  ```
- JavaScript replaces board DOM and re‑initializes tooltips

> ⚠️ This is intentional.  
> Do not refactor to a pure JSON renderer unless explicitly required.

### Data Sources
- `llx_mrp_mo`
- `llx_mrp_mo_extrafields` (job_number, working_station)
- `llx_workstation_workstation` (preferred workstation lookup)
- `llx_product`, `llx_stock_mouvement`, `llx_bom_bom`

Workstation context belongs to **columns**, not MO cards.

---

## Directory Structure

```
planning/
├── board.php
├── board_data.php
├── planning.php
├── completed.php
├── core/modules/modPlanning.class.php
├── css/
│   ├── board.css
│   └── planning.css
├── js/
│   └── board.js
├── CLAUDE.md
├── README.md
└── CHANGELOG.md
```

---

## Permissions

- Requires: `$user->rights->planning->read`
- All pages and AJAX endpoints enforce access control

---

## Development Notes

- PHP 7.3+
- Vanilla JavaScript (ES5 compatible)
- No npm / Composer / build steps
- Designed to run from `/custom/planning/`

For development rules and architectural constraints, see **CLAUDE.md**.

---

## Status

This module is actively used and incrementally improved.
All recent features focus on **usability, stability, and production readiness**.
