# ChangeLog – Planning Module

All notable changes to this module are documented here.

---

## [1.2.1] – 2026-01-17

### Added
- Late / overdue indicator on MO cards (Dolibarr-style icon)
- Tooltip with planned end date (Dolibarr look & feel)
- Frontend filter: **Late only**
- Sticky workstation headers on Planning Board

### Improved
- Fullscreen Planning Board usability (dark mode)
- Scroll handling in fullscreen mode
- Hidden scrollbars in fullscreen (scroll preserved)
- Top bar layout resilience at high browser zoom levels (e.g. 150%)

### Changed
- Planning Board set as the default entry point from Dolibarr top menu
- Unified MO card rendering between `board.php` and `board_data.php`

### Fixed
- Fullscreen scroll blocking
- Tooltip re-initialization after auto-refresh
- Layout breakage in fullscreen mode

---

## [1.2.0] – 2026-01-16

### Added
- Fullscreen Planning Board mode
- Auto-refresh with countdown
- Dark theme for fullscreen view

### Improved
- Board stability during refresh
- Tooltip reliability

---

## [1.0.0] – Initial Release

### Added
- Planning table view grouped by workstation
- Initial Planning Board implementation
- Completed MOs view

---

## Known limitations / Technical notes

- The Planning Board uses **server-rendered HTML** with AJAX DOM replacement.
  This is intentional and aligned with Dolibarr architecture.
  Do not refactor to a JSON-only renderer unless explicitly required.

- Auto-refresh replaces board HTML entirely.
  Any UI state must be explicitly restored in JavaScript if persistence is required.

- Workstation information comes from `llx_mrp_mo_extrafields.working_station`
  and may be either an ID or free-text value, depending on data quality.

- Sticky headers rely on a single scroll container.
  Introducing additional nested scroll areas may break expected behavior.

- The module is designed for **desktop-first usage**.
  Mobile usage is supported but simplified.

---
