# Step-by-Step: Enable Debug Mode for POST add_job.php

## Quick Test (5 minutes)

### Step 1: Locate timeline.php
File: [timeline.php](timeline.php)

### Step 2: Find the endpoint definition
Look for line ~100, you'll find:
```php
$addJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/add_job.php';
```

### Step 3: Add ?debug=1
Change it to:
```php
$addJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/add_job.php?debug=1';
```

### Step 4: Save file

### Step 5: Refresh your browser
- Go to the planning timeline page
- Press `F5` or `Ctrl+Shift+R` (hard refresh to clear JS cache)

### Step 6: Test
- Click "Add Job" button
- Try to submit form with invalid data (e.g., product with no rate)
- You should see error + debug info in the modal

### Step 7: Disable when done
Remove `?debug=1` from the URL when testing is complete:
```php
$addJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/add_job.php';
```
Save and refresh.

---

## Verify It's Working

### During Testing (with debug enabled):

**Modal should show:**
```
Product rate (qty_per_hour_form) is not configured or is invalid. 
Please set the production rate for this product.

Debug Info:
  Message: Product rate (qty_per_hour_form) is not configured...
  File: /custom/planning/ajax/add_job.php
  Line: 313
  DB Error:
```

**Browser Network tab (F12 → Network) should show:**
```json
{
  "error": "Product rate (qty_per_hour_form) is not configured...",
  "debug_message": "Product rate (qty_per_hour_form) is not configured...",
  "debug_file": "/custom/planning/ajax/add_job.php",
  "debug_line": 313,
  "db_error": null
}
```

### After Disabling Debug (without ?debug=1):

**Modal should show only:**
```
Product rate (qty_per_hour_form) is not configured or is invalid. 
Please set the production rate for this product.
```

**Browser Network tab should show:**
```json
{
  "error": "Product rate (qty_per_hour_form) is not configured..."
}
```

---

## Find the Line in timeline.php

### Method 1: Using Search/Find
1. Open [timeline.php](timeline.php) in your editor
2. Press `Ctrl+F` (Find)
3. Search for: `add_job.php`
4. You'll find it around line 100

### Method 2: Look for the section
Look for a section that defines endpoints:
```php
$tlEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/timeline_data.php';
$addJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/add_job.php';
$updateJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/update_job.php';
$deleteJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/delete_job.php';
```

---

## Exact Code to Change

### Before:
```php
$tlEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/timeline_data.php';
$addJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/add_job.php';
$updateJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/update_job.php';
$deleteJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/delete_job.php';
print '<div class="pl-timeline-page" id="plTimelinePage"';
print ' data-group="' . dol_escape_htmltag($group) . '"';
print ' data-days="' . (int)$days . '"';
print ' data-endpoint="' . dol_escape_htmltag($tlEndpoint) . '"';
print ' data-addjob-endpoint="' . dol_escape_htmltag($addJobEndpoint) . '"';
```

### After (ADD `?debug=1`):
```php
$tlEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/timeline_data.php';
$addJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/add_job.php?debug=1';
$updateJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/update_job.php';
$deleteJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/delete_job.php';
print '<div class="pl-timeline-page" id="plTimelinePage"';
print ' data-group="' . dol_escape_htmltag($group) . '"';
print ' data-days="' . (int)$days . '"';
print ' data-endpoint="' . dol_escape_htmltag($tlEndpoint) . '"';
print ' data-addjob-endpoint="' . dol_escape_htmltag($addJobEndpoint) . '"';
```

**Only change:** Add `?debug=1` to `$addJobEndpoint` line (line ~100)

---

## Browser Cache Clearing

If changes don't appear, you may need to clear browser cache:

### Chrome/Edge:
1. Press `Ctrl+Shift+Delete`
2. Select "All time"
3. Check "Cookies and other site data" + "Cached images and files"
4. Click "Clear data"

### Firefox:
1. Press `Ctrl+Shift+Delete`
2. Select timeframe "Everything"
3. Check desired boxes
4. Click "Clear Now"

### Or simple hard refresh:
- **Windows:** `Ctrl+Shift+R`
- **Mac:** `Cmd+Shift+R`

---

## Troubleshooting

### Still no debug info?
1. Confirm `?debug=1` is in the code
2. Confirm page was refreshed (F5, not just back button)
3. Confirm you're on the planning timeline page
4. Check browser console (F12 → Console) for fetch errors

### Can't find the line in timeline.php?
1. Open timeline.php
2. Use Ctrl+F to search for `add_job.php`
3. Should find it within first 150 lines

### Debug appears but want to remove it?
1. Remove `?debug=1` from the line
2. Save file
3. Refresh page (F5)
4. Should now show only user-friendly error

---

## What NOT to Do

❌ Don't edit [ajax/add_job.php](ajax/add_job.php) - already done  
❌ Don't add debug=1 to other endpoints (not needed for testing)  
❌ Don't leave debug enabled in production (remove ?debug=1)  
❌ Don't commit to version control with debug=1 (temporary only)  

---

## After Testing

When you're done debugging, remember to:

1. **Remove `?debug=1` from timeline.php:**
```php
$addJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/add_job.php';
```

2. **Save and refresh** to verify debug info is gone

3. **Verify error message is still user-friendly** (just without file/line)

---

## Alternative: Permanent Config

If you want debug enabled all the time (not recommended for production):

In your Dolibarr `config.php` or module setup:
```php
$conf->global->PLANNING_DEBUG = 1;
```

This enables debug globally without editing timeline.php.

To disable:
```php
$conf->global->PLANNING_DEBUG = 0;
```

---

## Summary

| Step | Action | File |
|------|--------|------|
| 1 | Find line with `add_job.php` | [timeline.php](timeline.php) ~line 100 |
| 2 | Add `?debug=1` to the URL | Change 1 line |
| 3 | Save file | Ctrl+S |
| 4 | Refresh browser | F5 or Ctrl+Shift+R |
| 5 | Test modal form | Click "Add Job" |
| 6 | Verify debug info | Should see file/line/db_error |
| 7 | When done, remove `?debug=1` | Back to original |
| 8 | Refresh browser again | F5 |

**Total time:** ~5 minutes

---

## Video Walkthrough (Text)

1. **You:** Click "Add Job" button in planning timeline
2. **System:** Modal appears with empty form
3. **You:** Enter invalid data (product without rate configured)
4. **You:** Click "Add Job" button in modal
5. **System:** Form submits to `/ajax/add_job.php?debug=1`
6. **System:** Backend catches error, returns JSON with debug info
7. **System:** JavaScript receives response, parses it
8. **You:** Modal error div updates with message + debug info
9. **You:** You see exactly which file and line the error occurred
10. **Result:** ✅ Problem identified in seconds instead of minutes

---

## Need Help?

- **Setup steps:** See this file (you're reading it!)
- **What changed:** See [MINIMAL_DIFF.md](MINIMAL_DIFF.md)
- **Example output:** See [DEBUG_EXAMPLES.md](DEBUG_EXAMPLES.md)
- **Full reference:** See [DEBUG_GUIDE.md](DEBUG_GUIDE.md)
- **Quick overview:** See [QUICK_START.md](QUICK_START.md)

---

## Next Phase (After Testing)

Once you've verified the debug setup works:

1. Test various error conditions (missing product, no rate, etc.)
2. Verify server logs capture the errors
3. Disable debug (?debug=1 removal)
4. Deploy to production (without ?debug=1)
5. Consider applying same pattern to other AJAX endpoints

---

**Ready?** Open [timeline.php](timeline.php), find line ~100, add `?debug=1`, save, refresh, and test! 🎯
