# Quick Reference: Debug POST /ajax/add_job.php

## TL;DR - Enable Debug in 30 Seconds

Edit **[timeline.php](timeline.php)** around line **100** and change:
```php
$addJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/add_job.php?debug=1';
```

Refresh page. Try submitting the modal form with an error condition.

**You'll now see:**
- Error message in modal
- Debug file path
- Debug line number  
- Database error (if any)

---

## What Changed

### PHP Backend
- **File:** [ajax/add_job.php](ajax/add_job.php)
- **What:** Error handlers now return structured JSON with file/line/db_error fields when POST + debug
- **Lines:** 57-97 (exception handler), 99-135 (shutdown), 381-407 (main catch)

### JavaScript Frontend  
- **File:** [js/timeline.js](js/timeline.js)
- **What:** Form error display now shows debug info if present
- **Lines:** 1150-1169

---

## Response Examples

### With Debug (?debug=1)
```json
{
  "error": "Product rate is not configured",
  "debug_message": "Product rate (qty_per_hour_form) is not configured...",
  "debug_file": "/custom/planning/ajax/add_job.php",
  "debug_line": 313,
  "db_error": null
}
```

### Without Debug (production)
```json
{
  "error": "Product rate is not configured"
}
```

---

## Enable Methods

| Method | Where | How |
|--------|-------|-----|
| Temporary | For current session | Add `?debug=1` to URL in timeline.php |
| Persistent | Global config | Set `$conf->global->PLANNING_DEBUG = 1;` |
| Admin | Auto | Any admin user sees debug automatically |

---

## Security Notes

✅ Debug shows only for **POST** (GET always hidden)  
✅ Must be **explicitly enabled**  
✅ CSRF token **still required**  
✅ Errors **always logged** server-side  
✅ No database changes  

---

## Server Logs

All errors logged to: `/documents/dolibarr.log`

View:
```bash
tail -f /var/www/dolibarr/documents/dolibarr.log | grep "Planning"
```

---

## Files

| Document | Purpose |
|----------|---------|
| [IMPLEMENTATION_SUMMARY.md](IMPLEMENTATION_SUMMARY.md) | Overview & checklist |
| [MINIMAL_DIFF.md](MINIMAL_DIFF.md) | Exact code changes |
| [DEBUG_EXAMPLES.md](DEBUG_EXAMPLES.md) | Real example output |
| [DEBUG_GUIDE.md](DEBUG_GUIDE.md) | Complete reference |

---

## Test It

1. Edit [timeline.php](timeline.php) - add `?debug=1` to endpoint
2. Refresh page
3. Open planning modal
4. Try to add job with product that has no rate configured
5. **Should see error + debug info in modal**

---

## Disable Debug

Remove `?debug=1` from URL or set:
```php
$conf->global->PLANNING_DEBUG = 0;
```

Server logs still show full error detail.
