# Minimal Diff - POST Debug Implementation

## File 1: ajax/add_job.php

### Change 1: Exception Handler (Line 57-97)
```diff
// Global exception handler
set_exception_handler(function($ex) {
    global $db, $user;
    $msg = "Exception: " . $ex->getMessage() . " in " . $ex->getFile() . ":" . $ex->getLine();
    dol_syslog('Planning Add Job: ' . $msg, LOG_ERR);
    
    // Log stack trace
    if (!empty($ex->getTraceAsString())) {
        dol_syslog('Planning Add Job: Stack trace: ' . $ex->getTraceAsString(), LOG_ERR);
    }
    
    // Log DB error if applicable
-   if (!empty($db)) {
+   $dbErr = '';
+   if (!empty($db)) {
        $dbErr = $db->lasterror();
        if (!empty($dbErr)) {
            dol_syslog('Planning Add Job: DB error: ' . $dbErr, LOG_ERR);
        }
    }
    
    ob_clean();
    http_response_code(500);
    
    $response = [
        'success' => false,
-       'error' => 'Server error processing request'
+       'error' => $ex->getMessage()
    ];
    
-   // Include debug info if enabled
-   if (isDebugMode()) {
-       $response['debug'] = $ex->getMessage() . ' @ ' . $ex->getFile() . ':' . $ex->getLine();
+   // Include debug info if enabled and POST request
+   if ($_SERVER['REQUEST_METHOD'] === 'POST' && isDebugMode()) {
+       $response['debug_message'] = $ex->getMessage();
+       $response['debug_file'] = $ex->getFile();
+       $response['debug_line'] = $ex->getLine();
        if (!empty($db)) {
-           $dbErr = $db->lasterror();
            if (!empty($dbErr)) {
                $response['db_error'] = $dbErr;
            }
        }
    }
    
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit;
});
```

### Change 2: Shutdown Handler (Line 99-135)
```diff
// Shutdown handler - catch any fatal errors
register_shutdown_function(function() {
    global $db, $user;
    $error = error_get_last();
    if ($error !== null && ($error['type'] & (E_ERROR | E_PARSE | E_CORE_ERROR | E_COMPILE_ERROR))) {
        $msg = "Fatal Error [" . $error['type'] . "] in " . $error['file'] . ":" . $error['line'] . " - " . $error['message'];
        dol_syslog('Planning Add Job: ' . $msg, LOG_ERR);
+       
+       $dbErr = '';
        if (!empty($db)) {
            $dbErr = $db->lasterror();
            if (!empty($dbErr)) {
                dol_syslog('Planning Add Job: DB error: ' . $dbErr, LOG_ERR);
            }
        }
         ob_clean();
        http_response_code(500);
        
        $response = [
            'success' => false,
-           'error' => 'Server error processing request'
+           'error' => $error['message']
        ];
        
-       // Include debug info if enabled
-       if (isDebugMode()) {
-           $response['debug'] = $error['message'] . ' @ ' . $error['file'] . ':' . $error['line'];
+       // Include debug info if enabled and POST request
+       if ($_SERVER['REQUEST_METHOD'] === 'POST' && isDebugMode()) {
+           $response['debug_message'] = $error['message'];
+           $response['debug_file'] = $error['file'];
+           $response['debug_line'] = $error['line'];
            if (!empty($db)) {
-               $dbErr = $db->lasterror();
                if (!empty($dbErr)) {
                    $response['db_error'] = $dbErr;
                }
            }
        }
        
        echo json_encode($response, JSON_UNESCAPED_UNICODE);
    }
});
```

### Change 3: Main Try-Catch (Line 381-407)
```diff
} catch (Exception $e) {
    $db->rollback();
+   
+   $errorMsg = $e->getMessage();
+   $errorFile = $e->getFile();
+   $errorLine = $e->getLine();
+   
+   // Log full error details
+   dol_syslog('Planning Add Job Error: ' . $errorMsg . ' in ' . $errorFile . ':' . $errorLine, LOG_ERR);
+   $dbErr = !empty($db) ? $db->lasterror() : '';
+   if (!empty($dbErr)) {
+       dol_syslog('Planning Add Job DB Error: ' . $dbErr, LOG_ERR);
+   }
+   
-   outputJson(array('error' => $e->getMessage()), 500);
+   $response = array('error' => $errorMsg);
+   
+   // Include debug details if debug mode is enabled
+   if (isDebugMode()) {
+       $response['debug_message'] = $errorMsg;
+       $response['debug_file'] = $errorFile;
+       $response['debug_line'] = $errorLine;
+       if (!empty($dbErr)) {
+           $response['db_error'] = $dbErr;
+       }
+   }
+   
+   outputJson($response, 500);
}
```

---

## File 2: js/timeline.js

### Change: Form Submit Handler (Line 1150-1169)
```diff
    .then(function(data) {
      if (data.error) {
-       if (errorDiv) errorDiv.textContent = data.error;
+       var errorMsg = data.error;
+       // Append debug info if available
+       if (data.debug_message || data.debug_file) {
+         errorMsg += '\n\nDebug Info:\n';
+         if (data.debug_message) errorMsg += '  Message: ' + data.debug_message + '\n';
+         if (data.debug_file) errorMsg += '  File: ' + data.debug_file + '\n';
+         if (data.debug_line) errorMsg += '  Line: ' + data.debug_line + '\n';
+         if (data.db_error) errorMsg += '  DB Error: ' + data.db_error + '\n';
+       }
+       if (errorDiv) errorDiv.textContent = errorMsg;
        return;
      }
      if (!data.success) {
        if (errorDiv) errorDiv.textContent = 'Unknown error occurred';
        return;
      }
      // Success - close modal and refresh timeline
      closeAddJobModal();
      fetchTimeline();
    })
```

---

## How to Apply Debug Mode

### Quick Test (Temporary)
In [timeline.php](timeline.php) around line 100, change:
```php
$addJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/add_job.php?debug=1';
```

### Permanent Admin Setting
In your Dolibarr config or module setup:
```php
$conf->global->PLANNING_DEBUG = 1;
```

### Per-User (Admin Only)
No code change needed—admin users get debug automatically.
