# Change: Default Timeline View → Gantt Mode

## Objective
Set Gantt as the **DEFAULT** display mode for Timeline instead of normal (capacity) mode.

## Changes Made

### 1. PHP Backend: `timeline.php`
**Line 26** - Changed default fallback when invalid `?gantt` parameter:
```diff
- $ganttMode = 0;  // Was: default to normal mode
+ $ganttMode = 1;  // Now: default to Gantt mode
```

**Context:**
- `$ganttMode = (int) GETPOST('gantt', 'int');` reads URL parameter
- Validation ensures only 0 or 1 are allowed
- Invalid/missing values now default to 1 (Gantt) instead of 0 (normal)

### 2. JavaScript Frontend: `js/timeline.js`
**Line 73** - Changed JavaScript fallback:
```diff
- config.ganttMode = parseInt(el.dataset.ganttMode, 10) || 0;
+ config.ganttMode = parseInt(el.dataset.ganttMode, 10) || 1;
```

**Context:**
- Reads `data-gantt-mode` attribute set by PHP
- Fallback now defaults to 1 (Gantt) if attribute is missing/invalid
- Used by `renderTimeline()` at line 275 to choose between Gantt and normal renderers

## Behavior After Change

| Scenario | Behavior |
|----------|----------|
| Timeline page load (no URL params) | ✅ Renders **Gantt mode** (default) |
| `?gantt=1` in URL | ✅ Renders Gantt mode (explicit) |
| `?gantt=0` in URL | ✅ Renders **Normal mode** (explicit fallback) |
| `?view=normal` (future param) | ⚠️ Requires additional handling if needed |

## Code Preserved
- ✅ Normal mode rendering logic (`renderMachineRow()`) - **untouched**
- ✅ Gantt mode rendering logic (`renderMachineRowGantt()`) - **untouched**
- ✅ Mode selection logic in `renderTimeline()` - **untouched**
- ✅ Layout, CSS, scrolling - **unchanged**
- ✅ Add Job modal - **unchanged**

## Validation Checklist
- ✅ Minimal diff (2 changes, 2 lines modified)
- ✅ Default is now Gantt mode
- ✅ `?gantt=0` still works to switch to normal mode
- ✅ `?gantt=1` still explicitly works
- ✅ No code removed
- ✅ No CSS/layout changes
- ✅ No cookies/session logic added (as required)

## Files Modified
1. `timeline.php` (1 line)
2. `js/timeline.js` (1 line)
