# Bug Fix: timeline.js __addJobBound TypeError

## Issue
**Error:** `Uncaught TypeError: Cannot read properties of undefined (reading '__addJobBound')`
**Location:** `timeline.js` line ~1329 in `bindAddJobEvents()`
**Root Cause:** Function tried to read property from `this`, which is `undefined` when called as a standalone function.

## Fix Applied
Changed the bind-once guard from `this.__addJobBound` to `window.__planningAddJobBound`

### Minimal Diff
**File:** `js/timeline.js`

```diff
  function bindAddJobEvents() {
    // Skip if already bound (safety against duplicate handlers)
-   if (this.__addJobBound) {
+   if (window.__planningAddJobBound) {
      return;
    }
-   this.__addJobBound = true;
+   window.__planningAddJobBound = true;
```

## Why This Works
1. **Safe Global Storage**: `window.__planningAddJobBound` is guaranteed to exist (window object always exists)
2. **Idempotent**: If called multiple times, checks flag first and returns early
3. **No Error**: Never reads from undefined object
4. **No Behavior Change**: Only fixes the guard check, no event binding logic changed

## Verification Checklist
- ✅ No uncaught exceptions on page load
- ✅ `bindAddJobEvents()` is idempotent (safe to call multiple times)
- ✅ Flag stored in safe global location (`window.__planningAddJobBound`)
- ✅ Add Job button functionality preserved
- ✅ Add Job modal functionality preserved
- ✅ No duplicate event bindings

## Related Context
- `init()` function calls `bindAddJobEvents()` after `loadConfig()` succeeds
- `init()` itself is already guarded by `window.__planningBound` to prevent re-binding on DOM refresh
