<?php
// custom/planning/ajax/search_products.php
// AJAX endpoint for autocomplete product search

require_once '../../../main.inc.php';
require_once DOL_DOCUMENT_ROOT . '/product/class/product.class.php';

global $db, $conf, $user;

header('Content-Type: application/json');

try {
    // Get search query
    $q = GETPOST('q', 'alpha');
    
    if (empty($q) || strlen($q) < 2) {
        echo json_encode(array(
            'success' => false,
            'error' => 'Query must be at least 2 characters'
        ));
        exit;
    }
    
    // Build query
    $sql = "SELECT rowid, ref, label FROM " . MAIN_DB_PREFIX . "product";
    $sql .= " WHERE entity = " . (int)$conf->entity;
    $sql .= " AND fk_product_type = 0";  // Finished goods only
    $sql .= " AND (ref LIKE '%" . $db->escape($q) . "%' OR label LIKE '%" . $db->escape($q) . "%')";
    $sql .= " ORDER BY (ref LIKE '" . $db->escape($q) . "%') DESC, ref ASC";
    $sql .= " LIMIT 20";
    
    $res = $db->query($sql);
    
    if ($res === false) {
        throw new Exception($db->lasterror());
    }
    
    $products = array();
    while ($obj = $db->fetch_object($res)) {
        $products[] = array(
            'id' => (int)$obj->rowid,
            'ref' => $obj->ref,
            'label' => $obj->label ? $obj->label : $obj->ref
        );
    }
    
    echo json_encode(array(
        'success' => true,
        'products' => $products
    ));
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(array(
        'success' => false,
        'error' => $e->getMessage()
    ));
}
