<?php
/**
 * Planning - Get Product Details AJAX endpoint
 * Returns product ref and label for display in UI
 *
 * Required GET parameters:
 *   id - product ID
 *
 * Returns JSON: {success, id, ref, label}
 */

require '../../../main.inc.php';

// Always return JSON
header('Content-Type: application/json; charset=utf-8');

/**
 * Output JSON response and exit.
 */
function outputJson($data, $code = 200)
{
    http_response_code($code);
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}

// Get product ID
$product_id = GETPOST('id', 'int');
if (empty($product_id) || $product_id <= 0) {
    outputJson(array('error' => 'Missing or invalid product id.'), 400);
}

// Load product
require_once(DOL_DOCUMENT_ROOT . '/product/class/product.class.php');
$product = new Product($db);
$res = $product->fetch((int)$product_id);
if ($res <= 0) {
    outputJson(array('error' => 'Product not found.'), 404);
}

// Return product data
outputJson(array(
    'success' => true,
    'id' => (int) $product->id,
    'ref' => $product->ref,
    'label' => $product->label
), 200);
