<?php
/**
 * Planning - Get Job Details AJAX endpoint
 * Returns minimal job data (fk_product, etc.) needed for Edit form prefill
 *
 * Required GET parameters:
 *   id - job ID
 *
 * Returns JSON: {success, fk_product, qty, group_code, date_start, ...}
 */

require '../../../main.inc.php';

// Always return JSON
header('Content-Type: application/json; charset=utf-8');

/**
 * Output JSON response and exit.
 */
function outputJson($data, $code = 200)
{
    http_response_code($code);
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}

// Get job ID
$job_id = GETPOST('id', 'int');
if (empty($job_id) || $job_id <= 0) {
    outputJson(array('error' => 'Missing or invalid job id.'), 400);
}

// Fetch job from database
$sql = "SELECT rowid, fk_product, qty, group_code, date_start, date_end, status, notes FROM " . MAIN_DB_PREFIX . "planning_job WHERE rowid = " . (int) $job_id;
$res = $db->query($sql);
if (!$res || !($job = $db->fetch_object($res))) {
    outputJson(array('error' => 'Job not found.'), 404);
}

// Return job data
outputJson(array(
    'success' => true,
    'fk_product' => (int) $job->fk_product,
    'qty' => (float) $job->qty,
    'group_code' => $job->group_code,
    'date_start' => $job->date_start,
    'date_end' => $job->date_end,
    'status' => $job->status,
    'notes' => $job->notes
), 200);
