<?php
/**
 * Add Planning Job - Simple form (Forming only)
 */

require '../../main.inc.php';

if (empty($user->rights->planning) || empty($user->rights->planning->read)) {
    accessforbidden();
}

$langs->loadLangs(array('main'));

$action = GETPOST('action', 'aZ09');
$error = '';
$success = '';

// Handle form submission
if ($action === 'add') {
    $fk_workstation = (int) GETPOST('fk_workstation', 'int');
    $estimated_hours = (float) GETPOST('estimated_hours', 'alpha');
    $fg = GETPOST('fg', 'alphanohtml');
    $works_order_no = GETPOST('works_order_no', 'alphanohtml');
    $pack_number = GETPOST('pack_number', 'alphanohtml');

    // Minimal validation
    if ($fk_workstation <= 0) {
        $error = 'Please select a workstation.';
    } elseif ($estimated_hours <= 0) {
        $error = 'Please enter estimated hours (> 0).';
    }

    if (empty($error)) {
        // Get next sort_order for this workstation
        $sqlMax = "SELECT COALESCE(MAX(sort_order), 0) + 1 as next_sort
                   FROM " . MAIN_DB_PREFIX . "planning_job
                   WHERE fk_workstation = " . (int) $fk_workstation;
        $resMax = $db->query($sqlMax);
        $nextSort = 1;
        if ($resMax && ($objMax = $db->fetch_object($resMax))) {
            $nextSort = (int) $objMax->next_sort;
        }

        // Insert job
        $sql = "INSERT INTO " . MAIN_DB_PREFIX . "planning_job (
                    fk_workstation, estimated_hours, fg, works_order_no, pack_number,
                    group_code, status, sort_order, entity, fk_user_creat
                ) VALUES (
                    " . (int) $fk_workstation . ",
                    " . (float) $estimated_hours . ",
                    '" . $db->escape($fg) . "',
                    '" . $db->escape($works_order_no) . "',
                    '" . $db->escape($pack_number) . "',
                    'forming',
                    'planned',
                    " . (int) $nextSort . ",
                    " . (int) $conf->entity . ",
                    " . (int) $user->id . "
                )";

        $result = $db->query($sql);
        if ($result) {
            header('Location: ' . DOL_URL_ROOT . '/custom/planning/timeline.php?group=forming');
            exit;
        } else {
            $error = 'Database error: ' . $db->lasterror();
        }
    }
}

// Load forming workstations
$workstations = array();
$wsTables = array(
    MAIN_DB_PREFIX . 'workstation_workstation',
    MAIN_DB_PREFIX . 'workstation',
    MAIN_DB_PREFIX . 'mrp_workstation',
);
foreach ($wsTables as $tbl) {
    $sqlChk = "SELECT 1 FROM information_schema.TABLES
               WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = '" . $db->escape($tbl) . "'";
    $resChk = $db->query($sqlChk);
    if ($resChk && $db->fetch_object($resChk)) {
        $sqlWs = "SELECT rowid, ref, label FROM " . $tbl . "
                  WHERE LOWER(label) LIKE '%form%' OR LOWER(ref) LIKE '%form%'
                  ORDER BY ref ASC";
        $resWs = $db->query($sqlWs);
        if ($resWs) {
            while ($ws = $db->fetch_object($resWs)) {
                $workstations[$ws->rowid] = $ws->label ? $ws->label : $ws->ref;
            }
        }
        break;
    }
}

llxHeader('', 'Add Planning Job');

print '<div class="fichecenter">';
print '<div class="fichethirdleft">';

print '<form method="POST" action="' . $_SERVER['PHP_SELF'] . '">';
print '<input type="hidden" name="token" value="' . newToken() . '">';
print '<input type="hidden" name="action" value="add">';

print '<table class="border centpercent">';
print '<tr class="liste_titre"><td colspan="2">Add Planning Job (Forming)</td></tr>';

if ($error) {
    print '<tr><td colspan="2"><div class="error">' . dol_escape_htmltag($error) . '</div></td></tr>';
}

// Workstation
print '<tr>';
print '<td class="titlefield fieldrequired">Workstation</td>';
print '<td><select name="fk_workstation" class="flat minwidth200" required>';
print '<option value="">-- Select --</option>';
foreach ($workstations as $id => $label) {
    $sel = (GETPOST('fk_workstation', 'int') == $id) ? ' selected' : '';
    print '<option value="' . (int) $id . '"' . $sel . '>' . dol_escape_htmltag($label) . '</option>';
}
print '</select></td>';
print '</tr>';

// Estimated hours
print '<tr>';
print '<td class="fieldrequired">Estimated Hours</td>';
print '<td><input type="number" name="estimated_hours" step="0.1" min="0.1" class="flat" required';
print ' value="' . dol_escape_htmltag(GETPOST('estimated_hours', 'alpha')) . '"></td>';
print '</tr>';

// FG
print '<tr>';
print '<td>FG</td>';
print '<td><input type="text" name="fg" class="flat minwidth200"';
print ' value="' . dol_escape_htmltag(GETPOST('fg', 'alphanohtml')) . '"></td>';
print '</tr>';

// Works Order No
print '<tr>';
print '<td>Works Order No</td>';
print '<td><input type="text" name="works_order_no" class="flat minwidth200"';
print ' value="' . dol_escape_htmltag(GETPOST('works_order_no', 'alphanohtml')) . '"></td>';
print '</tr>';

// Pack Number
print '<tr>';
print '<td>Pack Number</td>';
print '<td><input type="text" name="pack_number" class="flat minwidth200"';
print ' value="' . dol_escape_htmltag(GETPOST('pack_number', 'alphanohtml')) . '"></td>';
print '</tr>';

print '</table>';

print '<br>';
print '<div class="center">';
print '<input type="submit" class="button" value="Add Job">';
print ' &nbsp; ';
print '<a class="button button-cancel" href="' . DOL_URL_ROOT . '/custom/planning/timeline.php?group=forming">Cancel</a>';
print '</div>';

print '</form>';

print '</div>';
print '</div>';

llxFooter();
