# Planning – Dolibarr Module

## Overview

**Planning** is a custom module for **Dolibarr ERP** focused on Manufacturing Resource Planning (MRP).
It provides visual planning views for Manufacturing Orders (MO) grouped by workstation.

The module is designed for real production use:
- Minimal magic
- Predictable behavior
- UI aligned with Dolibarr core

---

## Main Features

### Planning Board (Kanban)

Board / Kanban-style layout grouped by **Workstation**.

- View: `/custom/planning/board.php`
- Server-rendered HTML with AJAX auto-refresh
- Fullscreen mode with dark theme
- Sticky workstation headers
- Late / overdue indicator on MO cards
- Group filter: `forming` / `trimming`

### Planning Timeline (Gantt-like)

Horizontal timeline view showing jobs scheduled across multiple days per machine.

- View: `/custom/planning/timeline.php`
- Parameters: `group` (forming/trimming), `days` (7/14/21/30)
- Left panel: Job details card
- Right panel: Scrollable timeline grid

---

## Planning Timeline Concepts

### Planning Day Boundary

The planning day runs from **06:30 to 06:30** (next calendar day). This reflects shift patterns where work scheduled for a given date may extend past midnight.

Example: A job with `date_start = 2026-01-20 08:00` belongs to planning day `2026-01-20`.
A job with `date_start = 2026-01-21 04:00` still belongs to planning day `2026-01-20`.

### Capacity-Based Layout

Jobs are positioned based on workstation capacity, not precise time slots. Each day column shows jobs consuming available hours. This is a **capacity planning view**, not a true Gantt chart with hour-level precision.

Job block width is proportional to hours consumed relative to daily capacity.

### Add Job via Timeline

Users with `addjob` permission can create jobs directly from the Timeline:
- Click the "+ Add Job" button in the header (opens modal)
- Click directly on an empty day cell to prefill workstation and start date (06:30)

### Edit Job via Timeline

Users with `editjob` permission can modify jobs from the Timeline:
- Select a job block to view details in the left panel
- Click "Edit" to switch to edit mode
- Editable fields: workstation, group, status, dates, hours, notes
- Save submits via AJAX; Cancel reverts changes

---

## Permissions

| Permission | Key | Description |
|------------|-----|-------------|
| Read planning | `planning->read` | View Planning Board and Timeline |
| Add planning jobs | `planning->addjob` | Create new jobs from Timeline |
| Edit planning jobs | `planning->editjob` | Modify existing jobs from Timeline |

---

## Installation

1. Copy the `planning` folder to `htdocs/custom/planning/`
2. Enable the module in **Home > Setup > Modules/Applications**
3. Assign permissions to users/groups in **Users & Groups > Permissions**
4. Run database migrations if upgrading (check `sql/` folder)

---

## Database

Main table: `llx_planning_job`

Key columns:
- `fk_workstation` — linked workstation
- `group_code` — `forming` or `trimming`
- `estimated_hours` — planned duration
- `date_start`, `date_end` — scheduled time range
- `status` — `planned`, `in_progress`, `paused`, `completed`, `cancelled`
- `sort_order` — position within workstation queue

---

## Directory Structure

```
planning/
├── board.php              # Planning Board view
├── timeline.php           # Timeline view
├── planning.php           # Table view
├── completed.php          # Completed MOs view
├── ajax/
│   ├── timeline_data.php  # Timeline data endpoint
│   ├── add_job.php        # Add job endpoint
│   └── update_job.php     # Update job endpoint
├── class/
│   └── PlanningTimelineService.class.php
├── core/modules/
│   └── modPlanning.class.php
├── css/
│   ├── board.css
│   ├── planning.css
│   └── timeline.css
├── js/
│   ├── board.js
│   └── timeline.js
├── sql/
│   └── *.sql
├── CLAUDE.md
├── README.md
└── ChangeLog.md
```

---

## Roadmap

Future development directions (not yet implemented):

- **True Gantt**: Hour-level timeline with precise job positioning and drag-to-reschedule
- **Daily Planning**: Detailed shift-based scheduling view

---

## Version

Current version: **1.2.1**

See [ChangeLog.md](ChangeLog.md) for release history.

---

## Development Notes

- PHP 7.3+
- Vanilla JavaScript (ES5 compatible)
- No npm / Composer / build steps
- Designed to run from `/custom/planning/`

For development rules and architectural constraints, see **CLAUDE.md**.
