# ChangeLog – Planning Module

All notable changes to this module are documented here.

---

## [1.2.1] – 2026-01-17

### Added
- Late / overdue indicator on MO cards (Dolibarr-style icon)
- Tooltip with planned end date (Dolibarr look & feel)
- Frontend filter: **Late only**
- Sticky workstation headers on Planning Board

### Improved
- Fullscreen Planning Board usability (dark mode)
- Scroll handling in fullscreen mode
- Hidden scrollbars in fullscreen (scroll preserved)
- Top bar layout resilience at high browser zoom levels (e.g. 150%)

### Changed
- Planning Board set as the default entry point from Dolibarr top menu
- Unified MO card rendering between `board.php` and `board_data.php`

### Fixed
- Fullscreen scroll blocking
- Tooltip re-initialization after auto-refresh
- Layout breakage in fullscreen mode

---

## [1.2.0] – 2026-01-16

### Added
- Fullscreen Planning Board mode
- Auto-refresh with countdown
- Dark theme for fullscreen view

### Improved
- Board stability during refresh
- Tooltip reliability

---

## [1.0.0] – Initial Release

### Added
- Planning table view grouped by workstation
- Initial Planning Board implementation
- Completed MOs view

---

## Timeline Development (ETAPs)

### ETAP 2.4 — Timeline Layout & Scroll (CLOSED & FROZEN)

Two-panel layout for Planning Timeline:
- Left panel: Job details card (280px fixed)
- Right panel: Scrollable timeline grid
- Sticky machine column on horizontal scroll
- Sticky header row on vertical scroll
- Dynamic day column width (55–110px based on viewport)
- Compact mode for narrow columns
- Fixed double horizontal scrollbar issue
- CSS scoped to `.pl-timeline-page` (no Dolibarr menu interference)

### ETAP 3.0 — Add Job via Timeline Modal (CLOSED)

- Added `planning->addjob` permission
- "+ Add Job" button in Timeline header
- Modal form with fields: group, workstation, works order no, estimated hours, start, end, notes
- AJAX submission to `ajax/add_job.php`
- Timeline refresh on successful add
- CSRF token validation

### ETAP 3.1 — Add Job Stabilization (CLOSED)

- Improved error handling for non-JSON server responses
- Graceful fallback when server returns HTML errors
- Clear error messages in modal

### ETAP 3.2a — Add Job from Timeline Cell Click (CLOSED)

- Day cells in machine rows are clickable
- Click opens Add Job modal with prefilled values:
  - Workstation: from clicked row
  - Start date: clicked day at 06:30 (planning day boundary)
  - End date: auto-calculated from estimated hours
- Added `date_start` and `date_end` columns to `llx_planning_job`
- Job positioning based on `date_start` using planning day logic (06:30 → 06:30)
- Migration script: `sql/llx_planning_job_add_dates.sql`

### ETAP 3.2 — Edit Job via Timeline (CLOSED)

- Added `planning->editjob` permission
- Edit button in job card (view mode)
- Edit mode with form fields: workstation, group, status, estimated hours, start, end, notes
- Save/Cancel actions
- AJAX submission to `ajax/update_job.php`
- Timeline refresh on successful save

---

## Known Limitations / Technical Notes

- The Planning Board uses **server-rendered HTML** with AJAX DOM replacement.
  This is intentional and aligned with Dolibarr architecture.
  Do not refactor to a JSON-only renderer unless explicitly required.

- Auto-refresh replaces board HTML entirely.
  Any UI state must be explicitly restored in JavaScript if persistence is required.

- Workstation information comes from `llx_mrp_mo_extrafields.working_station`
  and may be either an ID or free-text value, depending on data quality.

- Timeline uses **capacity-based positioning**, not true Gantt.
  Jobs are shown per day based on hours consumed, not precise time slots.

- Planning day boundary is **06:30 → 06:30**.
  A datetime at 04:00 belongs to the previous planning day.

- Sticky headers rely on a single scroll container.
  Introducing additional nested scroll areas may break expected behavior.

- The module is designed for **desktop-first usage**.
  Mobile usage is supported but simplified.

---
