<?php
/**
 * Planning Timeline - Read-only visual timeline view
 * Displays jobs as blocks on a horizontal timeline per machine.
 */

require '../../main.inc.php';

if (empty($user->rights->planning) || empty($user->rights->planning->read)) {
    accessforbidden();
}

$langs->loadLangs(array('main', 'mrp', 'products'));

// Get parameters
$group = GETPOST('group', 'aZ09');
if (empty($group) || !in_array($group, array('forming', 'trimming'))) {
    $group = 'forming';
}
$days = (int) GETPOST('days', 'int');
if ($days < 1 || $days > 60) {
    $days = 14;
}

// Check addjob permission
$canAddJob = !empty($user->rights->planning->addjob);

// Load workstations if user can add jobs
$workstations = array();
if ($canAddJob) {
    $wsTables = array(
        MAIN_DB_PREFIX . 'workstation_workstation',
        MAIN_DB_PREFIX . 'workstation',
        MAIN_DB_PREFIX . 'mrp_workstation',
    );
    foreach ($wsTables as $tbl) {
        $sqlChk = "SELECT 1 FROM information_schema.TABLES
                   WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = '" . $db->escape($tbl) . "'";
        $resChk = $db->query($sqlChk);
        if ($resChk && $db->fetch_object($resChk)) {
            $sqlWs = "SELECT rowid, ref, label FROM " . $tbl . " ORDER BY ref ASC";
            $resWs = $db->query($sqlWs);
            if ($resWs) {
                while ($ws = $db->fetch_object($resWs)) {
                    $workstations[] = array(
                        'id' => (int) $ws->rowid,
                        'ref' => $ws->ref,
                        'label' => $ws->label ? $ws->label : $ws->ref
                    );
                }
            }
            break;
        }
    }
}

$morejs = array('/custom/planning/js/timeline.js');
$morecss = array('/custom/planning/css/timeline.css');

llxHeader('', 'Planning Timeline', '', '', 0, 0, $morejs, $morecss);

$tlEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/timeline_data.php';
$addJobEndpoint = DOL_URL_ROOT . '/custom/planning/ajax/add_job.php';
print '<div class="pl-timeline-page" id="plTimelinePage"';
print ' data-group="' . dol_escape_htmltag($group) . '"';
print ' data-days="' . (int)$days . '"';
print ' data-endpoint="' . dol_escape_htmltag($tlEndpoint) . '"';
print ' data-addjob-endpoint="' . dol_escape_htmltag($addJobEndpoint) . '"';
print ' data-token="' . newToken() . '"';
print ' data-can-addjob="' . ($canAddJob ? '1' : '0') . '"';
print '>';

// Title and tabs
print '<div class="pl-timeline-header">';
print '<h1 class="pl-timeline-title">Planning Timeline</h1>';

print '<div class="pl-timeline-tabs">';
$formingClass = ($group === 'forming') ? 'pl-tab-active' : '';
$trimmingClass = ($group === 'trimming') ? 'pl-tab-active' : '';
print '<a href="' . $_SERVER['PHP_SELF'] . '?group=forming&days=' . $days . '" class="pl-tab ' . $formingClass . '">Forming</a>';
print '<a href="' . $_SERVER['PHP_SELF'] . '?group=trimming&days=' . $days . '" class="pl-tab ' . $trimmingClass . '">Trimming</a>';
print '</div>';

print '<div class="pl-timeline-controls">';
if ($canAddJob) {
    print '<button type="button" class="pl-btn-add-job" id="plBtnAddJob">+ Add Job</button>';
}
print '<label>Days: ';
print '<select id="plTimelineDays" onchange="plTimelineChangeDays(this.value)">';
foreach (array(7, 14, 21, 30) as $d) {
    $sel = ($days === $d) ? ' selected' : '';
    print '<option value="' . $d . '"' . $sel . '>' . $d . '</option>';
}
print '</select>';
print '</label>';
print '</div>';

print '</div>'; // header

// Main content: two-panel layout
print '<div class="pl-timeline-container">';

// Left panel: Job card (details of selected job)
print '<div class="pl-timeline-left" id="plJobCardPanel">';
print '<div class="pl-job-card" id="plJobCard">';
print '<div class="pl-job-card-placeholder">Select a job to view details</div>';
print '</div>';
print '</div>';

// Right panel: Timeline grid
print '<div class="pl-timeline-right" id="plTimelinePanel">';
print '<div class="pl-timeline-grid" id="plTimelineGrid">';
print '<div class="pl-timeline-loading">Loading timeline...</div>';
print '</div>';
print '</div>';

print '</div>'; // container

print '</div>'; // page

// Add Job Modal (only if user has permission)
if ($canAddJob) {
    print '<div class="pl-modal-overlay" id="plAddJobModal">';
    print '<div class="pl-modal">';
    print '<div class="pl-modal-header">';
    print '<h2 class="pl-modal-title">Add Job</h2>';
    print '<button type="button" class="pl-modal-close" id="plModalClose">&times;</button>';
    print '</div>';
    print '<form id="plAddJobForm">';
    print '<div class="pl-modal-body">';

    // Group
    print '<div class="pl-form-group">';
    print '<label class="pl-form-label">Group</label>';
    print '<select name="group_code" id="plAddJobGroup" class="pl-form-input" required>';
    print '<option value="forming"' . ($group === 'forming' ? ' selected' : '') . '>Forming</option>';
    print '<option value="trimming"' . ($group === 'trimming' ? ' selected' : '') . '>Trimming</option>';
    print '</select>';
    print '</div>';

    // Workstation
    print '<div class="pl-form-group">';
    print '<label class="pl-form-label">Workstation *</label>';
    print '<select name="fk_workstation" id="plAddJobWorkstation" class="pl-form-input" required>';
    print '<option value="">-- Select --</option>';
    foreach ($workstations as $ws) {
        print '<option value="' . $ws['id'] . '">' . dol_escape_htmltag($ws['label']) . '</option>';
    }
    print '</select>';
    print '</div>';

    // Works Order No
    print '<div class="pl-form-group">';
    print '<label class="pl-form-label">Works Order No</label>';
    print '<input type="text" name="works_order_no" id="plAddJobWO" class="pl-form-input" placeholder="e.g. WO-12345">';
    print '</div>';

    // Estimated Hours
    print '<div class="pl-form-group">';
    print '<label class="pl-form-label">Estimated Hours</label>';
    print '<input type="number" name="estimated_hours" id="plAddJobHours" class="pl-form-input" step="0.1" min="0.1" value="1.0">';
    print '</div>';

    // Start datetime
    print '<div class="pl-form-group">';
    print '<label class="pl-form-label">Start</label>';
    print '<input type="datetime-local" name="date_start" id="plAddJobStart" class="pl-form-input">';
    print '</div>';

    // End datetime
    print '<div class="pl-form-group">';
    print '<label class="pl-form-label">End</label>';
    print '<input type="datetime-local" name="date_end" id="plAddJobEnd" class="pl-form-input">';
    print '</div>';

    // Notes
    print '<div class="pl-form-group">';
    print '<label class="pl-form-label">Notes</label>';
    print '<textarea name="notes" id="plAddJobNotes" class="pl-form-input" rows="2"></textarea>';
    print '</div>';

    // Error message area
    print '<div class="pl-form-error" id="plAddJobError"></div>';

    print '</div>'; // modal-body
    print '<div class="pl-modal-footer">';
    print '<button type="button" class="pl-btn pl-btn-cancel" id="plModalCancel">Cancel</button>';
    print '<button type="submit" class="pl-btn pl-btn-submit" id="plModalSubmit">Add Job</button>';
    print '</div>';
    print '</form>';
    print '</div>'; // modal
    print '</div>'; // overlay
}

llxFooter();
