# 🧾 Scrap Module - Change Log (Full)

All notable changes to the **Scrap Management** custom module are documented here.  
This changelog follows [Keep a Changelog](https://keepachangelog.com/en/1.0.0/)  
and adheres to [Semantic Versioning](https://semver.org/).

---

## [2.1.0] – 2025-10-24  
**Dolibarr Compatibility:** v17.x – v22.x  
**Author:** Marcin Flaumenhaft  
**Maintainer:** NÉOS Solutions Limited  

---

### ✨ Added

- **Search Functionality**
  - Added search box beside “Add Scrap” button.
  - Fully styled to match Dolibarr theme.
  - Includes “Reset Filter” for clearing search.

- **Pagination**
  - Displays only the last 20 scrap entries.
  - Pagination for older records using Dolibarr native style.

- **Total Cost Summary**
  - Automatic total cost calculation under scrap list.
  - Works dynamically with search and pagination.

- **Enhanced Deletion Confirmation**
  - Dolibarr-styled overlay confirmation box with full scrap details:
    - Product reference, Warehouse, Quantity, Cost, Reason, Date, Added by (initials).

- **Responsive Scrap Report Dashboard**
  - Added mobile-friendly layout using `scrap_report_responsive.css`.
  - Fully responsive for tablets and phones.

- **PDF Report Enhancements**
  - Monthly Summary shows all 12 months + total row.
  - Header/table colors unified with NEOS blue (#003399).
  - Added initials after date column in Detailed Scrap List.
  - Improved spacing, alignment, and typography consistency.

- **Full MRP / Stock Traceability**
  - End-to-end linkage between **Production → Consumption → Scrap → Revert Scrap**.
  - Integrated with MO (`mrp_mo`), Stock Movements, and `inventorycode` chain.

---

### 🧩 Modified

#### `scrap.class.php` – Core Logic

| Function | Description |
|-----------|--------------|
| `__construct($db)` | Initializes DB connection and entity context |
| `_getUserInitials($user)` | Returns initials for logging |
| `_showScrapMessage()` | Unified Dolibarr message handler |
| `create($user)` | Inserts scrap, decreases stock, updates MO |
| `delete($user, $id)` | Deletes scrap, restores stock, reverts MO qty |

- Safe transactions (`begin() / commit() / rollback()`).
- Unified messages using `_showScrapMessage()`.
- Proper `setOrigin()` usage for `MouvementStock`.
- Inherits `inventorycode` from original MO consumption.
- Synchronizes `mrp_mo.qty_scrap` values on create/delete.

---

#### `scrap_index.php`
- Added CSRF validation.
- Stock restoration via `MouvementStock::reception()`.
- Added detailed movement log description.
- Improved table alignment and total summary display.

#### `scrap_new.php`
- Simplified flow and success messages.
- Auto MO linkage by `fk_product`.
- Uses `dol_now()` for timestamp accuracy.

#### `scrap_report.php`
- Responsive and centered layout.
- Auto year filter.
- Improved chart resizing and summary placement.

#### `scrap_report.pdf.php`
- Enhanced layout, spacing, and NEOS blue tone.
- Added initials column.
- Improved header/logo alignment.

---

### 🧱 Database Schema

```sql
CREATE TABLE `llx_scrap` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_product` int NOT NULL,
  `fk_warehouse` int NOT NULL,
  `fk_mo` int DEFAULT NULL,
  `qty` double NOT NULL,
  `cost` double NOT NULL DEFAULT '0',
  `reason` varchar(255) DEFAULT NULL,
  `scrap_date` datetime NOT NULL,
  `fk_user_scrap` int DEFAULT NULL,
  `entity` int DEFAULT '1',
  PRIMARY KEY (`rowid`),
  KEY `idx_scrap_entity` (`entity`),
  KEY `idx_scrap_product` (`fk_product`),
  KEY `idx_scrap_warehouse` (`fk_warehouse`),
  KEY `fk_scrap_user_scrap` (`fk_user_scrap`),
  KEY `idx_scrap_mo` (`fk_mo`),
  CONSTRAINT `fk_scrap_mo` FOREIGN KEY (`fk_mo`) REFERENCES `llx_mrp_mo` (`rowid`),
  CONSTRAINT `fk_scrap_product` FOREIGN KEY (`fk_product`) REFERENCES `llx_product` (`rowid`),
  CONSTRAINT `fk_scrap_user_scrap` FOREIGN KEY (`fk_user_scrap`) REFERENCES `llx_user` (`rowid`),
  CONSTRAINT `fk_scrap_warehouse` FOREIGN KEY (`fk_warehouse`) REFERENCES `llx_entrepot` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
```

---

### 💬 Event Messages

```yaml
Scrap Created and Stock Updated  
Product: 1025111 - Gear Assembly  
Warehouse: MAIN  
Qty: 2 | Cost: €10.00 | Total: €20.00  
Reason: Damaged during assembly  
Origin: MO2510-0001 | Inv./Mov. Code: 20251023205307
```

```yaml
Scrap Deleted and Stock Restored  
Product: 1025111 - Gear Assembly  
Qty Restored: 2 | Total Cost: €20.00  
Linked MO: MO2510-0001
```

---

### 🧩 Integration Summary

| Feature | Description | Status |
|----------|--------------|---------|
| Stock movement linkage | `origintype='mo'` | ✅ |
| Inventory code inheritance | From MO consumption | ✅ |
| Scrap → MO link | Auto-detection via `fk_product` | ✅ |
| Stock restore on delete | `MouvementStock::reception()` | ✅ |
| Unified messages | `_showScrapMessage()` | ✅ |
| MO qty update | `qty_scrap` synchronized | ✅ |

---

### 🐛 Bug Fixes

| Issue | Fixed |
|--------|--------|
| Missing MO in Origin column | ✅ |
| Wrong inventory code | ✅ |
| SQL origin_type error | ✅ |
| Call to `idate()` crash | ✅ |
| Missing `setEventMessages` output | ✅ |
| Incorrect stock after SO validation | ✅ |
| Duplicate stock movement | ✅ |

---

### 🧰 Developer Notes

- Logging via `dol_syslog()` for all movements.
- Safe transaction management.
- Use of `price2num()` and `dol_now()` to prevent rounding issues.
- Consistent variable naming and entity handling.

---

### ✅ Testing

| Scenario | Expected | Result |
|-----------|-----------|---------|
| Create scrap linked to MO | Movement shows MO + inventorycode | ✅ |
| Create standalone scrap | Generates new inventorycode | ✅ |
| Delete scrap | Restores stock & reverts MO qty | ✅ |
| Stock Movements | Shows MO + Inv./Mov. | ✅ |
| MO Overview | Correct scrap count | ✅ |

Environment: **Dolibarr v18.0.3 – v22.x**, **PHP 8.2**, **MySQL 8.0**

---

### 🔒 Security Enhancements

- Full CSRF token validation.
- Sanitized inputs via `GETPOST()`.
- Verified user permissions for write actions.
- Blocked direct access without Dolibarr context.

---

### 🔮 Next Planned Features

- CSV and XLSX export for reports.
- User-based scrap statistics.
- Multi-warehouse filters.
- Scrap threshold notifications.
- Integration with BOM tracking.

---

**Maintainer:** Marcin Flaumenhaft  
**Location:** `/htdocs/custom/scrap/`  
**Last Updated:** 2025-10-24
