<?php
// Load Dolibarr environment (3 levels up from /custom/scrap/ajax/)
require '../../../main.inc.php';
require_once DOL_DOCUMENT_ROOT . '/mrp/class/mo.class.php';

top_httphead();
header('Content-Type: application/json');

// Security: ensure user has permission to view MOs
if (empty($user->rights->mrp->read)) {
    echo json_encode(['error' => 'Access denied']);
    exit;
}

$productId = (int) GETPOST('product_id', 'int');
$out = [];

if ($productId > 0) {
    $sql = "SELECT rowid, ref, qty, status
            FROM " . MAIN_DB_PREFIX . "mrp_mo
            WHERE fk_product = " . $productId . "
            ORDER BY date_creation DESC
            LIMIT 5";

    $resql = $db->query($sql);
    if ($resql) {
        while ($obj = $db->fetch_object($resql)) {
            $out[] = [
                'id' => $obj->rowid,
                'ref' => $obj->ref,
                'qty' => $obj->qty,
                'status' => $obj->status
            ];
        }
    } else {
        $out = ['error' => $db->lasterror()];
    }
} else {
    $out = ['error' => 'Invalid product id'];
}

echo json_encode($out);
exit;
