-- llx_scrap.sql
-- =====================================================================
--  Table: llx_scrap
--  Description: Records production scrap and material losses
-- =====================================================================

DROP TABLE IF EXISTS llx_scrap;

CREATE TABLE llx_scrap (
  rowid int NOT NULL AUTO_INCREMENT,
  fk_product int NOT NULL,
  fk_warehouse int NOT NULL,
  qty double NOT NULL,
  cost double NOT NULL DEFAULT '0',
  reason varchar(255) DEFAULT NULL,
  scrap_date datetime NOT NULL,
  fk_user_scrap int DEFAULT NULL,
  entity int DEFAULT '1',
  fk_mo int DEFAULT NULL,
  PRIMARY KEY (rowid),
  KEY idx_scrap_entity (entity),
  KEY idx_scrap_product (fk_product),
  KEY idx_scrap_warehouse (fk_warehouse),
  KEY fk_scrap_user_scrap (fk_user_scrap),
  KEY idx_scrap_mo (fk_mo),
  CONSTRAINT fk_scrap_mo FOREIGN KEY (fk_mo) REFERENCES llx_mrp_mo (rowid),
  CONSTRAINT fk_scrap_product FOREIGN KEY (fk_product) REFERENCES llx_product (rowid),
  CONSTRAINT fk_scrap_user_scrap FOREIGN KEY (fk_user_scrap) REFERENCES llx_user (rowid),
  CONSTRAINT fk_scrap_warehouse FOREIGN KEY (fk_warehouse) REFERENCES llx_entrepot (rowid)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

ALTER TABLE llx_scrap COMMENT = 'Records scrap and material losses for production tracking';
