<?php
require '../../main.inc.php';
require_once DOL_DOCUMENT_ROOT . '/product/stock/class/mouvementstock.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/security.lib.php';

$langs->load("scrap");

if (!$user->rights->scrap->read) accessforbidden();

$action = GETPOST('action', 'alpha');
$id = (int) GETPOST('id', 'int');

if ($action === 'delete' && $id > 0) {
    $token = GETPOST('token', 'alpha');
    if (empty($token) || $token !== $_SESSION['newtoken']) accessforbidden('Invalid CSRF token');

    require_once __DIR__ . '/class/scrap.class.php';
    $scrap = new Scrap($db);
    $scrap->delete($user, $id);
}


/* ---------------------------------------------------------------------
   SEARCH + PAGINATION
--------------------------------------------------------------------- */
$search = trim(GETPOST('search', 'alpha'));
$page = max(0, (int) GETPOST('page', 'int'));
$limit = 20;
$offset = $page * $limit;

$sql = "SELECT s.rowid, s.qty, s.cost, s.reason, s.scrap_date,
               p.rowid as prod_id, p.ref as product_ref, p.label as product_label,
               e.ref as warehouse_ref,
               u.firstname, u.lastname
        FROM " . MAIN_DB_PREFIX . "scrap s
        LEFT JOIN " . MAIN_DB_PREFIX . "product p ON s.fk_product = p.rowid
        LEFT JOIN " . MAIN_DB_PREFIX . "entrepot e ON s.fk_warehouse = e.rowid
        LEFT JOIN " . MAIN_DB_PREFIX . "user u ON s.fk_user_scrap = u.rowid
        WHERE s.entity = " . ((int)$conf->entity);

if ($search) {
    $sql .= " AND (p.ref LIKE '%" . $db->escape($search) . "%'
              OR p.label LIKE '%" . $db->escape($search) . "%'
              OR s.reason LIKE '%" . $db->escape($search) . "%')";
}
$sql .= " ORDER BY s.scrap_date DESC LIMIT $limit OFFSET $offset";
$resql = $db->query($sql);

llxHeader('', $langs->trans("ScrapManagement"));
print load_fiche_titre($langs->trans("ScrapManagement"));

/* ---------------------------------------------------------------------
   ACTION BUTTONS BAR
--------------------------------------------------------------------- */
print '<div class="tabsAction" style="display:flex; justify-content:space-between; flex-wrap:wrap; gap:10px; align-items:center;">';

/* Add Scrap */
print '<a class="butAction" href="' . DOL_URL_ROOT . '/custom/scrap/scrap_new.php">' . $langs->trans("AddScrap") . '</a>';

/* Search */
print '<form method="GET" action="' . $_SERVER["PHP_SELF"] . '" style="display:flex; gap:6px; align-items:center;">';
print '<input type="text" name="search" placeholder="' . $langs->trans("Search") . '" value="' . dol_escape_htmltag($search) . '" style="height:30px;">';
print '<input type="submit" class="butAction" value="' . $langs->trans("Search") . '">';
if ($search) {
    print '<a class="butActionDelete" href="' . $_SERVER["PHP_SELF"] . '">' . $langs->trans("ResetFilter") . '</a>';
}
print '</form>';
print '</div><br>';

/* ---------------------------------------------------------------------
   SCRAP TABLE
--------------------------------------------------------------------- */
print '<div class="div-table-responsive">';
print '<table class="noborder centpercent">';
print '<tr class="liste_titre">';
print '<th>' . $langs->trans('Product') . '</th>';
print '<th>' . $langs->trans('Warehouse') . '</th>';
print '<th class="right">' . $langs->trans('Qty') . '</th>';
print '<th class="right">' . $langs->trans('Unit Cost') . '</th>';
print '<th class="right">' . $langs->trans('Total Cost') . '</th>';
print '<th>' . $langs->trans('Reason') . '</th>';


print '<th>' . $langs->trans("Date") . '</th>';
print '<th>' . $langs->trans("AddedBy") . '</th>';
print '<th class="center">' . $langs->trans("Events") . '</th>';
print '</tr>';

// ✅ initialize total sum
$sumTotalCost = 0;

if ($resql && $db->num_rows($resql) > 0) {

    while ($obj = $db->fetch_object($resql)) {
        $totalCost = price2num($obj->qty * $obj->cost, 'MU');
        $sumTotalCost += $totalCost;
        $userInitials = ($obj->firstname || $obj->lastname)
            ? strtoupper(substr($obj->firstname, 0, 1) . substr($obj->lastname, 0, 1))
            : '';
        $qtyDisplay = (fmod($obj->qty, 1) == 0) ? intval($obj->qty) : rtrim(rtrim(number_format($obj->qty, 2, '.', ''), '0'), '.');

        print '<tr class="oddeven">';
        print '<td><a href="' . DOL_URL_ROOT . '/product/card.php?id=' . $obj->prod_id . '">' . dol_escape_htmltag($obj->product_ref) . '</a></td>';
        print '<td>' . dol_escape_htmltag($obj->warehouse_ref) . '</td>';
        print '<td class="right">' . $qtyDisplay . '</td>';
        print '<td class="right">' . price($obj->cost, 0, $langs, 0, 0, 0, $conf->currency) . '</td>';
        $totalCost = price2num($obj->qty * $obj->cost, 'MU');
        print '<td class="right">' . price($totalCost, 0, $langs, 0, 0, 0, $conf->currency) . '</td>';
        print '<td>' . dol_escape_htmltag($obj->reason) . '</td>';
        print '<td>' . dol_print_date(dol_stringtotime($obj->scrap_date), 'dayhour') . '</td>';
        print '<td class="center">' . $userInitials . '</td>';
        print '<td class="center">
            <a href="#" class="butActionDelete"
                onclick="confirmDelete(' . (int)$obj->rowid . ',
                \'' . dol_escape_js($obj->product_ref) . '\',
                ' . (float)$obj->qty . ',
                ' . (float)$obj->cost . ',
                \'' . dol_escape_js($obj->reason) . '\',
                \'' . dol_escape_js(dol_print_date(dol_stringtotime($obj->scrap_date), 'dayhour')) . '\')">'
                . $langs->trans("Delete") .
            '</a></td>';
        print '</tr>';
    }
} else {
    print '<tr><td colspan="8" class="center opacitymedium">' . $langs->trans("NoScrapFound") . '</td></tr>';
}

// --- Totals row ---
print '<tr class="liste_total">';
print '<td colspan="4" class="right"><strong>' . $langs->trans('Total Cost') . '</strong></td>';
print '<td class="right"><strong>' . price($sumTotalCost, 0, $langs, 0, 0, 0, $conf->currency) . '</strong></td>';
print '<td colspan="4"></td>';
print '</tr>';

print '</table>';
print '</div>';

/* ---------------------------------------------------------------------
   PAGINATION
--------------------------------------------------------------------- */
print '<div class="pagination" style="margin-top:10px; text-align:center;">';
if ($page > 0) print '<a class="button" href="' . $_SERVER["PHP_SELF"] . '?page=' . ($page - 1) . '&search=' . urlencode($search) . '">&lt; ' . $langs->trans("Previous") . '</a> ';
if ($resql && $db->num_rows($resql) == $limit)
    print '<a class="button" href="' . $_SERVER["PHP_SELF"] . '?page=' . ($page + 1) . '&search=' . urlencode($search) . '">' . $langs->trans("Next") . ' &gt;</a>';
print '</div>';

?>

<!-- ---------------------------------------------------------------------
   STYLES + POPUP
--------------------------------------------------------------------- -->
<style>
#scrapConfirmOverlay {
    display:none;
    position:fixed;
    top:0; left:0; width:100%; height:100%;
    background:rgba(0,0,0,0.6);
    justify-content:center;
    align-items:center;
    z-index:9999;
    animation: fadeIn 0.25s ease-in;
}
#scrapConfirmBox {
    background:#fff;
    padding:22px;
    border-radius:12px;
    width:90%;
    max-width:440px;
    box-shadow:0 8px 20px rgba(0,0,0,0.4);
    border-top:5px solid #0B58B6;
    animation: slideUp 0.3s ease-out;
}
#scrapConfirmBox h3 {
    margin-top:0;
    font-size:16px;
    color:#0B58B6;
}
#scrapConfirmBox table td {
    padding:4px 6px;
}
#scrapConfirmBox .button-bar {
    margin-top:15px;
    text-align:right;
}
@keyframes fadeIn { from {opacity:0;} to {opacity:1;} }
@keyframes slideUp { from {transform:translateY(30px);} to {transform:translateY(0);} }
</style>

<div id="scrapConfirmOverlay">
    <div id="scrapConfirmBox">
        <h3><?php echo $langs->trans("ConfirmDeletion"); ?></h3>
        <div id="scrapConfirmMessage"></div>
        <div class="button-bar">
            <button class="butActionDelete" id="confirmDeleteYes"><?php echo $langs->trans("Delete"); ?></button>
            <button class="butAction" id="confirmDeleteNo"><?php echo $langs->trans("Cancel"); ?></button>
        </div>
    </div>
</div>

<script>
function confirmDelete(id, ref, qty, cost, reason, date) {
    const overlay = document.getElementById('scrapConfirmOverlay');
    const msgBox = document.getElementById('scrapConfirmMessage');
    msgBox.innerHTML = `
        <table class="noborder centpercent" style="width:100%;">
            <tr><td><b>Product:</b></td><td>${ref}</td></tr>
            <tr><td><b>Qty:</b></td><td>${qty}</td></tr>
            <tr><td><b>Cost:</b></td><td>${cost}</td></tr>
            <tr><td><b>Reason:</b></td><td>${reason}</td></tr>
            <tr><td><b>Date:</b></td><td>${date}</td></tr>
        </table>
        <br><i>This will restore the stock quantity for this product.</i>
    `;
    overlay.style.display = 'flex';
    document.getElementById('confirmDeleteYes').onclick = () => {
        window.location.href = '<?php echo $_SERVER["PHP_SELF"]; ?>?action=delete&id=' + id + '&token=<?php echo $_SESSION["newtoken"]; ?>';
    };
    document.getElementById('confirmDeleteNo').onclick = () => overlay.style.display = 'none';
}
</script>

<?php
llxFooter();
$db->close();
?>
