<?php
// Load Dolibarr environment
$res = @include '../../main.inc.php';  // Path may vary depending on your setup
if (!$res) {
    die("Cannot load main.inc.php. Check path.");
}

global $db, $conf;

echo "<h2>🔧 Scrap Module Diagnostic</h2>";

// Module folder and const name
$module_dir = 'scrap';
$const_name = 'MAIN_MODULE_SCRAP';
$mod_file   = DOL_DOCUMENT_ROOT . "/custom/{$module_dir}/core/modules/modScrap.class.php";

echo "<p><strong>Checking module file:</strong> {$mod_file}</p>";
if (file_exists($mod_file)) {
    echo "<p style='color:green;'>✅ Module descriptor found</p>";
    include_once $mod_file;
    if (class_exists('modScrap')) {
        echo "<p style='color:green;'>✅ modScrap class loaded</p>";
    } else {
        echo "<p style='color:red;'>❌ modScrap class NOT found in file</p>";
    }
} else {
    echo "<p style='color:red;'>❌ Module descriptor file not found</p>";
}

// Check constant in llx_const
$sql = "SELECT * FROM " . MAIN_DB_PREFIX . "const WHERE name = '".$db->escape($const_name)."'";
$resql = $db->query($sql);

if ($resql) {
    $row = $db->fetch_object($resql);
    if ($row) {
        echo "<h3>🧩 Module Constant Found</h3>";
        echo "<ul>
                <li>Name: <strong>{$row->name}</strong></li>
                <li>Value: <strong>{$row->value}</strong></li>
                <li>Visible: {$row->visible}</li>
                <li>Entity: {$row->entity}</li>
              </ul>";
        if ($row->value == '1') {
            echo "<p style='color:green;'>✅ Module is marked as ACTIVE in database</p>";
        } else {
            echo "<p style='color:orange;'>⚠️ Module is INACTIVE (value is '{$row->value}')</p>";
        }
    } else {
        echo "<p style='color:red;'>❌ Constant <strong>$const_name</strong> not found in llx_const</p>";
    }
} else {
    echo "<p style='color:red;'>❌ SQL error while querying llx_const</p>";
}

// Additional constants check
echo "<h3>🔍 Related constants:</h3>";
$sql2 = "SELECT name, value FROM " . MAIN_DB_PREFIX . "const WHERE name LIKE 'MAIN_MODULE_%'";
$resql2 = $db->query($sql2);
if ($resql2) {
    echo "<ul>";
    while ($obj = $db->fetch_object($resql2)) {
        echo "<li>{$obj->name} = {$obj->value}</li>";
    }
    echo "</ul>";
} else {
    echo "<p>❌ Could not query additional constants.</p>";
}

echo "<hr><p><em>Script by ChatGPT • ".date('Y-m-d H:i:s')."</em></p>";
?>

