<?php
if (! defined('DOL_DOCUMENT_ROOT')) {
    die('Environment not included');
}

require_once DOL_DOCUMENT_ROOT . '/core/modules/DolibarrModules.class.php';

class modScrap extends DolibarrModules
{
    public array $sqlcreate = [];
    public array $sqlupdate = [];
    public function __construct($db)
    {
        $this->db = $db;

        $this->numero = 110000;  // unique number
        $this->rights_class = 'scrap';
//        $this->rights_class = $langs->trans("scrap");
        $this->family = "products";
        $this->name = "scrap";  // MUST match folder name
        $this->description = "Module to manage scrap/waste";
        $this->editor_name = "Marcin Flaumenhaft";
//        $this->changelog = DOL_DOCUMENT_ROOT . '/custom/scrap/ChangeLog.md';
        $this->version = '2.1.0';  // or your next release version

        // SQL files
        $this->sqlcreate = array(
            'llx_scrap.sql'        // base creation script
        );

        $this->sqlupdate = array(
            'llx_scrap_cleanup.sql',  // ensures structure cleanup
            'llx_scrap_verify.sql'    // runs verification (non-destructive)
        );

        $this->const_name = 'MAIN_MODULE_SCRAP';  // MUST match folder name
        $this->picto = 'delete';

        $this->dirs = array('/scrap/temp');
//        $this->config_page_url = array('admin/scrap_setup.php@scrap');

        $this->depends = array('modProduct');
//        $this->required_by = array();
//        $this->conflict_with = array();
        $this->langfiles = array('scrap@scrap');

        $this->module_parts = array(
            'models' => 1,
            'menus' => 1,
            'css' => array('/scrap/css/qualitymenu.css.php')
);

        $this->rights = array();
        $r = 0;

        $this->rights[$r][0] = 110001;
        $this->rights[$r][1] = 'Read scrap records';
        $this->rights[$r][2] = 'r';
        $this->rights[$r][3] = 1;
        $this->rights[$r][4] = 'read';
        $r++;

        $this->rights[$r][0] = 110002;
        $this->rights[$r][1] = 'Create / Update scrap records';
        $this->rights[$r][2] = 'w';
        $this->rights[$r][3] = 1;
        $this->rights[$r][4] = 'write';
        $r++;

        $this->menu = array();

        // --- Top menu: Quality (new main menu)
        // Creates a new top menu entry called "Quality" and moves Scrap under it.
        $this->menu[] = array(
            'fk_menu' => 0,
            'type' => 'top',
            'titre' => 'Quality',
            'mainmenu' => 'quality',
            'leftmenu' => 'scrap',
            'url' => '/custom/scrap/scrap_index.php',
            'langs' => 'scrap@scrap',
            'position' => 25,
            'enabled' => '$conf->scrap->enabled',
            'perms' => '$user->rights->scrap->read',
            'target' => '',
            'user' => 2,
            'topmenuicon' => '/custom/scrap/img/quality.svg',
            'picto' => 'quality@scrap'
        );

        // Left menu entries under Quality
        $this->menu[] = array(
            'fk_menu' => 'fk_mainmenu=quality',
            'type' => 'left',
            'titre' => 'Scrap',
            'mainmenu' => 'quality',
            'leftmenu' => 'scrap',
            'url' => '/custom/scrap/scrap_index.php',
            'langs' => 'scrap@scrap',
            'position' => 100,
            'enabled' => '$conf->scrap->enabled',
            'perms' => '$user->rights->scrap->read',
            'target' => '',
            'user' => 2,
            'topmenuicon' => '/custom/scrap/img/quality.svg'
        );

        $this->menu[] = array(
            'fk_menu' => 'fk_mainmenu=quality,fk_leftmenu=scrap',
            'type' => 'left',
            'titre' => 'Report',
            'mainmenu' => 'quality',
            'leftmenu' => 'scrap',
            'url' => '/custom/scrap/scrap_report.php',
            'langs' => 'scrap@scrap',
            'position' => 110,
            'enabled' => '$conf->scrap->enabled',
            'perms' => '$user->rights->scrap->read',
            'target' => '',
            'user' => 2,
            'topmenuicon' => '/custom/scrap/img/quality.svg'
        );
    }

    public function init($options = '')
    {
        $result = $this->_load_tables('/scrap/sql/');
        return $this->_init(array(), $options) && $result >= 0 ? 1 : -1;
    }

    public function remove($options = '')
    {
        return $this->_remove(array(), $options);
    }
}
