<?php
if (! defined('DOL_DOCUMENT_ROOT')) {
    define('DOL_DOCUMENT_ROOT', realpath(__DIR__ . '/../../../../'));
}

require_once DOL_DOCUMENT_ROOT . '/core/class/commondocgenerator.class.php';

class pdf_scrapreport extends CommonDocGenerator
{
    public $name = 'scrapreport';
    public $description = 'Scrap Report PDF';
    public $type = 'pdf';

    public function __construct($db)
    {
        $this->db = $db;
    }

    public function write_file($object, $langs, $srctemplatepath, $hidedetails = 0, $hidedesc = 0, $hideref = 0)
    {
        global $conf;

        $year = GETPOST('year', 'int');
        $month = GETPOST('month', 'int');

        $sql = "SELECT YEAR(s.scrap_date) AS y, MONTH(s.scrap_date) AS m,
                       SUM(s.qty) AS total_qty, SUM(s.cost) AS total_cost
                FROM " . MAIN_DB_PREFIX . "scrap s
                WHERE s.entity = " . $conf->entity;
        $sql .= " AND YEAR(s.scrap_date) = " . $year;
        if ($month > 0) {
            $sql .= " AND MONTH(s.scrap_date) = " . $month;
        }
        $sql .= " GROUP BY YEAR(s.scrap_date), MONTH(s.scrap_date)
                  ORDER BY YEAR(s.scrap_date), MONTH(s.scrap_date)";

        $res = $this->db->query($sql);
        if (! $res) {
            $this->error = $this->db->lasterror();
            return -1;
        }

        $pdf = pdf_getInstance();
        $default_font_size = pdf_getPDFFontSize($langs);
        $pdf->SetAutoPageBreak(true, 10);
        $pdf->SetFont(pdf_getPDFFont($langs), '', $default_font_size);
        $pdf->AddPage();

        $pdf->SetFont('', 'B', $default_font_size + 2);
        $title = $langs->trans('ScrapReport') . ' ' . $year;
        if ($month > 0) {
            $title .= ' / ' . $month;
        }
        $pdf->MultiCell(0, 7, $title, 0, 'C');
        $pdf->Ln(5);
        $pdf->SetFont('', '', $default_font_size);

        $pdf->SetDrawColor(0, 0, 0);
        $pdf->SetFillColor(230, 230, 230);
        $pdf->Cell(30, 7, $langs->trans('Year'), 1, 0, 'C', 1);
        $pdf->Cell(30, 7, $langs->trans('Month'), 1, 0, 'C', 1);
        $pdf->Cell(40, 7, $langs->trans('TotalQty'), 1, 0, 'C', 1);
        $pdf->Cell(40, 7, $langs->trans('TotalCost'), 1, 1, 'C', 1);

        while ($row = $this->db->fetch_object($res)) {
            $pdf->Cell(30, 7, $row->y, 1);
            $pdf->Cell(30, 7, $row->m, 1);
            $pdf->Cell(40, 7, $row->total_qty, 1);
            $pdf->Cell(40, 7, price($row->total_cost), 1);
            $pdf->Ln();
        }

        if (ob_get_length()) {
            ob_end_clean();
        }
        $filename = "scrapreport_" . $year;
        if ($month > 0) {
            $filename .= "_" . $month;
        }
        $filename .= ".pdf";

        return $pdf->Output($filename, 'I');
    }
}
