<?php
require '../../main.inc.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/date.lib.php';

global $db, $langs, $user, $conf;
$langs->load("scrap@scrap");

// -------------------- FILTERS --------------------
$start_date = GETPOST('start_date', 'alpha');
$end_date   = GETPOST('end_date', 'alpha');
$yearchart  = GETPOST('yearchart', 'int');

if (empty($yearchart))  $yearchart = date('Y');
if (empty($start_date)) $start_date = $yearchart . '-01-01';
if (empty($end_date))   $end_date   = $yearchart . '-12-31';

// -------------------- HEADER --------------------
llxHeader('', $langs->trans("Scrap Report"));

print '<link rel="stylesheet" type="text/css" href="/custom/scrap/css/scrap_report_responsive.css">';
print '<div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:10px;">';
print load_fiche_titre($langs->trans("Scrap Report"), '', 'title_generic.png');

// summary box top-right
print '<div style="border:1px solid #ccc; border-radius:6px; padding:10px 15px; width:260px; font-size:12px; text-align:center; box-shadow:0 1px 2px rgba(0,0,0,0.1);">';
print '<div style="color:#555; font-weight:bold;">Selected Range</div>';
print '<div style="margin-top:5px;"><strong>' . dol_escape_htmltag($start_date) . ' → ' . dol_escape_htmltag($end_date) . '</strong></div>';
print '<div id="scrapSummaryQty" style="margin-top:8px; color:#333;">Total Scrap Qty: <strong>0.0</strong></div>';
print '<div id="scrapSummaryCost" style="margin-top:4px; color:#333;">Total Scrap Cost: <strong>£0.00</strong></div>';
print '</div>';
print '</div>';

// -------------------- FILTER FORM --------------------
print '<form method="GET" action="' . $_SERVER["PHP_SELF"] . '" style="margin-bottom:5px;">';
print '<table class="noborder nohover" style="width:100%; border:none;"><tr>';

print '<td style="white-space:nowrap;">';
print '<strong>From</strong> <input type="date" name="start_date" value="' . dol_escape_htmltag($start_date) . '" class="flat">';
print ' <strong>To</strong> <input type="date" name="end_date" value="' . dol_escape_htmltag($end_date) . '" class="flat">';
print '</td>';

print '<td style="white-space:nowrap; padding-left:15px;">';
print '<strong>Year</strong> ';
print '<select name="yearchart" class="flat" style="min-width:80px;">';
for ($y = date('Y') - 5; $y <= date('Y') + 1; $y++) {
    $selected = ($yearchart == $y ? ' selected' : '');
    print '<option value="' . $y . '"' . $selected . '>' . $y . '</option>';
}
print '</select>';
print '</td>';

print '<td style="text-align:right;">';
print '<button type="submit" class="button">' . $langs->trans("Filter") . '</button> ';
print '<button type="button" class="butAction" onclick="generatePDF()">' . $langs->trans("Generate PDF") . '</button>';
print '</td>';

print '</tr></table></form>';

// auto update range by year
print '
<script>
document.addEventListener("DOMContentLoaded", function () {
    const form = document.querySelector(\'form[action*="scrap_report.php"]\');
    const yearSelect = document.querySelector(\'select[name="yearchart"]\');
    const startDate = document.querySelector(\'input[name="start_date"]\');
    const endDate = document.querySelector(\'input[name="end_date"]\');

    if (yearSelect && startDate && endDate && form) {
        yearSelect.addEventListener("change", function () {
            const year = parseInt(this.value);
            if (year && !isNaN(year)) {
                startDate.value = `${year}-01-01`;
                endDate.value = `${year}-12-31`;
                form.submit();
            }
        });
    }
});
</script>
';

// -------------------- DATA QUERY --------------------
$sql = "SELECT 
            p.ref as product_ref,
            p.label as product_label,
            e.ref as warehouse_label,
            s.qty, s.cost, s.reason, s.scrap_date
        FROM " . MAIN_DB_PREFIX . "scrap as s
        LEFT JOIN " . MAIN_DB_PREFIX . "product as p ON s.fk_product = p.rowid
        LEFT JOIN " . MAIN_DB_PREFIX . "entrepot as e ON s.fk_warehouse = e.rowid
        WHERE s.entity = " . (int) $conf->entity . "
          AND s.scrap_date >= '" . $db->idate(dol_mktime(0,0,0,substr($start_date,5,2),substr($start_date,8,2),substr($start_date,0,4))) . "'
          AND s.scrap_date <= '" . $db->idate(dol_mktime(23,59,59,substr($end_date,5,2),substr($end_date,8,2),substr($end_date,0,4))) . "'
        ORDER BY s.scrap_date ASC";

$resql = $db->query($sql);

$total_scrap = 0;
$total_cost  = 0;
$monthly_qty  = array_fill(1, 12, 0);
$monthly_cost = array_fill(1, 12, 0);

if ($resql) {
    while ($obj = $db->fetch_object($resql)) {
        $month = (int) date('n', strtotime($obj->scrap_date));
        $monthly_qty[$month]  += $obj->qty;
        $monthly_cost[$month] += ($obj->qty * $obj->cost);
        $total_scrap += $obj->qty;
        $total_cost  += ($obj->qty * $obj->cost);
    }
}
$db->free($resql);

// -------------------- UPDATE SUMMARY --------------------
print '<script>
document.getElementById("scrapSummaryQty").innerHTML = "Total Scrap Qty: <strong>' . price($total_scrap, 0, '', 1, 1) . '</strong>";
document.getElementById("scrapSummaryCost").innerHTML = "Total Scrap Cost: <strong>£' . number_format($total_cost, 2) . '</strong>";
</script>';

// -------------------- CHARTS --------------------
print '<div style="margin-top:5px;">';
print '<h3 style="border-bottom:2px solid #CCC; margin-bottom:10px;">Scrap Overview for ' . $yearchart . '</h3>';
print '<canvas id="scrapChartQty" style="width:100%; height:320px; margin-bottom:40px;"></canvas>';
print '<canvas id="scrapChartCost" style="width:100%; height:320px;"></canvas>';
print '</div>';

print '
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const months = ["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"];

// Chart 1 - Scrap Quantity
new Chart(document.getElementById("scrapChartQty"), {
    type: "bar",
    data: {
        labels: months,
        datasets: [{
            label: "Scrap Quantity",
            data: ' . json_encode(array_values($monthly_qty)) . ',
            backgroundColor: "rgba(54, 162, 235, 0.6)",
            borderColor: "rgba(54, 162, 235, 1)",
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
        plugins: {
            title: { display: true, text: "Scrap Quantity per Month", font: { size: 16 } },
            legend: { display: false }
        },
        scales: { y: { beginAtZero: true } }
    }
});

// Chart 2 - Scrap Cost (£)
new Chart(document.getElementById("scrapChartCost"), {
    type: "line",
    data: {
        labels: months,
        datasets: [{
            label: "Scrap Cost (£)",
            data: ' . json_encode(array_values($monthly_cost)) . ',
            borderColor: "#28a745",
            backgroundColor: "rgba(40,167,69,0.3)",
            fill: true,
            tension: 0.3,
            pointRadius: 4,
            pointHoverRadius: 6
        }]
    },
    options: {
        responsive: true,
        plugins: {
            title: { display: true, text: "Scrap Cost per Month (£)", font: { size: 16 } },
            legend: { display: false }
        },
        scales: { y: { beginAtZero: true } }
    }
});
</script>
';

// -------------------- PDF GENERATION FUNCTION --------------------
print '
<script>
function generatePDF() {
    const start = document.querySelector(\'input[name="start_date"]\').value;
    const end   = document.querySelector(\'input[name="end_date"]\').value;
    const year  = document.querySelector(\'select[name="yearchart"]\').value;

    if (!start || !end) {
        alert("Please select a valid date range before generating the PDF.");
        return;
    }

    const url = "scrap_report.pdf.php?start_date=" + encodeURIComponent(start)
              + "&end_date=" + encodeURIComponent(end)
              + "&yearchart=" + encodeURIComponent(year);
    window.open(url, "_blank");
}
</script>
';

llxFooter();
$db->close();
?>
