<?php
require '../../main.inc.php';
require_once DOL_DOCUMENT_ROOT . '/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT . '/product/class/html.formproduct.class.php';
require_once DOL_DOCUMENT_ROOT . '/product/stock/class/entrepot.class.php';

require_once __DIR__ . '/class/scrap.class.php';

$langs->load('scrap@scrap');
$langs->load('products');
$langs->load('stocks');

if (empty($user->rights->scrap->write)) {
    accessforbidden();
}

$action = GETPOST('action', 'alpha');
$errors = array();

$form = new Form($db);
$formproduct = new FormProduct($db);

// --- Load scrap reasons from JSON ---
$reasons_path = DOL_DOCUMENT_ROOT . '/custom/scrap/reasons.json';
$scrap_reasons = array();
if (file_exists($reasons_path)) {
    $json = file_get_contents($reasons_path);
    $scrap_reasons = json_decode($json, true);
} else {
    // fallback message
    $scrap_reasons = array();
}

// --- Helper for CSRF token compatibility ---
function scrap_form_token($form)
{
    if (method_exists($form, 'token')) {
        return $form->token();
    } elseif (!empty($_SESSION['newtoken'])) {
        return '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
    } else {
        $_SESSION['newtoken'] = bin2hex(random_bytes(16));
        return '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
    }
}

// --- Form processing ---
if ($action === 'add') {
    $scrap = new Scrap($db);
    $scrap->fk_product   = GETPOST('fk_product', 'int');
    $scrap->fk_warehouse = GETPOST('fk_warehouse', 'int');
    $scrap->qty          = (float) str_replace(',', '.', trim(GETPOST('qty', 'alpha')));
    $scrap->cost         = (float) str_replace(',', '.', trim(GETPOST('cost', 'alpha')));
    $scrap->reason       = GETPOST('reason', 'alpha');
    $scrap->scrap_date   = dol_stringtotime(GETPOST('scrap_date', 'alpha')); // convert to timestamp
    $scrap->fk_mo = GETPOST('fk_mo', 'int');

    if ($scrap->qty <= 0) $errors[] = $langs->trans('QtyMustBePositive');
    if ($scrap->cost < 0) $errors[] = $langs->trans('CostMustNotBeNegative');
    if (empty($scrap->scrap_date)) $errors[] = $langs->trans('NoDate');
    if (empty($scrap->fk_product)) $errors[] = $langs->trans('ProductRequired');
    if (empty($scrap->fk_warehouse)) $errors[] = $langs->trans('WarehouseRequired');

    if (empty($errors)) {
        $res = $scrap->create($user);
        if ($res > 0) {
            header('Location: scrap_index.php');
            exit;
        } else {
            $errors[] = $langs->trans("ErrorDuringScrapCreation") . ': ' . $scrap->error;
        }
    }
}

// --- Page rendering ---
llxHeader('', $langs->trans('Add New Scrap'));
print load_fiche_titre($langs->trans('Add New Scrap'), '', 'stock');

// Show any validation or database errors
if (!empty($errors)) {
    print '<div class="error">';
    foreach ($errors as $e) print dol_escape_htmltag($e) . '<br>';
    print '</div>';
}

// --- Form start ---
print '<form method="POST" action="scrap_new.php">';
print '<input type="hidden" name="action" value="add">';
print scrap_form_token($form);

print '<table class="noborder centpercent">';

// --- Product dropdown (Live Stock) ---
print '<tr><td class="fieldrequired">' . $langs->trans('Product') . '</td><td>';

$sqlstock = "SELECT p.rowid, p.ref, p.label, p.price, COALESCE(SUM(ps.reel),0) as stock
             FROM " . MAIN_DB_PREFIX . "product as p
             LEFT JOIN " . MAIN_DB_PREFIX . "product_stock as ps ON ps.fk_product = p.rowid
             WHERE p.tosell = 1
             GROUP BY p.rowid, p.ref, p.label, p.price
             ORDER BY p.ref ASC";
$resql = $db->query($sqlstock);

if ($resql) {
    print '<select name="fk_product" id="fk_product" class="minwidth300">';
    print '<option value="">-- ' . $langs->trans('SelectProduct') . ' --</option>';
    while ($obj = $db->fetch_object($resql)) {
        $selected = ($obj->rowid == GETPOST('fk_product', 'int')) ? 'selected' : '';
        $price = price($obj->price);
        print '<option value="' . (int)$obj->rowid . '" ' . $selected . '>';
        print dol_escape_htmltag($obj->ref . ' - ' . $obj->label . ' - £' . $price . ' - ' . $langs->trans('Stock') . ': ' . (int)$obj->stock);
        print '</option>';
    }
    print '</select>';
} else {
    print '<span class="error">' . dol_escape_htmltag($langs->trans("ErrorLoadingProducts")) . '</span>';
}
print '</td></tr>';

// --- Warehouse dropdown ---
print '<tr><td class="fieldrequired">' . $langs->trans('Warehouse') . '</td><td>';
print $formproduct->selectWarehouses('', 'fk_warehouse', '', 1);
print '</td></tr>';

// --- Qty and Cost ---
print '<tr><td class="fieldrequired">' . $langs->trans('Qty') . '</td><td>';
print '<input name="qty" type="number" step="any" min="0" class="minwidth100" required></td></tr>';
print '<tr><td>' . $langs->trans('Cost') . '</td><td>';
print '<input name="cost" type="number" step="any" min="0" class="minwidth100"></td></tr>';

// --- Reason dropdown ---
print '<tr><td>' . $langs->trans('Reason') . '</td><td>';
print '<select name="reason" class="minwidth300">';
print '<option value="">-- ' . $langs->trans('SelectScrapReason') . ' --</option>';
foreach ($scrap_reasons as $r) {
    if (isset($r['code'], $r['label'])) {
        $val = $r['code'] . ' - ' . $r['label'];
        print '<option value="' . dol_escape_htmltag($val) . '">' . dol_escape_htmltag($val) . '</option>';
    }
}
print '</select></td></tr>';

// --- Date ---
print '<tr><td class="fieldrequired">' . $langs->trans('Date') . '</td><td>';
print '<input name="scrap_date" type="datetime-local" class="minwidth200" required>';
print '</td></tr>';

print '</table>';
print '<br><div class="center">';
print '<input type="submit" class="button" value="' . $langs->trans('Create') . '">';
print '</div>';
print '</form>';

// --- Auto-load related Manufacturing Orders (MO) when selecting product ---
print '<script>
document.addEventListener("DOMContentLoaded", function() {
    const productSelect = document.querySelector("select[name=fk_product]");
    if (!productSelect) return;

    // Create container for MO dropdown
    const moContainer = document.createElement("div");
    moContainer.id = "moInfo";
    moContainer.style.marginTop = "10px";
    productSelect.parentNode.appendChild(moContainer);

    // Listen for product selection change
    productSelect.addEventListener("change", function() {
        const productId = productSelect.value;
        moContainer.innerHTML = "";
        if (!productId) return;

        // Show loading indicator
        moContainer.innerHTML = \'<div class="opacitymedium">Loading Manufacturing Orders...</div>\';

        fetch("ajax/get_mo_by_product.php?product_id=" + productId)
            .then(response => response.json())
            .then(data => {
                if (data.error) {
                    moContainer.innerHTML = \'<div class="error">\' + data.error + \'</div>\';
                    return;
                }
                if (data.length === 0) {
                    moContainer.innerHTML = \'<div class="opacitymedium">No Manufacturing Orders found for this product.</div>\';
                    return;
                }

                // Build dropdown
                let html = \'<label><strong>Manufacturing Order:</strong></label><br>\';
                html += \'<select name="fk_mo" class="minwidth300">\';
                html += \'<option value="">-- Select MO --</option>\';
                data.forEach(mo => {
                    html += `<option value="${mo.id}">${mo.ref} (Qty: ${mo.qty})</option>`;
                });
                html += \'</select>\';
                moContainer.innerHTML = html;
            })
            .catch(() => {
                moContainer.innerHTML = \'<div class="error">Error loading Manufacturing Orders.</div>\';
            });
    });
});
</script>';

llxFooter();
$db->close();
